/**
 * JOnAS Configurator
 * Copyright (C) 2008-2010 Bull S.A.S.
 * Copyright (C) 2008-2010 France Telecom R&D
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JonasConfigurator.java 21899 2011-11-07 21:06:18Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.tools.configurator.api;

/**
 * Interface who defines the method that could be called to configure the JOnAS
 * server.
 * 
 * @author Remy Bresson
 */
public interface JonasConfigurator {

    /* ------------------------------- */
    /* Jonas global parameters */

    /**
     * Apply the configuration
     */
    void execute();

    /**
     * [global parameters] Set the jdk path
     * 
     * @param jdk The jdk path
     */
    void setJdk(String jdk);

    /**
     * [global parameters] Set the java environment to set
     * 
     * @param javaOpts The java environment
     */
    void setJavaOpts(String javaOpts);

    /**
     * [global parameters] Set the jonas base path
     * 
     * @param jonasBase The jonas base path
     */
    void setJonasBase(String jonasBase);

    /**
     * [global parameters] Set the jonas instance name
     * 
     * @param jonasName The jonas instance name
     */
    void setJonasName(String jonasName);

    /**
     * [global parameters] Set the domain name for the jonas instance.
     * 
     * @param jonasDomain The domain name
     */
    void setJonasDomain(String jonasDomain);

    /**
     * [global parameters] Set the ip alias or ip address
     * 
     * @param jonasHost ip alias or ip address
     */
    void setHost(String jonasHost);

    /**
     * [global parameters] Set the jonas.development option
     * 
     * @param development jonas.development option
     */
    void setJonasDevelopment(boolean development);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Jonas protocols configuation */
    /**
     * [protocols] Set the initial protocols when JOnAS start.
     * 
     * @param protocolsList The protocols list.
     */
    void setProtocolsList(String protocolsList);

    /**
     * [protocols] Set the irmi port
     * 
     * @param irmiPort The irmi port
     */
    void setProtocolsIrmiPort(String irmiPort);

    /**
     * [protocols] Set the iiop port
     * 
     * @param irmiPort The iiop port
     */
    void setProtocolsIiopPort(String iiop);

    /**
     * [protocols] Set the jrmp port
     * 
     * @param jrmpPort The jrmp port
     */
    void setProtocolsJrmpPort(String jrmpPort);

    /**
     * [protocols] Set the cmi port
     * 
     * @param cmiPort The cmi port
     */
    void setProtocolsCmiPort(String cmiPort);

    /**
     * [protocols] Enable or disable optimization for local call
     * 
     * @param localCallOptimized true or false
     */
    void setProtocolsLocalCallOptimized(Boolean localCallOptimized);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Active services */
    /**
     * [services] Set the active services list
     * 
     * @param services List of the services to activated, sepated by comma.
     */
    void setServices(String services);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Service web configuration */
    /**
     * [web] Set the web container
     * 
     * @param webContainer The web container
     */
    void setWebcontainer(String webContainer);

    /**
     * [web] Enable or disable https connector
     * 
     * @param activation true or false
     */
    void setHttpsConnectorActivation(Boolean activation);

    /**
     * [web] Enable or disable https connector
     * 
     * @param activation true or false
     */
    void setAjpConnectorActivation(Boolean activation);

    /**
     * [web] Enable or disable http session replication
     * 
     * @param activation true or false
     */
    void setHttpSessionReplicationActivation(Boolean activation);

    /**
     * [web] Set the http connector port
     * 
     * @param httpPort The http connector port
     */
    void setHttpPort(String httpPort);

    /**
     * [web] Set the max number of connections for http connector
     * 
     * @param httpMaxThreads Max number of connections
     */
    void setHttpMaxThreads(String httpMaxThreads);

    /**
     * [web] Set the minimum spare threads for http connector
     * 
     * @param httpMinSpareThreads The minimum spare threads for http connector
     */
    void setHttpMinSpareThreads(String httpMinSpareThreads);

    /**
     * [web] sSet the maximum spare threads for http connector
     * 
     * @param httpMaxSpareThreads The maximum spare threads for http connector
     */
    void setHttpMaxSpareThreads(String httpMaxSpareThreads);

    /**
     * [web] Set the https connector port
     * 
     * @param httpsPort The https connector port
     */
    void setHttpsPort(String httpsPort);

    /**
     * [web] Set the max number of connections for https
     * 
     * @param httpsMaxThreads Max number of connections
     */
    void setHttpsMaxThreads(String httpsMaxThreads);

    /**
     * [web] Set the minimum spare threads for https connector
     * 
     * @param httpsMinSpareThreads The minimum spare threads for https connector
     */
    void setHttpsMinSpareThreads(String httpsMinSpareThreads);

    /**
     * [web] Set the maximum spare threads for https connector
     * 
     * @param httpsMaxSpareThreads The maximum spare threads for https connector
     */
    void setHttpsMaxSpareThreads(String httpsMaxSpareThreads);

    /**
     * [web] Set the ajp connector port
     * 
     * @param ajpPort The ajp connector port
     */
    void setAjpPort(String ajpPort);

    /**
     * [web] Set the max number of connections for ajp
     * 
     * @param ajpMaxThreads Max number of connections
     */
    void setAjpMaxThreads(String ajpMaxThreads);

    /**
     * [web] Set the minimum spare threads for ajp connector
     * 
     * @param ajpMinSpareThreads The minimum spare threads for ajp connector
     */
    void setAjpMinSpareThreads(String ajpMinSpareThreads);

    /**
     * [web] Set the maximum spare threads for ajp connector
     * 
     * @param ajpMaxSpareThreads The maximum spare threads for ajp connector
     */
    void setAjpMaxSpareThreads(String ajpMaxSpareThreads);

    /**
     * [web] Set the mod_jk configuration
     * 
     * @param jvmRoute The mod_jk configuration
     */
    void setJvmRoute(String jvmRoute);

    /**
     * [web] Set the cluster name for the http replication
     * 
     * @param clusterName Cluster name
     */
    void setHttpReplicationClusterName(String clusterName);

    /**
     * [web] Set the multicast address for the http replication
     * 
     * @param mCastAddr The multicast address
     */
    void setHttpReplicationMulticastAddress(String mCastAddr);

    /**
     * [web] Set the multicast port for the http replication
     * 
     * @param mCastPort The multicast port
     */
    void setHttpReplicationMulticastPort(String mCastPort);

    /**
     * [web] Set the listen port for http replication
     * 
     * @param listenPort The listen port
     */
    void setHttpReplicationListenPort(String listenPort);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Service db configuration */
    /**
     * [db] Set the port used by hsqldb (embedded)
     * 
     * @param port The port used by hsqldb
     */
    void setDbPort(String port);

    /**
     * [db] Set the DB name used by hsqldb (embedded)
     * 
     * @param name The DB name used by hsqldb
     */
    void setDbName(String name);

    /**
     * [db] Set the users used by hsqldb (embedded)
     * 
     * @param users The users used by hsqldb
     */
    void setDbUsers(String users);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Service discovery configuration */
    /**
     * [discovery] Enable or disable master node
     * 
     * @param masterActivated true or false
     */
    void setDiscoveryMasterActivated(Boolean masterActivated);

    /**
     * [discovery] Set the source port
     * 
     * @param sourcePort The source port
     */
    void setDiscoverySourcePort(String sourcePort);

    /**
     * [discovery] Set the domain name
     * 
     * @param domainName The domain name
     */
    void setDiscoveryDomainName(String domainName);

    /**
     * [discovery] Set the greeting port
     * 
     * @param greetingPort The greeting port
     */
    void setDiscoveryGreetingPort(String greetingPort);

    /**
     * [discovery] Set the multicast address
     * 
     * @param multicastAddress The multicast address
     */
    void setDiscoveryMulticastAddress(String multicastAddress);

    /**
     * [discovery] Set the multicast port
     * 
     * @param multicastPort The multicast port
     */
    void setDiscoveryMulticastPort(String multicastPort);

    /**
     * [discovery] Set the packet time to live
     * 
     * @param ttl paquet time to live
     */
    void setDiscoveryTTL(String ttl);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Service mail configuration */
    /**
     * [mail] Set the mail factory type
     * 
     * @param factoryType The mail factory type
     */
    void setMailFactoryType(String factoryType);

    /**
     * [mail] Set the mail factory name
     * 
     * @param factoryName The mail factory name
     */
    void setMailFactoryName(String factoryName);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Service WSDL publisher configuration */
    /**
     * [ws] Set the wsdl file name
     * 
     * @param fileName The file name
     */
    void setWsdlPublisherFileName(String fileName);

    /**
     * [ws] Set the wsdl file directory
     * 
     * @param fileDir The wsdl file directory
     */
    void setWsdlPublisherFileDirectory(String fileDir);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Service HA configuration */
    /**
     * [ha]Enable or disable ha service
     * 
     * @param activated true or false
     */
    void setHaActivated(Boolean activated);

    /**
     * [ha] Set the multicast address
     * 
     * @param multicastAddr
     */
    void setHaMulticastAddress(String multicastAddr);

    /**
     * [ha] Set the multicast port
     * 
     * @param multicastPort The multicast port
     */
    void setHaMulticastPort(String multicastPort);

    /* ------------------------------- */

    /* ------------------------------- */
    /* SecurityManager configuration */
    /**
     * [SecurityManager] Enable or disable security manager service
     * 
     * @param activation true or false
     */
    void setSecurityManagerActivated(Boolean activation);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Ejb clustering configuration */
    /**
     * [ha]Enable or disable ejb clustering
     * 
     * @param activated true or false
     */
    void setEjbClusteringActivated(Boolean activated);

    /**
     * [Ejb clustering] Set the multicast address
     * 
     * @param multicastAddr The multicast address
     */
    void setEjbClusteringMulticastAddress(String multicastAddr);

    /**
     * [Ejb clustering] Set the multicast port
     * 
     * @param multicastPort The mulitcast port
     */
    void setEjbClusteringMulticastPort(String multicastPort);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Jms configuration */
    /**
     * [jms] Set the port
     * 
     * @param port The port
     */
    void setJmsPort(String port);

    /**
     * [jms] Set the queues (comma-seperated)
     * 
     * @param queue The queues (comma-seperated)
     */
    void setJmsQueues(String queue);

    /**
     * [jms] Set the topics (comma-seperated)
     * 
     * @param topic The topics (comma-seperated)
     */
    void setJmsTopics(String topic);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Jdbc configuration */
    /**
     * [jdbc] Add a JDBC resource adapter
     * 
     * @param raName JDBC resource adapter's name
     * @param configuration JDBC resource adapter's configuration
     */
    void addJdbcRA(String raName, JDBCConfiguration configuration);

    /* ------------------------------- */

    /* ------------------------------- */
    /* Cluster deamon configuration */

    /**
     * Set the cluster daemon name
     * 
     * @param clusterName the cluster name
     */
    void setCDClusterName(String clusterName);

    /**
     * Set the cluster daemon domain name
     * 
     * @param clusterDomain the cluster domain name
     */
    void setCDClusterDomain(String clusterDomain);

    /**
     * [protocols] Set the cluster daemon's protocol
     * 
     * @param protocol The cluster daemon's protocol
     */
    void setCDProtocol(String protocol);

    /**
     * [protocols] Set the port for the cluster daemon's protocol
     * 
     * @param port The port for the cluster daemon's protocol
     */
    void setCDPort(String port);

    /**
     * Set the dest dir prefix
     * 
     * @param destDirPrefix the dest dir prefix
     */
    void setCDDestDirPrefix(String destDirPrefix);

    /**
     * Set the interaction mode
     * 
     * @param interactionMode the interaction mode
     */
    void setCDInteractionMode(String interactionMode);

    /**
     * Set the java home
     * 
     * @param javaHome the java home
     */
    void setCDJavaHome(String javaHome);

    /**
     * Set the jonas root
     * 
     * @param jonasRoot the jonas root
     */
    void setCDJonasRoot(String jonasRoot);

    /**
     * Set the server name prefix
     * 
     * @param serverNamePrefix the server name prefix
     */
    void setCDServerNamePrefix(String serverNamePrefix);

    /**
     * Set the xparam
     * 
     * @param xparam the xparam
     */
    void setCDXparam(String xparam);

    /**
     * Set the auto boot mode
     * 
     * @param autoBoot the auto boot mode
     */
    void setCDAutoBoot(boolean autoBoot);

    /**
     * Set the number of servers in the cluster
     * 
     * @param nbInsts the number of servers in the Cluster
     */
    void setCDNbInstances(int nbInsts);

    /**
     * Apply the cluster daemon configuration
     */
    void executeCDConf();

    /* ------------------------------- */

}
