/**
 * JOnAS Configurator
 * Copyright (C) 2010 Bull S.A.S.
 * Copyright (C) 2010 France Telecom R&D
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JDBCConfiguration.java 19752 2010-04-27 08:22:42Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.tools.configurator.api;

public class JDBCConfiguration {

    /**
     * The driver name
     */
    public String driverName;

    /**
     * The driver class
     */
    public String datasourceClass;

    /**
     * The check level
     */
    public String checkLevel;

    /**
     * The test statement
     */
    public String testStatement;

    /**
     * The jndi name
     */
    public String jndiName;

    /**
     * The mapper name
     */
    public String mappername;

    /**
     * The password
     */
    public String password;

    /**
     * The link to the rar.
     */
    public String rarLink;

    /**
     * The url
     */
    public String url;

    /**
     * The user
     */
    public String user;

    /**
     * The pool init size
     */
    public String poolInitialSize;

    /**
     * The pool max size
     */
    public String poolMaximumSize;

    /**
     * The pool max age
     */
    public String poolMaximumAgeMinutes;

    /**
     * The pool max open time
     */
    public String poolMaximumOpenTime;

    /**
     * The pool max waiters time
     */
    public String poolMaximumNumberOfWaiters;

    /**
     * The pool max wait time
     */
    public String poolMaximumWaitTime;

    /**
     * The pool min size
     */
    public String poolMinimumSize;

    /**
     * The pool sampling period
     */
    public String poolSamplingPeriod;

    /**
     * The max prepared Statements size of this JDBC Resource Adaptor Connection
     * Pool.
     */
    public String poolMaximumNumberOfPreparedStatements;

}
