/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.tools.configurator.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileReplacerHelper {
    private static Logger logger = Logger.getLogger(FileReplacerHelper.class.getName());
    private List<Task> tasks = new ArrayList<Task>();

    protected void addReplacement(String file, String from, String to) {
        this.tasks.add(new Task(file, from, to));
    }

    protected void doReplacements(File parent) {
        for (Task task : this.tasks) {
            File file = new File(parent, task.file);
            if (file.isFile()) {
                try {
                    String line;
                    StringBuffer sb = new StringBuffer();
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    while ((line = br.readLine()) != null) {
                        sb.append(line.replace(task.from, task.to));
                        sb.append(System.getProperty("line.separator"));
                    }
                    br.close();
                    FileWriter fw = new FileWriter(file);
                    fw.write(sb.toString());
                    fw.close();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed writing file " + file, e);
                }
                continue;
            }
            logger.severe("Skipped file " + file);
        }
    }

    private class Task {
        String file;
        String from;
        String to;

        public Task(String file, String from, String to) {
            this.file = file;
            this.from = from;
            this.to = to;
        }
    }
}

