/**
 * JOnAS Configurator
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: NotApplicableHelper.java 18709 2009-09-22 12:50:23Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.tools.configurator.impl;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotApplicableHelper {

    /**
     * Configuration logger
     */
    private static Logger logger = Logger.getLogger(NotApplicableHelper.class.getName());

    /**
     * - true : display debug message when parameter isn't applied <br >
     * - false : throw exception when parameter isn't applied <br >
     */
    private static boolean ignoreNonApplicableParameters = true;

    static {
        try {
            ResourceBundle properties = ResourceBundle.getBundle("properties.configurator");
            ignoreNonApplicableParameters = new Boolean(properties.getString("debug_mode"));
        } catch (Throwable t) {
            logger.log(Level.INFO, "Cannot read the configurator properties file, debug_mode will be set to false", t);
        }
    }

    public static void notApplicable(final String parameterName) {
        String message = "Parameter " + parameterName + " is not supported by the target server";

        if (ignoreNonApplicableParameters) {
            logger.warning(message);
        } else {
            throw new IllegalArgumentException(message);
        }
    }
}
