/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.tools.configurator.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.listener.TimestampedLogger;
import org.objectweb.jonas.ant.JOnASBaseTask;
import org.objectweb.jonas.ant.JOnASClusterConfigTask;
import org.objectweb.jonas.ant.cluster.ClusterDaemon;
import org.objectweb.jonas.ant.jonasbase.Carol;
import org.objectweb.jonas.ant.jonasbase.Db;
import org.objectweb.jonas.ant.jonasbase.Discovery;
import org.objectweb.jonas.ant.jonasbase.Ha;
import org.objectweb.jonas.ant.jonasbase.JdbcRa;
import org.objectweb.jonas.ant.jonasbase.Jms;
import org.objectweb.jonas.ant.jonasbase.JonasProperties;
import org.objectweb.jonas.ant.jonasbase.Mail;
import org.objectweb.jonas.ant.jonasbase.Services;
import org.objectweb.jonas.ant.jonasbase.Tasks;
import org.objectweb.jonas.ant.jonasbase.WebContainer;
import org.objectweb.jonas.ant.jonasbase.web.Ajp;
import org.objectweb.jonas.ant.jonasbase.web.Cluster;
import org.objectweb.jonas.ant.jonasbase.web.Http;
import org.objectweb.jonas.ant.jonasbase.web.Https;
import org.objectweb.jonas.ant.jonasbase.web.Tomcat;
import org.objectweb.jonas.ant.jonasbase.wsdl.WsdlPublish;
import org.ow2.jonas.tools.configurator.api.JDBCConfiguration;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;
import org.ow2.jonas.tools.configurator.impl.FileReplacerHelper;
import org.ow2.jonas.tools.configurator.impl.NotApplicableHelper;

public class Jonas4
extends FileReplacerHelper
implements JonasConfigurator {
    private File jonasFileBase;
    private JOnASBaseTask jonasBase = new JOnASBaseTask();
    private JOnASClusterConfigTask clusterDaemonTask;
    private ClusterDaemon clusterDaemon;
    private static Logger logger = Logger.getLogger(Jonas4.class.getName());
    private Carol carol;
    private boolean isProtocolsListSet = false;
    private Db db;
    private boolean isDbActivated = false;
    private Discovery discovery;
    private boolean isDiscoveryMaster = false;
    private Map<String, JdbcRa> jdbcRa;
    private Jms jms;
    private JonasProperties jonasProperties;
    private Mail mail;
    private boolean isMailActivated = false;
    private Services services;
    private WebContainer webContainer;
    private Tomcat tomcat;
    private Ajp ajp;
    private Http http;
    private Https https;
    private Cluster cluster;
    private org.objectweb.jonas.ant.jonasbase.wsdl.File wsdlPublisherFile;
    private WsdlPublish wsdlPublish;
    private boolean isWsdlPublishActivated = false;
    private Ha ha;
    private Project project;
    private boolean isJonasRootSet = false;
    private boolean isJonasBaseSet = false;
    private Boolean isHttpActivated = true;
    private Boolean isHttpsActivated = false;
    private Boolean isAjpActivated = false;
    private Boolean isHttpReplicationActivated = false;
    private Boolean isHaActivated = false;
    private Boolean isEjbClusteringActivated = false;
    private String saveCmiMCastAddr;
    private String saveCmiMCastPort;

    public Jonas4() {
        this.createProject();
        this.jonasBase.setProject(this.project);
        this.clusterDaemonTask = new JOnASClusterConfigTask();
        this.clusterDaemonTask.setProject(this.project);
        this.carol = new Carol();
        this.db = new Db();
        this.discovery = new Discovery();
        this.jdbcRa = new HashMap<String, JdbcRa>();
        this.jms = new Jms();
        try {
            this.jonasProperties = new JonasProperties();
        }
        catch (NoClassDefFoundError e) {
            this.jonasProperties = null;
            this.services = new Services();
        }
        this.mail = new Mail();
        this.webContainer = new WebContainer();
        this.tomcat = new Tomcat();
        this.ajp = new Ajp();
        this.http = new Http();
        this.https = new Https();
        this.cluster = new Cluster();
        this.wsdlPublish = new WsdlPublish();
        this.wsdlPublisherFile = new org.objectweb.jonas.ant.jonasbase.wsdl.File();
        this.ha = new Ha();
        this.clusterDaemon = new ClusterDaemon();
        this.clusterDaemon.setProtocol("jrmp");
        this.clusterDaemon.setPort("1099");
        logger.finest("Created the JOnAS 4 configurator instance");
    }

    private void createProject() {
        this.project = new Project();
        this.project.init();
        this.project.initProperties();
        TimestampedLogger logger = new TimestampedLogger();
        logger.setMessageOutputLevel(4);
        logger.setOutputPrintStream(new PrintStream(new OutputStream(){
            StringBuffer buf = new StringBuffer();

            public void write(int b) throws IOException {
                if (b == 10 || b == 13) {
                    if (this.buf.length() > 0) {
                        logger.finest(this.buf.toString());
                        this.buf.setLength(0);
                    }
                } else {
                    this.buf.append((char)b);
                }
            }
        }));
        this.project.addBuildListener((BuildListener)logger);
    }

    public void setJdk(String jdk) {
        logger.finest("[GlobalParameters] setting jdk : " + jdk);
        NotApplicableHelper.notApplicable("GlobalParameters.Jdk");
    }

    public void setJavaOpts(String javaOpts) {
        logger.finest("[GlobalParameters] setting java opts : " + javaOpts);
        if (this.jonasProperties != null) {
            this.jonasProperties.setJvmopts(javaOpts);
        }
    }

    public void setJonasRoot(String jonasRoot) {
        logger.finest("[GlobalParameters] setting jonas root : " + jonasRoot);
        File jonasFileRoot = new File(jonasRoot);
        this.jonasBase.setJonasRoot(jonasFileRoot);
        this.discovery.setJonasRoot(jonasRoot);
        this.isJonasRootSet = true;
    }

    public void setJonasBase(String jonasBase) {
        logger.finest("[GlobalParameters] setting jonas base : " + jonasBase);
        this.jonasFileBase = new File(jonasBase);
        this.jonasBase.setDestDir(this.jonasFileBase);
        this.isJonasBaseSet = true;
    }

    public void setJonasName(String jonasName) {
        logger.finest("[GlobalParameters] setting jonas name : " + jonasName);
        if (this.jonasProperties != null) {
            this.jonasProperties.setServerName(jonasName);
        }
    }

    public void setJonasDomain(String jonasDomain) {
        logger.finest("[GlobalParameters] setting jonas domain : " + jonasDomain);
        if (this.jonasProperties != null) {
            this.jonasProperties.setDomainName(jonasDomain);
        }
    }

    public void setHost(String jonasHost) {
        logger.finest("[GlobalParameters] setting host : " + jonasHost);
        this.addReplacement("carol.properties", "://localhost:", "://" + jonasHost + ":");
        NotApplicableHelper.notApplicable("GlobalParameters.JMSHost");
    }

    public void setJonasDevelopment(boolean development) {
        logger.finest("[GlobalParameters] setting development : " + development);
        NotApplicableHelper.notApplicable("GlobalParameters.development");
    }

    public void setProtocolsList(String protocolsList) {
        logger.finest("[Protocols configuration] setting protocols list : " + protocolsList);
        this.carol.setProtocols(protocolsList);
        this.isProtocolsListSet = true;
    }

    public void setProtocolsIrmiPort(String irmiPort) {
        logger.finest("[Protocols configuration] setting irmi port : " + irmiPort);
        this.carol.setIrmiPort(irmiPort);
    }

    public void setProtocolsIiopPort(String iiopPort) {
        logger.finest("[Protocols configuration] setting iiop port : " + iiopPort);
        this.carol.setIiopPort(iiopPort);
    }

    public void setProtocolsJrmpPort(String jrmpPort) {
        logger.finest("[Protocols configuration] setting jrmp port : " + jrmpPort);
        this.carol.setJrmpPort(jrmpPort);
    }

    public void setProtocolsCmiPort(String cmiPort) {
        logger.finest("[Protocols configuration] setting cmi port : " + cmiPort);
        this.carol.setCmiPort(cmiPort);
    }

    public void setProtocolsLocalCallOptimized(Boolean localCallOptimized) {
        logger.finest("[Protocols configuration] setting jndi local call optimisation : " + localCallOptimized);
        this.carol.setJrmpOptimization(localCallOptimized.booleanValue());
    }

    public void setServices(String services) {
        logger.finest("setting active services list : " + services);
        if (this.jonasProperties != null) {
            this.jonasProperties.setServices(services);
        } else {
            this.services.setNames(services);
        }
    }

    public void setWebcontainer(String webContainer) {
        logger.finest("[Web configuration] setting webContainer : " + webContainer);
        NotApplicableHelper.notApplicable("Web.webContainer");
    }

    public void setHttpsConnectorActivation(Boolean activation) {
        logger.finest("[Web configuration] setting isHttpsActivated : " + activation);
        this.isHttpsActivated = activation;
    }

    public void setAjpConnectorActivation(Boolean activation) {
        logger.finest("[Web configuration] setting isAjpActivated : " + activation);
        this.isAjpActivated = activation;
    }

    public void setHttpSessionReplicationActivation(Boolean activation) {
        logger.finest("[Web configuration] setting isHttpReplicationActivated : " + activation);
        this.isHttpReplicationActivated = activation;
    }

    public void setHttpPort(String httpPort) {
        logger.finest("[Web configuration] setting http port : " + httpPort);
        this.http.setPort(httpPort);
        this.addReplacement("uddi.properties", ":9000/", ":" + httpPort + "/");
    }

    public void setHttpMaxThreads(String httpMaxThreads) {
        logger.finest("[Web configuration] setting max http threads : " + httpMaxThreads);
        NotApplicableHelper.notApplicable("HTTP.maxThreads");
    }

    public void setHttpMinSpareThreads(String httpMinSpareThreads) {
        logger.finest("[Web configuration] setting min http spare threads : " + httpMinSpareThreads);
        NotApplicableHelper.notApplicable("HTTP.minSpareThreads");
    }

    public void setHttpMaxSpareThreads(String httpMaxSpareThreads) {
        logger.finest("[Web configuration] setting max http spare threads : " + httpMaxSpareThreads);
        NotApplicableHelper.notApplicable("HTTP.maxSpareThreads");
    }

    public void setHttpsPort(String httpsPort) {
        logger.finest("[Web configuration] setting https port : " + httpsPort);
        this.https.setPort(httpsPort);
    }

    public void setHttpsMaxThreads(String httpsMaxThreads) {
        logger.finest("[Web configuration] setting max https threads : " + httpsMaxThreads);
        NotApplicableHelper.notApplicable("HTTPS.maxThreads");
    }

    public void setHttpsMinSpareThreads(String httpsMinSpareThreads) {
        logger.finest("[Web configuration] setting min https spare threads : " + httpsMinSpareThreads);
        NotApplicableHelper.notApplicable("HTTPS.minSpareThreads");
    }

    public void setHttpsMaxSpareThreads(String httpsMaxSpareThreads) {
        logger.finest("[Web configuration] setting max https spare threads : " + httpsMaxSpareThreads);
        NotApplicableHelper.notApplicable("HTTPS.maxSpareThreads");
    }

    public void setAjpPort(String ajpPort) {
        logger.finest("[Web configuration] setting ajp port : " + ajpPort);
        this.ajp.setPort(ajpPort);
    }

    public void setAjpMaxThreads(String ajpMaxThreads) {
        logger.finest("[Web configuration] setting max ajp threads : " + ajpMaxThreads);
        NotApplicableHelper.notApplicable("AJP.maxThreads");
    }

    public void setAjpMinSpareThreads(String ajpMinSpareThreads) {
        logger.finest("[Web configuration] setting min ajp spare threads : " + ajpMinSpareThreads);
        NotApplicableHelper.notApplicable("AJP.minSpareThreads");
    }

    public void setAjpMaxSpareThreads(String ajpMaxSpareThreads) {
        logger.finest("[Web configuration] setting max ajp spare threads : " + ajpMaxSpareThreads);
        NotApplicableHelper.notApplicable("AJP.maxSpareThreads");
    }

    public void setJvmRoute(String jvmRoute) {
        logger.finest("[Web configuration] setting jvm route : " + jvmRoute);
        try {
            this.tomcat.setJvmRoute(jvmRoute);
        }
        catch (NoSuchMethodError e) {
            this.addReplacement("server.xml", "<Engine name=\"jonas\" defaultHost=\"localhost\">", "<Engine name=\"jonas\" defaultHost=\"localhost\" jvmRoute=\"" + jvmRoute + "\">");
        }
    }

    public void setHttpReplicationClusterName(String clusterName) {
        logger.finest("[Web configuration] setting cluster name : " + clusterName);
        this.cluster.setName(clusterName);
    }

    public void setHttpReplicationMulticastAddress(String mCastAddr) {
        logger.finest("[Web configuration] setting multi cast address : " + mCastAddr);
        this.cluster.setMcastAddr(mCastAddr);
    }

    public void setHttpReplicationMulticastPort(String mCastPort) {
        logger.finest("[Web configuration] setting multi cast port : " + mCastPort);
        this.cluster.setMcastPort(mCastPort);
    }

    public void setHttpReplicationListenPort(String listenPort) {
        logger.finest("[Web configuration] setting listen port : " + listenPort);
        this.cluster.setListenPort(listenPort);
    }

    public void setDbPort(String port) {
        logger.finest("[Database configuration] setting db port: " + port);
        this.isDbActivated = true;
        this.db.setPort(port);
        this.addReplacement("HSQL1.properties", ":9001/", ":" + port + "/");
    }

    public void setDbName(String name) {
        logger.finest("[Database configuration] setting db name: " + name);
        this.isDbActivated = true;
        this.addReplacement("jonas.properties", "jonas.service.db.dbname    db_jonas", "jonas.service.db.dbname    " + name);
        this.addReplacement("HSQL1.properties", "/db_jonas", "/" + name);
    }

    public void setDbUsers(String users) {
        logger.finest("[Database configuration] setting db users: " + users);
        this.isDbActivated = true;
        this.addReplacement("jonas.properties", "jonas.service.db.users    jonas:jonas", "jonas.service.db.users    " + users);
        String[] multipleUsers = users.split(",");
        String firstUser = multipleUsers[0];
        String[] userPassword = firstUser.split(":");
        if (userPassword.length > 1) {
            String firstUserName = userPassword[0];
            String firstPassword = userPassword[1];
            this.addReplacement("HSQL1.properties", "datasource.username     jonas", "datasource.username     " + firstUserName);
            this.addReplacement("HSQL1.properties", "datasource.password     jonas", "datasource.password     " + firstPassword);
        }
    }

    public void setDiscoveryMasterActivated(Boolean masterActivated) {
        logger.finest("[Discovery configuration] setting masterActivated : " + masterActivated);
        this.isDiscoveryMaster = masterActivated;
    }

    public void setDiscoverySourcePort(String sourcePort) {
        logger.finest("[Discovery configuration] setting source port : " + sourcePort);
        this.discovery.setSourcePort(sourcePort);
    }

    public void setDiscoveryDomainName(String domainName) {
        logger.finest("[Discovery configuration] setting domain name : " + domainName);
        if (!this.isJonasRootSet) {
            logger.severe("[Discovery configuration] As jonas root isn't set, domain name skipped : ");
        } else {
            this.discovery.setDomainName(domainName);
        }
    }

    public void setDiscoveryGreetingPort(String greetingPort) {
        logger.finest("[Discovery configuration] setting greeting port : " + greetingPort);
        this.discovery.setGreetingPort(greetingPort);
    }

    public void setDiscoveryMulticastAddress(String multicastAddress) {
        logger.finest("[Discovery configuration] setting multicast address : " + multicastAddress);
        this.discovery.setMcastAddr(multicastAddress);
    }

    public void setDiscoveryMulticastPort(String multicastPort) {
        logger.finest("[Discovery configuration] setting multicast port : " + multicastPort);
        this.discovery.setMcastPort(multicastPort);
    }

    public void setDiscoveryTTL(String ttl) {
        logger.finest("[Discovery configuration] setting tlt : " + ttl);
        NotApplicableHelper.notApplicable("Discovery.TTL");
    }

    public void setMailFactoryType(String factoryType) {
        logger.finest("[Mail Service Configuration] setting mail factory type : " + factoryType);
        this.mail.setType(factoryType);
        this.isMailActivated = true;
    }

    public void setMailFactoryName(String factoryName) {
        logger.finest("[Mail Service Configuration] setting mail factory name : " + factoryName);
        this.mail.setName(factoryName);
        this.isMailActivated = true;
    }

    public void setWsdlPublisherFileName(String fileName) {
        logger.finest("[WS Service configuration] setting wsdlPublisherFile name : " + fileName);
        this.wsdlPublisherFile.setName(fileName);
        this.isWsdlPublishActivated = true;
    }

    public void setWsdlPublisherFileDirectory(String fileDir) {
        logger.finest("[WS Service configuration] setting wsdlPublisherFile directory : " + fileDir);
        this.wsdlPublisherFile.setDir(fileDir);
        this.isWsdlPublishActivated = true;
    }

    public void setHaActivated(Boolean activated) {
        logger.finest("[HA Service configuration] setting ha activated : " + activated);
        this.isHaActivated = activated;
    }

    public void setHaMulticastAddress(String multicastAddr) {
        logger.finest("[HA Service configuration] setting multicast address : " + multicastAddr);
        this.ha.setMcastAddr(multicastAddr);
    }

    public void setHaMulticastPort(String multicastPort) {
        logger.finest("[HA Service configuration] setting multicast port : " + multicastPort);
        this.ha.setMcastPort(multicastPort);
    }

    public void setSecurityManagerActivated(Boolean activation) {
        logger.finest("[Security Manager configuration] setting isActivated : " + activation);
        if (this.jonasProperties != null) {
            this.jonasProperties.setSecurityManager(activation.booleanValue());
        } else {
            this.addReplacement("jonas.properties", "jonas.security.manager    true", "jonas.security.manager    " + activation.toString());
        }
    }

    public void setEjbClusteringActivated(Boolean activated) {
        logger.finest("[Ejb Clustering configuration] setting ejb clustering activated activated : " + activated);
        this.isEjbClusteringActivated = activated;
    }

    public void setEjbClusteringMulticastAddress(String multicastAddr) {
        logger.finest("[Ejb Clustering configuration] setting multicast address : " + multicastAddr);
        this.saveCmiMCastAddr = multicastAddr;
    }

    public void setEjbClusteringMulticastPort(String multicastPort) {
        logger.finest("[Ejb Clustering configuration] setting multicast port : " + multicastPort);
        this.saveCmiMCastPort = multicastPort;
    }

    public void setJmsPort(String port) {
        logger.finest("[Jms configuration] setting port : " + port);
        this.jms.setPort(port);
    }

    public void setJmsQueues(String queue) {
        logger.finest("[Jms configuration] setting queue : " + queue);
        this.jms.setInitialQueues(queue);
    }

    public void setJmsTopics(String topic) {
        logger.finest("[Jms configuration] setting topic : " + topic);
        this.jms.setInitialTopics(topic);
    }

    public void addJdbcRA(String raName, JDBCConfiguration configuration) {
        JdbcRa jdbcRa = new JdbcRa();
        if (configuration.driverName != null) {
            logger.finest("[Jdbc configuration] setting driverName: " + configuration.driverName);
            jdbcRa.setDriverName(configuration.driverName);
        }
        if (configuration.datasourceClass != null) {
            logger.finest("[Jdbc configuration] setting datasourceClass: " + configuration.datasourceClass);
            NotApplicableHelper.notApplicable("JDBC.datasourceClass");
        }
        logger.finest("[Jdbc configuration] setting raName: " + raName);
        jdbcRa.setName(raName);
        if (configuration.checkLevel != null) {
            logger.finest("[Jdbc configuration] setting checkLevel: " + configuration.checkLevel);
            NotApplicableHelper.notApplicable("JDBC.checkLevel");
        }
        if (configuration.testStatement != null) {
            logger.finest("[Jdbc configuration] setting testStatement: " + configuration.testStatement);
            NotApplicableHelper.notApplicable("JDBC.testStatement");
        }
        if (configuration.jndiName != null) {
            logger.finest("[Jdbc configuration] setting jndiName: " + configuration.jndiName);
            jdbcRa.setJndiName(configuration.jndiName);
        }
        if (configuration.mappername != null) {
            logger.finest("[Jdbc configuration] setting mappername: " + configuration.mappername);
            jdbcRa.setMapperName(configuration.mappername);
        }
        if (configuration.password != null) {
            logger.finest("[Jdbc configuration] setting password: " + configuration.password);
            jdbcRa.setPassword(configuration.password);
        }
        if (configuration.rarLink != null) {
            logger.finest("[Jdbc configuration] setting rarLink: " + configuration.rarLink);
            NotApplicableHelper.notApplicable("JDBC.rarLink");
        }
        if (configuration.url != null) {
            logger.finest("[Jdbc configuration] setting url: " + configuration.url);
            jdbcRa.setUrl(configuration.url);
        }
        if (configuration.user != null) {
            logger.finest("[Jdbc configuration] setting user: " + configuration.user);
            jdbcRa.setUser(configuration.user);
        }
        if (configuration.poolInitialSize != null) {
            logger.finest("[Jdbc configuration] setting poolInitialSize: " + configuration.poolInitialSize);
            NotApplicableHelper.notApplicable("JDBC.poolInitialSize");
        }
        if (configuration.poolMaximumSize != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumSize: " + configuration.poolMaximumSize);
            jdbcRa.setMaxPoolSize(configuration.poolMaximumSize);
        }
        if (configuration.poolMaximumAgeMinutes != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumAgeMinutes: " + configuration.poolMaximumAgeMinutes);
            try {
                jdbcRa.setConnMaxAge(configuration.poolMaximumAgeMinutes);
            }
            catch (NoSuchMethodError e) {
                NotApplicableHelper.notApplicable("JDBC.poolMaximumAgeMinutes");
            }
        }
        if (configuration.poolMaximumOpenTime != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumOpenTime: " + configuration.poolMaximumOpenTime);
            try {
                jdbcRa.setMaxOpenTime(configuration.poolMaximumOpenTime);
            }
            catch (NoSuchMethodError e) {
                NotApplicableHelper.notApplicable("poolMaximumOpenTime");
            }
        }
        if (configuration.poolMaximumNumberOfWaiters != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumNumberOfWaiters: " + configuration.poolMaximumNumberOfWaiters);
            try {
                jdbcRa.setMaxWaiters(configuration.poolMaximumNumberOfWaiters);
            }
            catch (NoSuchMethodError e) {
                NotApplicableHelper.notApplicable("JDBC.poolMaximumNumberOfWaiters");
            }
        }
        if (configuration.poolMaximumWaitTime != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumWaitTime: " + configuration.poolMaximumWaitTime);
            try {
                jdbcRa.setMaxWaitTime(configuration.poolMaximumWaitTime);
            }
            catch (NoSuchMethodError e) {
                NotApplicableHelper.notApplicable("JDBC.poolMaximumWaitTime");
            }
        }
        if (configuration.poolMinimumSize != null) {
            logger.finest("[Jdbc configuration] setting poolMinimumSize: " + configuration.poolMinimumSize);
            NotApplicableHelper.notApplicable("JDBC.poolMinimumSize");
        }
        if (configuration.poolSamplingPeriod != null) {
            logger.finest("[Jdbc configuration] setting poolSamplingPeriod: " + configuration.poolSamplingPeriod);
            NotApplicableHelper.notApplicable("JDBC.poolSamplingPeriod");
        }
        if (configuration.poolMaximumNumberOfPreparedStatements != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumNumberOfPreparedStatements: " + configuration.poolMaximumNumberOfPreparedStatements);
            try {
                jdbcRa.setMaxPreparedStatementsSize(configuration.poolMaximumNumberOfPreparedStatements);
            }
            catch (NoSuchMethodError e) {
                NotApplicableHelper.notApplicable("JDBC.poolMaximumNumberOfPreparedStatements");
            }
        }
        this.jdbcRa.put(raName, jdbcRa);
    }

    public void execute() {
        if (!this.isJonasRootSet) {
            throw new IllegalArgumentException("Jonas root is not set.");
        }
        if (!this.isJonasBaseSet) {
            throw new IllegalArgumentException("Jonas base is not set.");
        }
        if (this.isHttpActivated.booleanValue()) {
            this.tomcat.addConfiguredHttp(this.http);
        }
        if (this.isHttpsActivated.booleanValue()) {
            this.tomcat.addConfiguredHttps(this.https);
        }
        if (this.isAjpActivated.booleanValue()) {
            this.tomcat.addConfiguredAjp(this.ajp);
        }
        if (this.isHttpReplicationActivated.booleanValue()) {
            this.tomcat.addConfiguredCluster(this.cluster);
        }
        this.webContainer.addConfiguredTomcat(this.tomcat);
        if (this.isEjbClusteringActivated.booleanValue()) {
            this.carol.setCmiMcastAddr(this.saveCmiMCastAddr);
            this.carol.setCmiMcastPort(this.saveCmiMCastPort);
        }
        if (!this.isProtocolsListSet) {
            this.carol.setProtocols("jrmp");
        }
        this.jonasBase.addConfiguredCarol(this.carol);
        if (this.isDbActivated) {
            this.jonasBase.addConfiguredDb(this.db);
        }
        if (this.isDiscoveryMaster) {
            this.discovery.setSourcePort("-1");
        }
        this.jonasBase.addConfiguredDiscovery(this.discovery);
        for (JdbcRa jdbcRa : this.jdbcRa.values()) {
            this.jonasBase.addConfiguredJdbcRa(jdbcRa);
        }
        this.jonasBase.addConfiguredJms(this.jms);
        if (this.jonasProperties != null) {
            this.jonasBase.addConfiguredJonasProperties(this.jonasProperties);
        } else {
            this.jonasBase.addConfiguredServices(this.services);
        }
        if (this.isMailActivated) {
            this.jonasBase.addConfiguredMail(this.mail);
        }
        this.jonasBase.addConfiguredWebContainer(this.webContainer);
        if (this.isWsdlPublishActivated) {
            this.wsdlPublish.addConfiguredFile(this.wsdlPublisherFile);
            this.jonasBase.addConfiguredWsdlPublish(this.wsdlPublish);
        }
        if (this.isHaActivated.booleanValue()) {
            this.jonasBase.addTasks((Tasks)this.ha);
        }
        this.jonasBase.execute();
        this.doReplacements(new File(this.jonasFileBase, "conf"));
    }

    public void setCDClusterName(String clusterName) {
        logger.finest("[Cluster daemon configuration] setting cluster name : " + clusterName);
        this.clusterDaemon.setName(clusterName);
        this.clusterDaemon.updateName();
    }

    public void setCDClusterDomain(String clusterDomain) {
        logger.finest("[Cluster daemon configuration] setting cluster domain name : " + clusterDomain);
        this.clusterDaemon.setDomainName(clusterDomain);
    }

    public void setCDProtocol(String protocol) {
        logger.finest("[Cluster daemon configuration] setting protocol : " + protocol);
        this.clusterDaemon.setProtocol(protocol);
    }

    public void setCDPort(String port) {
        logger.finest("[Cluster daemon configuration] setting port : " + port);
        this.clusterDaemon.setPort(port);
    }

    public void setCDDestDirPrefix(String destDirPrefix) {
        logger.finest("[Cluster daemon configuration] setting dest dir prefix : " + destDirPrefix);
        this.clusterDaemon.setDestDirPrefix(destDirPrefix);
        this.clusterDaemonTask.setDestDirPrefix(destDirPrefix);
        this.clusterDaemon.setCdDir(destDirPrefix);
        this.clusterDaemonTask.setCdDir(destDirPrefix);
    }

    public void setCDInteractionMode(String interactionMode) {
        logger.finest("[Cluster daemon configuration] setting interaction mode : " + interactionMode);
        this.clusterDaemon.setInteractionMode(interactionMode);
    }

    public void setCDJavaHome(String javaHome) {
        logger.finest("[Cluster daemon configuration] setting java home : " + javaHome);
        this.clusterDaemon.setJdk(javaHome);
    }

    public void setCDJonasRoot(String jonasRoot) {
        logger.finest("[Cluster daemon configuration] setting jonas root : " + jonasRoot);
        this.clusterDaemon.setJonasRoot(jonasRoot);
        this.clusterDaemonTask.setJonasRoot(new File(jonasRoot));
    }

    public void setCDServerNamePrefix(String serverNamePrefix) {
        logger.finest("[Cluster daemon configuration] setting server name prefix : " + serverNamePrefix);
        this.clusterDaemon.setClusterNodesName(serverNamePrefix);
    }

    public void setCDXparam(String xparam) {
        logger.finest("[Cluster daemon configuration] setting xparam : " + xparam);
        this.clusterDaemon.setXprm(xparam);
    }

    public void setCDAutoBoot(boolean autoBoot) {
        logger.finest("[Cluster daemon configuration] setting auto boot : " + autoBoot);
        this.clusterDaemon.setAutoBoot(new Boolean(autoBoot).toString());
    }

    public void setCDNbInstances(int nbInsts) {
        logger.finest("[Cluster daemon configuration] setting nb instance : " + nbInsts);
        this.clusterDaemon.setInstNb(nbInsts);
        this.clusterDaemonTask.setWebInstNb(nbInsts);
        this.clusterDaemonTask.setEjbInstNb(0);
    }

    public void executeCDConf() {
        this.clusterDaemonTask.addConfiguredClusterDaemon(this.clusterDaemon);
        this.clusterDaemonTask.execute();
    }
}

