/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.tools.configurator.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.listener.TimestampedLogger;
import org.ow2.jonas.antmodular.cluster.clusterdaemon.ClusterDaemon;
import org.ow2.jonas.antmodular.cmi.Cmi;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JOnASBaseTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JonasProperties;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.Services;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.Tasks;
import org.ow2.jonas.antmodular.jonasbase.carol.Carol;
import org.ow2.jonas.antmodular.jonasbase.db.base.Db;
import org.ow2.jonas.antmodular.jonasbase.db.h2.DbH2;
import org.ow2.jonas.antmodular.jonasbase.discovery.multicast.DiscoveryMulticast;
import org.ow2.jonas.antmodular.jonasbase.ha.Ha;
import org.ow2.jonas.antmodular.jonasbase.jms.Jms;
import org.ow2.jonas.antmodular.jonasbase.mail.Mail;
import org.ow2.jonas.antmodular.jonasbase.resource.JdbcXml;
import org.ow2.jonas.antmodular.jonasbase.wsdl.File;
import org.ow2.jonas.antmodular.jonasbase.wsdl.WsdlPublish;
import org.ow2.jonas.antmodular.web.base.Ajp;
import org.ow2.jonas.antmodular.web.base.Cluster;
import org.ow2.jonas.antmodular.web.base.Http;
import org.ow2.jonas.antmodular.web.base.Https;
import org.ow2.jonas.antmodular.web.base.WebContainer;
import org.ow2.jonas.tools.configurator.api.JDBCConfiguration;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;
import org.ow2.jonas.tools.configurator.impl.FileReplacerHelper;
import org.ow2.jonas.tools.configurator.impl.NotApplicableHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jonas53
extends FileReplacerHelper
implements JonasConfigurator {
    private java.io.File jonasFileBase;
    private JOnASBaseTask jonasBase = new JOnASBaseTask();
    private ClusterDaemon clusterDaemon;
    private static Logger logger = Logger.getLogger(Jonas53.class.getName());
    private Carol carol;
    private boolean isProtocolsListSet = false;
    private Db db;
    private boolean isDbActivated = false;
    private DiscoveryMulticast discovery;
    private Map<String, JdbcXml> jdbcXml;
    private Jms jms;
    private JonasProperties jonasProperties;
    private Mail mail;
    private boolean isMailActivated = false;
    private Services services;
    private String webContainer;
    private String jvmRoute;
    private Ajp ajp;
    private Http http;
    private Https https;
    private Cluster cluster;
    private File wsdlPublisherFile;
    private WsdlPublish wsdlPublish;
    private boolean isWsdlPublishActivated = false;
    private Cmi cmi;
    private Ha ha;
    private Project project;
    private boolean isJonasRootSet = false;
    private boolean isJonasBaseSet = false;
    private Boolean isHttpActivated = true;
    private Boolean isHttpsActivated = false;
    private Boolean isAjpActivated = false;
    private Boolean isHttpReplicationActivated = false;
    private Boolean isHaActivated = false;
    private Boolean isEjbClusteringActivated = false;

    public Jonas53() {
        this.createProject();
        this.jonasBase.setProject(this.project);
        this.carol = new Carol();
        this.carol.setProject(this.project);
        this.db = new DbH2();
        this.db.setProject(this.project);
        this.discovery = new DiscoveryMulticast();
        this.discovery.setProject(this.project);
        this.jdbcXml = new HashMap<String, JdbcXml>();
        this.jms = new Jms();
        this.jms.setProject(this.project);
        this.jonasProperties = new JonasProperties();
        this.jonasProperties.setProject(this.project);
        this.mail = new Mail();
        this.mail.setProject(this.project);
        this.services = new Services();
        this.services.setProject(this.project);
        this.ajp = new Ajp();
        this.http = new Http();
        this.https = new Https();
        this.cluster = new Cluster();
        this.wsdlPublish = new WsdlPublish();
        this.wsdlPublish.setProject(this.project);
        this.wsdlPublisherFile = new File();
        this.cmi = new Cmi();
        this.ha = new Ha();
        this.clusterDaemon = new ClusterDaemon();
        this.clusterDaemon.setProtocol("jrmp");
        this.clusterDaemon.setPort("1099");
        this.clusterDaemon.setProject(this.project);
        logger.finest("Created the JOnAS 5 configurator instance");
    }

    private void createProject() {
        this.project = new Project();
        this.project.init();
        this.project.initProperties();
        TimestampedLogger logger = new TimestampedLogger();
        logger.setMessageOutputLevel(4);
        logger.setOutputPrintStream(new PrintStream(new OutputStream(){
            StringBuffer buf = new StringBuffer();

            public void write(int b) throws IOException {
                if (b == 10 || b == 13) {
                    if (this.buf.length() > 0) {
                        logger.finest(this.buf.toString());
                        this.buf.setLength(0);
                    }
                } else {
                    this.buf.append((char)b);
                }
            }
        }));
        this.project.addBuildListener((BuildListener)logger);
    }

    public void setJdk(String jdk) {
        logger.finest("[GlobalParameters] setting jdk : " + jdk);
        NotApplicableHelper.notApplicable("GlobalParameters.Jdk");
    }

    public void setJavaOpts(String javaOpts) {
        logger.finest("[GlobalParameters] setting java opts : " + javaOpts);
        NotApplicableHelper.notApplicable("GlobalParameters.JavaOpts");
    }

    public void setJonasRoot(String jonasRoot) {
        logger.finest("[GlobalParameters] setting jonas root : " + jonasRoot);
        this.project.setProperty("jonas.root", jonasRoot);
        this.isJonasRootSet = true;
    }

    public void setJonasBase(String jonasBase) {
        logger.finest("[GlobalParameters] setting jonas base : " + jonasBase);
        this.jonasFileBase = new java.io.File(jonasBase);
        this.project.setProperty("jonas.base", jonasBase);
        this.isJonasBaseSet = true;
    }

    public void setJonasName(String jonasName) {
        logger.finest("[GlobalParameters] setting jonas name : " + jonasName);
        this.addReplacement("jonas.properties", "jonas.name    jonas", "jonas.name    " + jonasName);
    }

    public void setJonasDomain(String jonasDomain) {
        logger.finest("[GlobalParameters] setting jonas domain : " + jonasDomain);
        this.addReplacement("jonas.properties", "domain.name    jonas", "domain.name    " + jonasDomain);
    }

    public void setHost(String jonasHost) {
        logger.finest("[GlobalParameters] setting host : " + jonasHost);
        this.carol.setHost(jonasHost);
        this.jms.setHost(jonasHost);
    }

    public void setJonasDevelopment(boolean development) {
        logger.finest("[GlobalParameters] setting jonas.development : " + development);
        this.jonasProperties.setDevelopment(development);
    }

    public void setProtocolsList(String protocolsList) {
        if (protocolsList != null && protocolsList.contains("cmi")) {
            throw new IllegalArgumentException("In JOnAS 5, CMI has become a service. To enable CMI, follow these steps:\n\t1) In the CAROL protocols list, use JRMP, IIOP and/or IRMI as usual\n\t2) In the JOnAS services list, add the \"cmi\" service");
        }
        logger.finest("[Protocols configuration] setting protocols list : " + protocolsList);
        this.carol.setProtocols(protocolsList);
        this.isProtocolsListSet = true;
    }

    public void setProtocolsIrmiPort(String irmiPort) {
        logger.finest("[Protocols configuration] setting irmi port : " + irmiPort);
        this.carol.setIrmiPort(irmiPort);
    }

    public void setProtocolsIiopPort(String iiopPort) {
        logger.finest("[Protocols configuration] setting iiop port : " + iiopPort);
        this.carol.setIiopPort(iiopPort);
    }

    public void setProtocolsJrmpPort(String jrmpPort) {
        logger.finest("[Protocols configuration] setting jrmp port : " + jrmpPort);
        this.carol.setJrmpPort(jrmpPort);
    }

    public void setProtocolsCmiPort(String cmiPort) {
        logger.finest("[Protocols configuration] setting cmi port : " + cmiPort);
        NotApplicableHelper.notApplicable("Protocols.CmiPort");
    }

    public void setProtocolsLocalCallOptimized(Boolean localCallOptimized) {
        logger.finest("[Protocols configuration] setting jndi local call optimisation : " + localCallOptimized);
        this.carol.setJrmpOptimization(localCallOptimized.booleanValue());
    }

    public void setServices(String services) {
        logger.finest("setting actives services list : " + services);
        this.services.setNames(services);
        this.jonasProperties.setServices(services);
    }

    public void setWebcontainer(String webContainer) {
        logger.finest("[Web configuration] setting webContainer : " + webContainer);
        this.webContainer = webContainer;
    }

    public void setHttpsConnectorActivation(Boolean activation) {
        logger.finest("[Web configuration] setting isHttpsActivated : " + activation);
        this.isHttpsActivated = activation;
    }

    public void setAjpConnectorActivation(Boolean activation) {
        logger.finest("[Web configuration] setting isAjpActivated : " + activation);
        this.isAjpActivated = activation;
    }

    public void setHttpSessionReplicationActivation(Boolean activation) {
        logger.finest("[Web configuration] setting isHttpReplicationActivated : " + activation);
        this.isHttpReplicationActivated = activation;
    }

    public void setHttpPort(String httpPort) {
        logger.finest("[Web configuration] setting http port : " + httpPort);
        this.http.setPort(httpPort);
    }

    public void setHttpMaxThreads(String httpMaxThreads) {
        logger.finest("[Web configuration] setting max http threads : " + httpMaxThreads);
        NotApplicableHelper.notApplicable("HTTP.maxThreads");
    }

    public void setHttpMinSpareThreads(String httpMinSpareThreads) {
        logger.finest("[Web configuration] setting min http spare threads : " + httpMinSpareThreads);
        NotApplicableHelper.notApplicable("HTTP.minSpareThreads");
    }

    public void setHttpMaxSpareThreads(String httpMaxSpareThreads) {
        logger.finest("[Web configuration] setting max http spare threads : " + httpMaxSpareThreads);
        NotApplicableHelper.notApplicable("HTTP.maxSpareThreads");
    }

    public void setHttpsPort(String httpsPort) {
        logger.finest("[Web configuration] setting https port : " + httpsPort);
        this.https.setPort(httpsPort);
    }

    public void setHttpsMaxThreads(String httpsMaxThreads) {
        logger.finest("[Web configuration] setting max https threads : " + httpsMaxThreads);
        NotApplicableHelper.notApplicable("HTTPS.maxThreads");
    }

    public void setHttpsMinSpareThreads(String httpsMinSpareThreads) {
        logger.finest("setting min https spare threads : " + httpsMinSpareThreads);
        NotApplicableHelper.notApplicable("HTTPS.minSpareThreads");
    }

    public void setHttpsMaxSpareThreads(String httpsMaxSpareThreads) {
        logger.finest("setting max https spare threads : " + httpsMaxSpareThreads);
        NotApplicableHelper.notApplicable("HTTPS.maxSpareThreads");
    }

    public void setAjpPort(String ajpPort) {
        logger.finest("[Web configuration] setting ajp port : " + ajpPort);
        this.ajp.setPort(ajpPort);
    }

    public void setAjpMaxThreads(String ajpMaxThreads) {
        logger.finest("[Web configuration] setting max ajp threads : " + ajpMaxThreads);
        NotApplicableHelper.notApplicable("AJP.maxThreads");
    }

    public void setAjpMinSpareThreads(String ajpMinSpareThreads) {
        logger.finest("[Web configuration] setting min ajp spare threads : " + ajpMinSpareThreads);
        NotApplicableHelper.notApplicable("AJP.minSpareThreads");
    }

    public void setAjpMaxSpareThreads(String ajpMaxSpareThreads) {
        logger.finest("[Web configuration] setting max ajp spare threads : " + ajpMaxSpareThreads);
        NotApplicableHelper.notApplicable("AJP.maxSpareThreads");
    }

    public void setJvmRoute(String jvmRoute) {
        logger.finest("[Web configuration] setting jvm route : " + jvmRoute);
        this.jvmRoute = jvmRoute;
    }

    public void setHttpReplicationClusterName(String clusterName) {
        logger.finest("[Web configuration] setting cluster name : " + clusterName);
        this.cluster.setName(clusterName);
    }

    public void setHttpReplicationMulticastAddress(String mCastAddr) {
        logger.finest("[Web configuration] setting multi cast address : " + mCastAddr);
        this.cluster.setMcastAddr(mCastAddr);
    }

    public void setHttpReplicationMulticastPort(String mCastPort) {
        logger.finest("[Web configuration] setting multi cast port : " + mCastPort);
        this.cluster.setMcastPort(mCastPort);
    }

    public void setHttpReplicationListenPort(String listenPort) {
        logger.finest("[Web configuration] setting listen port : " + listenPort);
        this.cluster.setListenPort(listenPort);
    }

    public void setDbPort(String port) {
        logger.finest("[Database configuration] setting db port: " + port);
        this.isDbActivated = true;
        this.db.setPort(port);
    }

    public void setDbName(String name) {
        logger.finest("[Database configuration] setting db name: " + name);
        this.isDbActivated = true;
        this.db.setDbName(name);
    }

    public void setDbUsers(String users) {
        logger.finest("[Database configuration] setting db users: " + users);
        this.isDbActivated = true;
        this.db.setUsers(users);
    }

    public void setDiscoveryMasterActivated(Boolean masterActivated) {
        logger.finest("[Discovery configuration] setting masterActivated : " + masterActivated);
        this.jonasProperties.setMaster(masterActivated.booleanValue());
    }

    public void setDiscoverySourcePort(String sourcePort) {
        logger.finest("[Discovery configuration] setting source port : " + sourcePort);
        this.discovery.setSourcePort(sourcePort);
    }

    public void setDiscoveryDomainName(String domainName) {
        logger.finest("[Discovery configuration] setting domain name : " + domainName);
        this.addReplacement("jonas.properties", "domain.name    jonas", "domain.name    " + domainName);
    }

    public void setDiscoveryGreetingPort(String greetingPort) {
        logger.finest("[Discovery configuration] setting greeting port : " + greetingPort);
        this.discovery.setGreetingPort(greetingPort);
    }

    public void setDiscoveryMulticastAddress(String multicastAddress) {
        logger.finest("[Discovery configuration] setting multicast address : " + multicastAddress);
        this.discovery.setMcastAddr(multicastAddress);
    }

    public void setDiscoveryMulticastPort(String multicastPort) {
        logger.finest("[Discovery configuration] setting multicast port : " + multicastPort);
        this.discovery.setMcastPort(multicastPort);
    }

    public void setDiscoveryTTL(String ttl) {
        logger.finest("[Discovery configuration] setting ttl : " + ttl);
        this.discovery.setTtl(ttl);
    }

    public void setMailFactoryType(String factoryType) {
        logger.finest("[Mail Service Configuration] setting mail factory type : " + factoryType);
        this.mail.setType(factoryType);
        this.isMailActivated = true;
    }

    public void setMailFactoryName(String factoryName) {
        logger.finest("[Mail Service Configuration] setting mail factory name : " + factoryName);
        this.mail.setName(factoryName);
        this.isMailActivated = true;
    }

    public void setWsdlPublisherFileName(String fileName) {
        logger.finest("[WS Service configuration] setting wsdlPublisherFile name : " + fileName);
        this.wsdlPublisherFile.setName(fileName);
        this.isWsdlPublishActivated = true;
    }

    public void setWsdlPublisherFileDirectory(String fileDir) {
        logger.finest("[WS Service configuration] setting wsdlPublisherFile directory : " + fileDir);
        this.wsdlPublisherFile.setDir(fileDir);
        this.isWsdlPublishActivated = true;
    }

    public void setHaActivated(Boolean activated) {
        logger.finest("[HA Service configuration] setting ha activated : " + activated);
        this.isHaActivated = activated;
    }

    public void setHaMulticastAddress(String multicastAddr) {
        logger.finest("[HA Service configuration] setting multicast address : " + multicastAddr);
        this.ha.setMcastAddr(multicastAddr);
    }

    public void setHaMulticastPort(String multicastPort) {
        logger.finest("[HA Service configuration] setting multicast port : " + multicastPort);
        this.ha.setMcastPort(multicastPort);
    }

    public void setSecurityManagerActivated(Boolean activation) {
        logger.finest("[Security Manager configuration] setting isActivates : " + activation);
        this.jonasProperties.setSecurityManager(activation.booleanValue());
    }

    public void setEjbClusteringActivated(Boolean activated) {
        logger.finest("[Ejb Clustering configuration] setting ejb clustering activated activated : " + activated);
        this.isEjbClusteringActivated = activated;
    }

    public void setEjbClusteringMulticastAddress(String multicastAddr) {
        logger.finest("[Ejb Clustering configuration] setting multicast address : " + multicastAddr);
        this.cmi.setMcastAddr(multicastAddr);
    }

    public void setEjbClusteringMulticastPort(String multicastPort) {
        logger.finest("[Ejb Clustering configuration] setting multicast port : " + multicastPort);
        this.cmi.setMcastPort(multicastPort);
    }

    public void setJmsPort(String port) {
        logger.finest("[Jms configuration] setting port : " + port);
        this.jms.setPort(port);
    }

    public void setJmsQueues(String queue) {
        logger.finest("[Jms configuration] setting queue : " + queue);
        this.jms.setInitialQueues(queue);
    }

    public void setJmsTopics(String topic) {
        logger.finest("[Jms configuration] setting topic : " + topic);
        this.jms.setInitialTopics(topic);
    }

    public void addJdbcRA(String raName, JDBCConfiguration configuration) {
        JdbcXml jdbcXml = new JdbcXml();
        jdbcXml.setProject(this.project);
        if (configuration.driverName != null) {
            logger.finest("[Jdbc configuration] setting driverName: " + configuration.driverName);
            NotApplicableHelper.notApplicable("JDBC.driverName");
        }
        if (configuration.datasourceClass != null) {
            logger.finest("[Jdbc configuration] setting datasourceClass: " + configuration.datasourceClass);
            jdbcXml.setClassName(configuration.datasourceClass);
        }
        logger.finest("[Jdbc configuration] setting raName: " + raName);
        NotApplicableHelper.notApplicable("JDBC.raName");
        if (configuration.checkLevel != null) {
            logger.finest("[Jdbc configuration] setting checkLevel: " + configuration.checkLevel);
            jdbcXml.setConCheckLevel(configuration.checkLevel);
        }
        if (configuration.testStatement != null) {
            logger.finest("[Jdbc configuration] setting testStatement: " + configuration.testStatement);
            jdbcXml.setConTestStmt(configuration.testStatement);
        }
        if (configuration.jndiName != null) {
            logger.finest("[Jdbc configuration] setting jndiName: " + configuration.jndiName);
            jdbcXml.setName(configuration.jndiName);
        }
        if (configuration.mappername != null) {
            logger.finest("[Jdbc configuration] setting mappername: " + configuration.mappername);
            jdbcXml.setMapper(configuration.mappername);
        }
        if (configuration.password != null) {
            logger.finest("[Jdbc configuration] setting password: " + configuration.password);
            jdbcXml.setPassword(configuration.password);
        }
        if (configuration.rarLink != null) {
            logger.finest("[Jdbc configuration] setting rarLink: " + configuration.rarLink);
            NotApplicableHelper.notApplicable("JDBC.rarLink");
        }
        if (configuration.url != null) {
            logger.finest("[Jdbc configuration] setting url: " + configuration.url);
            jdbcXml.setUrl(configuration.url);
        }
        if (configuration.user != null) {
            logger.finest("[Jdbc configuration] setting user: " + configuration.user);
            jdbcXml.setUserName(configuration.user);
        }
        if (configuration.poolInitialSize != null) {
            logger.finest("[Jdbc configuration] setting poolInitialSize: " + configuration.poolInitialSize);
            jdbcXml.setInitConPool(configuration.poolInitialSize);
        }
        if (configuration.poolMaximumSize != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumSize: " + configuration.poolMaximumSize);
            jdbcXml.setMaxConPool(configuration.poolMaximumSize);
        }
        if (configuration.poolMaximumAgeMinutes != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumAgeMinutes: " + configuration.poolMaximumAgeMinutes);
            jdbcXml.setConnMaxAge(configuration.poolMaximumAgeMinutes);
        }
        if (configuration.poolMaximumOpenTime != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumOpenTime: " + configuration.poolMaximumOpenTime);
            jdbcXml.setMaxOpenTime(configuration.poolMaximumOpenTime);
        }
        if (configuration.poolMaximumNumberOfWaiters != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumNumberOfWaiters: " + configuration.poolMaximumNumberOfWaiters);
            jdbcXml.setMaxWaiters(configuration.poolMaximumNumberOfWaiters);
        }
        if (configuration.poolMaximumWaitTime != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumWaitTime: " + configuration.poolMaximumWaitTime);
            jdbcXml.setMaxWaitTime(configuration.poolMaximumWaitTime);
        }
        if (configuration.poolMinimumSize != null) {
            logger.finest("[Jdbc configuration] setting poolMinimumSize: " + configuration.poolMinimumSize);
            jdbcXml.setMinConPool(configuration.poolMinimumSize);
        }
        if (configuration.poolSamplingPeriod != null) {
            logger.finest("[Jdbc configuration] setting poolSamplingPeriod: " + configuration.poolSamplingPeriod);
            jdbcXml.setSamplingPeriod(configuration.poolSamplingPeriod);
        }
        if (configuration.poolMaximumNumberOfPreparedStatements != null) {
            logger.finest("[Jdbc configuration] setting poolMaximumNumberOfPreparedStatements: " + configuration.poolMaximumNumberOfPreparedStatements);
            jdbcXml.setPstmtMax(configuration.poolMaximumNumberOfPreparedStatements);
        }
        this.jdbcXml.put(raName, jdbcXml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Method m;
        if (!this.isJonasRootSet) {
            throw new IllegalArgumentException("Jonas root is not set.");
        }
        if (!this.isJonasBaseSet) {
            throw new IllegalArgumentException("Jonas base is not set.");
        }
        this.jonasBase.addConfiguredServices(this.services);
        if (this.isHaActivated.booleanValue()) {
            this.jonasBase.addTasks((Tasks)this.ha);
        }
        if (this.isEjbClusteringActivated.booleanValue()) {
            this.jonasBase.addTasks((Tasks)this.cmi);
        }
        this.jonasBase.execute();
        this.jonasProperties.execute();
        this.doReplacements(new java.io.File(this.jonasFileBase, "conf"));
        Object webContainer = null;
        try {
            if (this.webContainer == null) {
                Properties jonasProperties = new Properties();
                FileInputStream fis = new FileInputStream(new java.io.File(this.jonasFileBase, "conf/jonas.properties"));
                try {
                    jonasProperties.load(fis);
                }
                finally {
                    ((InputStream)fis).close();
                    fis = null;
                    System.gc();
                }
                String[] defaultWebcontainerClass = jonasProperties.getProperty("jonas.service.web.class").split("\\.");
                this.webContainer = defaultWebcontainerClass[defaultWebcontainerClass.length - 2];
            }
            for (String webContainerClassName : this.getAllClasses((URLClassLoader)this.getClass().getClassLoader(), WebContainer.class.getName())) {
                if (!webContainerClassName.contains(this.webContainer)) continue;
                webContainer = (WebContainer)this.getClass().getClassLoader().loadClass(webContainerClassName).newInstance();
                webContainer.setProject(this.project);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create Web container", e);
        }
        if (webContainer == null) {
            throw new IllegalStateException("Unknown Web container: " + this.webContainer);
        }
        if (this.jvmRoute != null) {
            Method m2 = null;
            try {
                m2 = webContainer.getClass().getMethod("setJvmRoute", String.class);
            }
            catch (Exception e) {
                NotApplicableHelper.notApplicable("Web.jvmRoute");
            }
            if (m2 != null) {
                try {
                    m2.invoke(webContainer, this.jvmRoute);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("[Web configuration] cannot set jvm route : " + this.jvmRoute, e);
                }
            }
        }
        Object connector = null;
        Method connectorMethod = null;
        for (Method method : webContainer.getClass().getMethods()) {
            if (!method.getName().equals("addConfiguredConnector") || method.getParameterTypes().length != 1) continue;
            try {
                connector = method.getParameterTypes()[0].newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot generate Web connector to configure", e);
            }
            connectorMethod = method;
            break;
        }
        if (connector == null) {
            throw new IllegalStateException("Cannot find method for adding configured Web connector");
        }
        if (this.isHttpActivated.booleanValue()) {
            try {
                m = connector.getClass().getMethod("addConfiguredHttp", this.https.getClass());
                m.invoke(connector, this.http);
            }
            catch (Exception e) {
                NotApplicableHelper.notApplicable("Web.HTTP");
            }
        }
        if (this.isHttpsActivated.booleanValue()) {
            try {
                m = connector.getClass().getMethod("addConfiguredHttps", this.https.getClass());
                m.invoke(connector, this.https);
            }
            catch (Exception e) {
                NotApplicableHelper.notApplicable("Web.HTTPS");
            }
        }
        if (this.isAjpActivated.booleanValue()) {
            try {
                m = connector.getClass().getMethod("addConfiguredAjp", this.ajp.getClass());
                m.invoke(connector, this.ajp);
            }
            catch (Exception e) {
                NotApplicableHelper.notApplicable("Web.AJP");
            }
        }
        if (this.isHttpReplicationActivated.booleanValue()) {
            try {
                m = webContainer.getClass().getMethod("addConfiguredCluster", this.cluster.getClass());
                m.invoke(webContainer, this.cluster);
            }
            catch (Exception e) {
                NotApplicableHelper.notApplicable("Web.Cluster");
            }
        }
        try {
            connectorMethod.invoke(webContainer, connector);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot add configured Web connector", e);
        }
        webContainer.execute();
        if (!this.isProtocolsListSet) {
            this.carol.setProtocols("jrmp");
        }
        this.carol.execute();
        if (this.isDbActivated) {
            this.db.execute();
        }
        this.discovery.execute();
        boolean first = true;
        for (JdbcXml jdbcXml : this.jdbcXml.values()) {
            jdbcXml.setNewFile(Boolean.toString(first));
            jdbcXml.execute();
            first = false;
        }
        this.jms.execute();
        if (this.isMailActivated) {
            this.mail.execute();
        }
        if (this.isWsdlPublishActivated) {
            this.wsdlPublish.addConfiguredFile(this.wsdlPublisherFile);
            this.wsdlPublish.execute();
        }
    }

    public void setCDClusterName(String clusterName) {
        logger.finest("[Cluster daemon configuration] setting cluster name : " + clusterName);
        this.clusterDaemon.setName(clusterName);
    }

    public void setCDClusterDomain(String clusterDomain) {
        logger.finest("[Cluster daemon configuration] setting cluster domain name : " + clusterDomain);
        this.clusterDaemon.setDomainName(clusterDomain);
    }

    public void setCDProtocol(String protocol) {
        logger.finest("[Cluster daemon configuration] setting protocol : " + protocol);
        this.clusterDaemon.setProtocol(protocol);
    }

    public void setCDPort(String port) {
        logger.finest("[Cluster daemon configuration] setting port : " + port);
        this.clusterDaemon.setPort(port);
    }

    public void setCDDestDirPrefix(String destDirPrefix) {
        logger.finest("[Cluster daemon configuration] setting dest dir prefix : " + destDirPrefix);
        this.clusterDaemon.setDestDirPrefix(destDirPrefix);
        this.clusterDaemon.setCdDir(destDirPrefix);
        this.project.setProperty("jonas.base", destDirPrefix);
    }

    public void setCDInteractionMode(String interactionMode) {
        logger.finest("[Cluster daemon configuration] setting interaction mode : " + interactionMode);
        this.clusterDaemon.setInteractionMode(interactionMode);
    }

    public void setCDJavaHome(String javaHome) {
        logger.finest("[Cluster daemon configuration] setting java home : " + javaHome);
        this.clusterDaemon.setJdk(javaHome);
    }

    public void setCDJonasRoot(String jonasRoot) {
        logger.finest("[Cluster daemon configuration] setting jonas root : " + jonasRoot);
        this.project.setProperty("jonas.root", jonasRoot);
        this.isJonasRootSet = true;
    }

    public void setCDServerNamePrefix(String serverNamePrefix) {
        logger.finest("[Cluster daemon configuration] setting server name prefix : " + serverNamePrefix);
        this.clusterDaemon.setClusterNodesName(serverNamePrefix);
    }

    public void setCDXparam(String xparam) {
        logger.finest("[Cluster daemon configuration] setting xparam : " + xparam);
        this.clusterDaemon.setXprm(xparam);
    }

    public void setCDAutoBoot(boolean autoBoot) {
        logger.finest("[Cluster daemon configuration] setting auto boot : " + autoBoot);
        this.clusterDaemon.setAutoBoot(new Boolean(autoBoot).toString());
    }

    public void setCDNbInstances(int nbInsts) {
        logger.finest("[Cluster daemon configuration] setting nb instance : " + nbInsts);
        this.clusterDaemon.setInstNb(nbInsts);
    }

    public void executeCDConf() {
        this.clusterDaemon.execute();
    }

    private SortedSet<String> getAllClasses(URLClassLoader urlCL, String parent) throws IOException, URISyntaxException, ClassNotFoundException {
        Class<?> parentClass;
        TreeSet<String> classes = new TreeSet<String>();
        try {
            parentClass = urlCL.loadClass(parent);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class " + parent + " not found in " + urlCL);
        }
        for (URL url : urlCL.getURLs()) {
            classes.addAll(this.getAllClasses(url, urlCL, parentClass));
        }
        return classes;
    }

    private SortedSet<String> getAllClasses(URL jarUrl, URLClassLoader urlCL, Class<?> parentClass) throws IOException, URISyntaxException, ClassNotFoundException {
        TreeSet<String> classes = new TreeSet<String>();
        java.io.File jarFile = new java.io.File(jarUrl.toURI());
        if (!jarFile.isFile()) {
            return classes;
        }
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            Class<?> entryClass;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(".class") || entryName.contains("$")) continue;
            entryName = entryName.substring(0, entryName.length() - 6);
            entryName = entryName.replace('/', '.');
            entryName = entryName.replace('\\', '.');
            try {
                entryClass = urlCL.loadClass(entryName);
            }
            catch (NoClassDefFoundError ignored) {
                continue;
            }
            if (entryClass.isInterface() || Modifier.isAbstract(entryClass.getModifiers()) || !parentClass.isAssignableFrom(entryClass)) continue;
            classes.add(entryName);
        }
        return classes;
    }
}

