package org.ow2.jonas.tools.configurator.impl;

import org.apache.tools.ant.Project;
import org.ow2.jonas.antmodular.jonasbase.wrapper.Wrapper;

/**
 * JOnAS wrapper configurator api
 */
public class JOnASWrapper {

    /**
     * JOnAS Wrapper
     */
    private Wrapper wrapper;

    /**
     * Default constructor
     */
    public JOnASWrapper() {
        this.wrapper = new Wrapper();
    }

    /**
     * @param project ANT project to set
     */
    public void setProject(final Project project) {
        this.wrapper.setProject(project);
    }

    /**
      * @param javaHome The JAVA_HOME to set
     */
    public void setJavaHome(final String javaHome) {
        if (javaHome != null) {
            this.wrapper.setJavaHome(javaHome);
        }
    }

    /**
     * @param wrapperHome The wrapper home to set
     */
    public void setWrapperHome(final String wrapperHome) {
        if (wrapperHome != null) {
            this.wrapper.setWrapperHome(wrapperHome);
        }
    }

    /**
     * @param serviceName The service name to set
     */
    public void setServiceName(final String serviceName) {
        if (serviceName != null) {
            this.wrapper.setServiceName(serviceName);
        }
    }

    /**
     * @param serviceDescription The service description to set
     */
    public void setServiceDescription(final String serviceDescription) {
        if (serviceDescription != null) {
            this.wrapper.setServiceDescription(serviceDescription);
        }
    }

    /**
     * @param verbosity The verbosity to set
     */
    public void setVerbosity(final Boolean verbosity) {
        if (verbosity != null) {
            this.wrapper.setVerbosity(verbosity);
        }
    }

    /**
     * @param logfile the log file to set
     */
    public void setLogfile(final String logfile) {
        if (logfile != null) {
            this.wrapper.setLogfile(logfile);
        }
    }

    /**
     * @param logfileRollmode The logfile rollmode to set
     */
    public void setLogfileRollmode(final String logfileRollmode) {
        if (logfileRollmode != null) {
            this.wrapper.setLogfileRollmode(logfileRollmode);
        }
    }

    /**
     * Execute ANT task
     */
    public void execute() {
        this.wrapper.execute();
    }
}
