/**
 * JOnAS Configurator
 * Copyright (C) 2008-2010 Bull S.A.S.
 * Copyright (C) 2008-2010 France Telecom R&D
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Jonas52.java 21063 2011-03-26 17:01:42Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.tools.configurator.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.ow2.jonas.ant.JOnASBaseTask;
import org.ow2.jonas.ant.jonasbase.JdbcXml;
import org.ow2.jonas.tools.configurator.api.JDBCConfiguration;

/**
 * JonasConfigurator implementation for Jonas 5.2.x (with JDBC XML)
 * 
 * @author Remy Bresson
 */
public class Jonas52 extends Jonas5 {

    /**
     * Configuration logger
     */
    private static Logger logger = Logger.getLogger(Jonas52.class.getName());

    /**
     * To configure jdbc
     */
    private Map<String, JdbcXml> jdbcXml;

    /**
     * Derfault constructor
     */
    public Jonas52() {
        super();

        this.jdbcXml = new HashMap<String, JdbcXml>();
    }

    /* ------------------------------- */
    /* Jdbc configuration */
    /**
     * {@inheritDoc}
     */
    @Override
    public void addJdbcRA(final String raName, final JDBCConfiguration configuration) {
        JdbcXml jdbcXml = new JdbcXml();

        if (configuration.driverName != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting driverName: " + configuration.driverName);
            NotApplicableHelper.notApplicable("JDBC.driverName");
        }

        if (configuration.datasourceClass != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting datasourceClass: " + configuration.datasourceClass);
            jdbcXml.setClassName(configuration.datasourceClass);
        }

        Jonas52.logger.finest("[Jdbc configuration] setting raName: " + raName);
        NotApplicableHelper.notApplicable("JDBC.raName");

        if (configuration.checkLevel != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting checkLevel: " + configuration.checkLevel);
            jdbcXml.setConCheckLevel(configuration.checkLevel);
        }

        if (configuration.testStatement != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting testStatement: " + configuration.testStatement);
            jdbcXml.setConTestStmt(configuration.testStatement);
        }

        if (configuration.jndiName != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting jndiName: " + configuration.jndiName);
            jdbcXml.setName(configuration.jndiName);
        }

        if (configuration.mappername != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting mappername: " + configuration.mappername);
            jdbcXml.setMapper(configuration.mappername);
        }

        if (configuration.password != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting password: " + configuration.password);
            jdbcXml.setPassword(configuration.password);
        }

        if (configuration.rarLink != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting rarLink: " + configuration.rarLink);
            NotApplicableHelper.notApplicable("JDBC.rarLink");
        }

        if (configuration.url != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting url: " + configuration.url);
            jdbcXml.setUrl(configuration.url);
        }

        if (configuration.user != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting user: " + configuration.user);
            jdbcXml.setUserName(configuration.user);
        }

        if (configuration.poolInitialSize != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting poolInitialSize: " + configuration.poolInitialSize);
            jdbcXml.setInitConPool(configuration.poolInitialSize);
        }

        if (configuration.poolMaximumSize != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting poolMaximumSize: " + configuration.poolMaximumSize);
            jdbcXml.setMaxConPool(configuration.poolMaximumSize);
        }

        if (configuration.poolMaximumAgeMinutes != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting poolMaximumAgeMinutes: " + configuration.poolMaximumAgeMinutes);
            jdbcXml.setConnMaxAge(configuration.poolMaximumAgeMinutes);
        }

        if (configuration.poolMaximumOpenTime != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting poolMaximumOpenTime: " + configuration.poolMaximumOpenTime);
            jdbcXml.setMaxOpenTime(configuration.poolMaximumOpenTime);
        }

        if (configuration.poolMaximumNumberOfWaiters != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting poolMaximumNumberOfWaiters: "
                + configuration.poolMaximumNumberOfWaiters);
            jdbcXml.setMaxWaiters(configuration.poolMaximumNumberOfWaiters);
        }

        if (configuration.poolMaximumWaitTime != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting poolMaximumWaitTime: " + configuration.poolMaximumWaitTime);
            jdbcXml.setMaxWaitTime(configuration.poolMaximumWaitTime);
        }

        if (configuration.poolMinimumSize != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting poolMinimumSize: " + configuration.poolMinimumSize);
            jdbcXml.setMinConPool(configuration.poolMinimumSize);
        }

        if (configuration.poolSamplingPeriod != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting poolSamplingPeriod: " + configuration.poolSamplingPeriod);
            jdbcXml.setSamplingPeriod(configuration.poolSamplingPeriod);
        }

        if (configuration.poolMaximumNumberOfPreparedStatements != null) {
            Jonas52.logger.finest("[Jdbc configuration] setting poolMaximumNumberOfPreparedStatements: "
                + configuration.poolMaximumNumberOfPreparedStatements);
            jdbcXml.setPstmtMax(configuration.poolMaximumNumberOfPreparedStatements);
        }

        this.jdbcXml.put(raName, jdbcXml);
    }

    /* ------------------------------- */

    /**
     * {@inheritDoc}
     */
    @Override
    protected void configureJdbc(JOnASBaseTask jonasBase) {
        boolean first = true;
        for (JdbcXml jdbcXml : this.jdbcXml.values()) {
            // The JdbcXml task will write all DS definitions to a single file
            // called JONAS_BASE/deploy/jdbc-ds.xml
            //
            // Since the file does not exist at the first call, we need to set
            // it as "new file"; after we tell JdbcXml to merge
            jdbcXml.setNewFile(Boolean.toString(first));
            first = false;

            jonasBase.addConfiguredJdbcXml(jdbcXml);
        }
    }

    /* --------------------------------- */
}
