/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.wrapper;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.ow2.jonas.antmodular.bootstrap.JOnASAntTool;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.BaseTaskItf;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JReplace;
import org.ow2.jonas.antmodular.jonasbase.wrapper.LogfileRollmode;

public class Wrapper
extends AbstractJOnASBaseAntTask {
    public static final String JONAS_WRAPPER_START_CONF = "jonas_start.conf";
    public static final String JONAS_WRAPPER_STOP_CONF = "jonas_stop.conf";
    public static final String JONAS_WRAPPER_BASE_CONF = "jonas_wrapper_base.conf";
    public static final String DELIMITER = "=";
    public static final String JAVA_COMMAND_PROPERTY = "wrapper.java.command";
    public static final String JAVA_COMMAND_TOKEN = "wrapper.java.command=/path/to/java";
    public static final String JONAS_ROOT_PROPERTY = "jonas.root";
    public static final String JONAS_ROOT_TOKEN = "jonas.root=/path/to/jonas-root";
    public static final String JONAS_BASE_PROPERTY = "jonas.base";
    public static final String JONAS_BASE_TOKEN = "jonas.base=/path/to/jonas-base";
    public static final String LOGFILE_PROPERTY = "wrapper.logfile";
    public static final String LOGFILE_TOKEN = "wrapper.logfile=${wrapper.working.dir}/logs/wrapper.log";
    public static final String LOGFILE_ROLLMODE_PROPERTY = "wrapper.logfile.rollmode";
    public static final String LOGFILE_ROLLMODE_TOKEN = "wrapper.logfile.rollmode=DATE";
    public static final String SERVICE_NAME_PROPERTY = "wrapper.ntservice.name";
    public static final String SERVICE_NAME_TOKEN = "wrapper.ntservice.name=yajsw";
    public static final String SERVICE_DISPLAYNAME = "wrapper.ntservice.displayname";
    public static final String SERVICE_DISPLAYNAME_TOKEN = "wrapper.ntservice.displayname=yajsw";
    public static final String SERVICE_DESCRIPTION_PROPERTY = "wrapper.ntservice.description";
    public static final String SERVICE_DESCRIPTION_TOKEN = "wrapper.ntservice.description=yajsw";
    public static final String VERBOSITY_PROPERTY = "wrapper.debug";
    public static final String VERBOSITY_TOKEN = "wrapper.debug=false";
    public static final String DEFAULT_WRAPPER_HOME_DIRECTORY_NAME = "wrapper";
    public static final String JONAS_WRAPPER_SETENV_SH = "setenv.sh";
    public static final String WRAPPER_BASE_INCLUDE_PROPERTY = "include";
    public static final String WRAPPER_CONF_DIR = "conf";
    public static final String WRAPPER_BIN_DIR = "bat";
    public static final String WRAPPER_BASE_INCLUDE_TOKEN = "include=conf" + File.separator + "jonas_wrapper_base.conf";
    public static final String WRAPPER_STOP_INCLUDE_FILE = "wrapper.stop.conf";
    public static final String WRAPPER_STOP_INCLUDE_TOKEN = "wrapper.stop.conf=conf" + File.separator + "jonas_stop.conf";
    public static final String WRAPPER_ROOT_PROPERTY = "wrapper_root";
    public static final String WRAPPER_ROOT_TOKEN = "wrapper_root=\"$PRGDIR\"/..";
    public static final String SETENV_WRAPPER_BASE_PROPERTY = "wrapper_base";
    public static final String SETENV_WRAPPER_BASE_TOKEN = "wrapper_base=\"$wrapper_root\"";
    public static final String WRAPPER_BASE_VAR_PROPERTY = "wrapper.base";
    public static final String WRAPPER_BASE_VAR_TOKEN = "wrapper.base=/path/to/wrapper-base";
    private String javaHome;
    private String wrapperHome;
    private String serviceName;
    private String serviceDescription;
    private Boolean verbosity;
    private String logfile;
    private LogfileRollmode logfileRollmode;

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public void setWrapperHome(String wrapperHome) {
        this.wrapperHome = wrapperHome;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setLogfileRollmode(LogfileRollmode logfileRollmode) {
        this.logfileRollmode = logfileRollmode;
    }

    public void setLogfileRollmode(String logfileRollmode) {
        if ("JVM".equals(logfileRollmode)) {
            this.logfileRollmode = LogfileRollmode.JVM;
        } else if ("DATE".equals(logfileRollmode)) {
            this.logfileRollmode = LogfileRollmode.DATE;
        }
    }

    public void setVerbosity(Boolean verbosity) {
        this.verbosity = verbosity;
    }

    public void setServiceDescription(String serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public void setLogfile(String logfile) {
        this.logfile = logfile;
    }

    public void execute() {
        File wrapperRoot;
        super.execute();
        File wrapperBase = new File(this.getJOnASBase(), DEFAULT_WRAPPER_HOME_DIRECTORY_NAME);
        if (this.wrapperHome == null || !new File(this.wrapperHome).isDirectory()) {
            wrapperRoot = new File(this.getJOnASRoot(), DEFAULT_WRAPPER_HOME_DIRECTORY_NAME);
            if (wrapperRoot == null || !wrapperRoot.isDirectory()) {
                throw new BuildException("Cannot found a valid wrapper home directory");
            }
        } else {
            wrapperRoot = new File(this.wrapperHome);
        }
        Copy copy = new Copy();
        JOnASAntTool.configure((Task)this, (Task)copy);
        copy.setTodir(wrapperBase);
        FileSet confFileSet = new FileSet();
        confFileSet.setDir(new File(new File(wrapperRoot, "templates"), WRAPPER_CONF_DIR));
        FileSet binFileSet = new FileSet();
        binFileSet.setDir(new File(new File(wrapperRoot, "templates"), WRAPPER_BIN_DIR));
        copy.addFileset(confFileSet);
        copy.addFileset(binFileSet);
        copy.setOverwrite(true);
        copy.execute();
        File jonasWrapperBaseConfFile = new File(new File(wrapperBase, WRAPPER_CONF_DIR), JONAS_WRAPPER_BASE_CONF);
        if (!jonasWrapperBaseConfFile.exists() || !jonasWrapperBaseConfFile.isFile()) {
            throw new BuildException("File " + jonasWrapperBaseConfFile.getAbsolutePath() + " doesn't exist");
        }
        if (this.javaHome == null || !new File(this.javaHome).exists()) {
            this.javaHome = System.getenv("JAVA_HOME");
        }
        File java = new File(new File(this.javaHome, "bin"), "java");
        JReplace javaHomeReplace = new JReplace();
        javaHomeReplace.setFile(jonasWrapperBaseConfFile);
        javaHomeReplace.setToken(JAVA_COMMAND_TOKEN);
        javaHomeReplace.setValue("wrapper.java.command=" + java.getAbsolutePath());
        javaHomeReplace.setLogInfo("Setting JAVA to " + java.getAbsolutePath());
        this.addTask((BaseTaskItf)javaHomeReplace);
        JReplace jonasRootReplace = new JReplace();
        jonasRootReplace.setFile(jonasWrapperBaseConfFile);
        jonasRootReplace.setToken(JONAS_ROOT_TOKEN);
        jonasRootReplace.setValue("jonas.root=" + this.jonasRoot);
        jonasRootReplace.setLogInfo("Setting JONAS_ROOT to " + this.jonasRoot);
        this.addTask((BaseTaskItf)jonasRootReplace);
        JReplace jonasBaseReplace = new JReplace();
        jonasBaseReplace.setFile(jonasWrapperBaseConfFile);
        jonasBaseReplace.setToken(JONAS_BASE_TOKEN);
        jonasBaseReplace.setValue("jonas.base=" + this.getJOnASBase());
        jonasBaseReplace.setLogInfo("Setting JONAS_BASE to " + this.getJOnASBase());
        this.addTask((BaseTaskItf)jonasBaseReplace);
        if (this.verbosity != null) {
            JReplace verbosityReplace = new JReplace();
            verbosityReplace.setFile(jonasWrapperBaseConfFile);
            verbosityReplace.setToken(VERBOSITY_TOKEN);
            verbosityReplace.setValue("wrapper.debug=" + String.valueOf(this.verbosity));
            verbosityReplace.setLogInfo("Setting wrapper.debug to " + this.verbosity);
            this.addTask((BaseTaskItf)verbosityReplace);
        }
        if (this.serviceName != null) {
            JReplace serviceNameReplace = new JReplace();
            serviceNameReplace.setFile(jonasWrapperBaseConfFile);
            serviceNameReplace.setToken(SERVICE_NAME_TOKEN);
            serviceNameReplace.setValue("wrapper.ntservice.name=" + this.serviceName);
            serviceNameReplace.setLogInfo("Setting wrapper.ntservice.name to " + this.serviceName);
            this.addTask((BaseTaskItf)serviceNameReplace);
            JReplace serviceDisplayNameReplace = new JReplace();
            serviceDisplayNameReplace.setFile(jonasWrapperBaseConfFile);
            serviceDisplayNameReplace.setToken(SERVICE_DISPLAYNAME_TOKEN);
            serviceDisplayNameReplace.setValue("wrapper.ntservice.displayname=" + this.serviceName);
            serviceDisplayNameReplace.setLogInfo("Setting wrapper.ntservice.displayname to " + this.serviceName);
            this.addTask((BaseTaskItf)serviceDisplayNameReplace);
        }
        if (this.serviceDescription != null) {
            JReplace serviceDescriptionReplace = new JReplace();
            serviceDescriptionReplace.setFile(jonasWrapperBaseConfFile);
            serviceDescriptionReplace.setToken(SERVICE_DESCRIPTION_TOKEN);
            serviceDescriptionReplace.setValue("wrapper.ntservice.description=" + this.serviceDescription);
            serviceDescriptionReplace.setLogInfo("Setting wrapper.ntservice.description to " + this.serviceDescription);
            this.addTask((BaseTaskItf)serviceDescriptionReplace);
        }
        if (this.logfile != null) {
            JReplace logfileReplace = new JReplace();
            logfileReplace.setFile(jonasWrapperBaseConfFile);
            logfileReplace.setToken(LOGFILE_TOKEN);
            logfileReplace.setValue("wrapper.logfile=" + this.logfile);
            logfileReplace.setLogInfo("Setting wrapper.logfile to " + this.logfile);
            this.addTask((BaseTaskItf)logfileReplace);
        }
        if (this.logfileRollmode != null) {
            JReplace logfileRollmodeReplace = new JReplace();
            logfileRollmodeReplace.setFile(jonasWrapperBaseConfFile);
            logfileRollmodeReplace.setToken(LOGFILE_ROLLMODE_TOKEN);
            logfileRollmodeReplace.setValue("wrapper.logfile.rollmode=" + (Object)((Object)this.logfileRollmode));
            logfileRollmodeReplace.setLogInfo("Setting wrapper.logfile.rollmode to " + (Object)((Object)this.logfileRollmode));
            this.addTask((BaseTaskItf)logfileRollmodeReplace);
        }
        File wrapperBinDir = new File(wrapperBase, WRAPPER_BIN_DIR);
        JReplace setenvReplace1 = new JReplace();
        setenvReplace1.setFile(new File(wrapperBinDir, JONAS_WRAPPER_SETENV_SH));
        setenvReplace1.setToken(WRAPPER_ROOT_TOKEN);
        setenvReplace1.setValue("wrapper_root=" + wrapperRoot.getAbsolutePath());
        this.addTask((BaseTaskItf)setenvReplace1);
        if (!wrapperRoot.getAbsolutePath().equals(wrapperBase.getAbsolutePath())) {
            JReplace setenvReplace2 = new JReplace();
            setenvReplace2.setFile(new File(wrapperBinDir, JONAS_WRAPPER_SETENV_SH));
            setenvReplace2.setToken(SETENV_WRAPPER_BASE_TOKEN);
            setenvReplace2.setValue("wrapper_base=" + wrapperBase);
            this.addTask((BaseTaskItf)setenvReplace2);
        }
        File jonasWrapperStartConf = new File(new File(wrapperBase, WRAPPER_CONF_DIR), JONAS_WRAPPER_START_CONF);
        JReplace jonasWrapperStartReplace = new JReplace();
        jonasWrapperStartReplace.setFile(jonasWrapperStartConf);
        jonasWrapperStartReplace.setToken(WRAPPER_BASE_VAR_TOKEN);
        jonasWrapperStartReplace.setValue("wrapper.base=" + wrapperBase);
        this.addTask((BaseTaskItf)jonasWrapperStartReplace);
        File jonasWrapperStopConf = new File(new File(wrapperBase, WRAPPER_CONF_DIR), JONAS_WRAPPER_STOP_CONF);
        JReplace jonasWrapperStopReplace = new JReplace();
        jonasWrapperStopReplace.setFile(jonasWrapperStopConf);
        jonasWrapperStopReplace.setToken(WRAPPER_BASE_VAR_TOKEN);
        jonasWrapperStopReplace.setValue("wrapper.base=" + wrapperBase);
        this.addTask((BaseTaskItf)jonasWrapperStopReplace);
        super.executeAllTask();
    }
}

