/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.jta.rmi;

import java.io.IOException;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.jta.rmi.JTATransactionServiceContext;
import org.ow2.carol.rmi.jrmp.interceptor.api.JServerRequestInfo;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JServerRequestInterceptor;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JServiceContext;

public class JTAServerTransactionInterceptor
implements JServerRequestInterceptor {
    public static int TX_CTX_ID = 0;
    private static Current current = null;
    private static String interceptorName = "JTAServerTransactionInterceptor";

    public JTAServerTransactionInterceptor() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"JTAServerTransactionInterceptor constructor");
        }
    }

    public void receive_request(JServerRequestInfo jri) throws IOException {
        JTATransactionServiceContext jtasc;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"JTAServerTransactionInterceptor.receive_request");
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (jtasc = (JTATransactionServiceContext)jri.get_request_service_context(TX_CTX_ID)) != null) {
            current.setPropagationContext(jtasc.getTransactionContext(), false);
        }
    }

    public void send_reply(JServerRequestInfo jri) throws IOException {
        TransactionContext txCtx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"JTAServerTransactionInterceptor.send_reply");
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (txCtx = current.getPropagationContext(false)) != null) {
            JTATransactionServiceContext jtasc = new JTATransactionServiceContext();
            jtasc.setContext(txCtx, true);
            jri.add_reply_service_context((JServiceContext)jtasc);
            current.setPropagationContext(null, false);
        }
    }

    public String name() {
        return interceptorName;
    }

    public void send_exception(JServerRequestInfo jri) throws IOException {
        TransactionContext txCtx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"JTAServerTransactionInterceptor.send_exception");
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (txCtx = current.getPropagationContext(false)) != null) {
            JTATransactionServiceContext jtasc = new JTATransactionServiceContext();
            jtasc.setContext(txCtx, true);
            jri.add_reply_service_context((JServiceContext)jtasc);
            current.setPropagationContext(null, false);
        }
    }

    public void send_other(JServerRequestInfo jri) throws IOException {
        TransactionContext txCtx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"JTAServerTransactionInterceptor.send_other");
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (txCtx = current.getPropagationContext(false)) != null) {
            JTATransactionServiceContext jtasc = new JTATransactionServiceContext();
            jtasc.setContext(txCtx, true);
            jri.add_reply_service_context((JServiceContext)jtasc);
            current.setPropagationContext(null, false);
        }
    }
}

