/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.ots;

import org.objectweb.jotm.Current;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.ots.OTSInterceptor;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;

public class OTSClientTransactionInterceptor
extends OTSInterceptor
implements ClientRequestInterceptor {
    private static Current current = null;
    private static final String NAME = "OTSClientTransactionInteceptor";

    public OTSClientTransactionInterceptor(ORBInitInfo info) {
        super(info);
    }

    public String name() {
        return NAME;
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo jri) throws ForwardRequest {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                TransactionContext txCtx = current.getPropagationContext(true);
                ServiceContext pContext = null;
                if (txCtx != null) {
                    pContext = this.buildCorbaPropagationContext(txCtx);
                    jri.add_request_service_context(pContext, true);
                }
            }
            catch (Exception e) {
                throw new ForwardRequest();
            }
        }
    }

    public void receive_reply(ClientRequestInfo jri) {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                TransactionContext txCtx = this.decodeCorbaPropagationContext(jri.get_reply_service_context(0));
                if (txCtx != null) {
                    current.setPropagationContext(txCtx, true);
                }
            }
            catch (BAD_PARAM b) {
                TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ": no transaction context for this call"));
            }
            catch (Exception e) {
                TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ":" + e));
            }
        }
    }

    public void send_poll(ClientRequestInfo jri) {
    }

    public void receive_exception(ClientRequestInfo jri) throws ForwardRequest {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                ServiceContext serviceContext = jri.get_reply_service_context(0);
                TransactionContext txCtx = this.decodeCorbaPropagationContext(serviceContext);
                if (txCtx != null) {
                    current.setPropagationContext(txCtx, true);
                }
            }
            catch (BAD_PARAM b) {
                TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ": no transaction context for this call"));
            }
            catch (Exception e) {
                TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ":" + e));
            }
        }
    }

    public void receive_other(ClientRequestInfo jri) throws ForwardRequest {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ":" + jri.operation()));
        }
    }
}

