/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.ots;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.ots.OTSInterceptor;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class OTSServerTransactionInterceptor
extends OTSInterceptor
implements ServerRequestInterceptor {
    private static Current current = null;
    private Map contexts = Collections.synchronizedMap(new HashMap());
    private static final String NAME = "OTSServerTransactionInteceptor";

    public OTSServerTransactionInterceptor(ORBInitInfo info) {
        super(info);
    }

    public String name() {
        return NAME;
    }

    public void receive_request_service_contexts(ServerRequestInfo jri) throws ForwardRequest {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ":" + jri.operation()));
        }
        try {
            ServiceContext serviceContext = jri.get_request_service_context(0);
            TransactionContext txCtx = this.decodeCorbaPropagationContext(serviceContext);
            if (txCtx != null) {
                Integer key = new Integer(jri.request_id());
                this.contexts.put(key, txCtx);
            }
        }
        catch (BAD_PARAM b) {
            TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + " no Tx Ctx"));
        }
        catch (Exception e) {
            TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + e));
            throw new ForwardRequest();
        }
    }

    public void receive_request(ServerRequestInfo jri) throws ForwardRequest {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ":" + jri.operation()));
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            Integer key = new Integer(jri.request_id());
            InternalTransactionContext txCtx = null;
            txCtx = (InternalTransactionContext)this.contexts.remove(key);
            current.setPropagationContext((TransactionContext)txCtx, false);
        }
    }

    public void send_reply(ServerRequestInfo jri) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ":" + jri.operation()));
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                TransactionContext txCtx = current.getPropagationContext(false);
                ServiceContext pContext = null;
                if (txCtx != null) {
                    pContext = this.buildCorbaPropagationContext(txCtx);
                    jri.add_reply_service_context(pContext, true);
                    current.setPropagationContext(null, false);
                }
            }
            catch (Exception e) {
                TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ":" + e));
            }
        }
    }

    public void send_exception(ServerRequestInfo jri) throws ForwardRequest {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ":" + jri.operation()));
        }
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                TransactionContext txCtx = current.getPropagationContext(false);
                ServiceContext pContext = null;
                if (txCtx != null) {
                    pContext = this.buildCorbaPropagationContext(txCtx);
                    jri.add_reply_service_context(pContext, true);
                    current.setPropagationContext(null, false);
                }
            }
            catch (Exception e) {
                TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ":" + e));
            }
        }
    }

    public void send_other(ServerRequestInfo jri) throws ForwardRequest {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("SRI=" + jri.request_id() + ":" + jri.operation()));
        }
    }

    public void destroy() {
        TraceTm.jta.debug((Object)"");
    }
}

