/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.ots;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.ots.OTSInterceptor;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class OTSServerTransactionInterceptor
extends OTSInterceptor
implements ServerRequestInterceptor {
    private static Current current = null;
    private Map contexts = Collections.synchronizedMap(new HashMap());
    private String interceptorName = "OTSServerTransactionInteceptor";

    public OTSServerTransactionInterceptor(ORBInitInfo info) {
        super(info);
    }

    public String name() {
        return this.interceptorName;
    }

    public void receive_request_service_contexts(ServerRequestInfo jri) throws ForwardRequest {
        try {
            TransactionContext txCtx = this.decodeCorbaPropagationContext(jri.get_request_service_context(0));
            if (txCtx != null) {
                Integer key = new Integer(jri.request_id());
                this.contexts.put(key, txCtx);
            }
        }
        catch (BAD_PARAM b) {
        }
        catch (Exception e) {
            throw new ForwardRequest();
        }
    }

    public void receive_request(ServerRequestInfo jri) throws ForwardRequest {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            Integer key = new Integer(jri.request_id());
            InternalTransactionContext txCtx = (InternalTransactionContext)this.contexts.remove(key);
            current.setPropagationContext((TransactionContext)txCtx, false);
        }
    }

    public void send_reply(ServerRequestInfo jri) {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                TransactionContext txCtx = current.getPropagationContext(false);
                ServiceContext pContext = null;
                if (txCtx != null) {
                    pContext = this.buildCorbaPropagationContext(txCtx);
                    jri.add_reply_service_context(pContext, true);
                    current.setPropagationContext(null, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void send_exception(ServerRequestInfo jri) throws ForwardRequest {
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null) {
            try {
                TransactionContext txCtx = current.getPropagationContext(false);
                ServiceContext pContext = null;
                if (txCtx != null) {
                    pContext = this.buildCorbaPropagationContext(txCtx);
                    jri.add_reply_service_context(pContext, true);
                    current.setPropagationContext(null, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void send_other(ServerRequestInfo jri) throws ForwardRequest {
    }

    public void destroy() {
    }
}

