/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jotm.jms;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jotm.jms.JConnection;
import org.ow2.jotm.jms.JmsManagerImpl;

public class JSession
implements Session,
Synchronization {
    protected XAResource xares = null;
    protected boolean txover = true;
    protected Transaction currtx = null;
    protected boolean closed = false;
    protected JConnection jconn;
    protected static TransactionManager tm = null;
    protected XAConnection xac;
    protected Session sess = null;
    protected XASession xasess = null;
    protected Logger logger;

    protected JSession(JConnection jconn, Logger logger) {
        this.jconn = jconn;
        this.logger = logger;
        if (tm == null) {
            tm = JmsManagerImpl.getTransactionManager();
        }
    }

    public JSession(JConnection jconn, XAConnection xac, Logger logger) {
        this(jconn, logger);
        this.xac = xac;
    }

    protected XAResource getXAResource() {
        return this.xares;
    }

    protected Session getMOMSession() throws JMSException {
        Transaction tx = null;
        try {
            tx = tm.getTransaction();
        }
        catch (SystemException e) {
            System.out.println("getMOMSession: cannot get Transaction");
        }
        if (tx == null) {
            if (this.sess == null) {
                this.sess = this.xac.createSession(false, 1);
                this.jconn.sessionOpen(this);
            }
            return this.sess;
        }
        if (this.xasess == null) {
            this.xasess = this.xac.createXASession();
            if (this.currtx != null) {
                System.out.println("getMOMSession: mixed transactions");
            }
            this.currtx = tx;
            this.xares = this.xasess.getXAResource();
            try {
                tx.enlistResource(this.xares);
                this.txover = false;
            }
            catch (SystemException e) {
                throw new JMSException(e.toString());
            }
            catch (RollbackException e) {
                throw new JMSException(e.toString());
            }
        }
        return this.xasess.getSession();
    }

    protected void MOMSessionClose() {
        try {
            if (this.xasess != null) {
                this.xasess.close();
                this.xasess = null;
            }
            if (this.sess != null) {
                this.sess.close();
                this.sess = null;
                this.jconn.sessionClose(this);
            }
        }
        catch (JMSException e) {
            System.out.println("MOMSessionClose:" + (Object)((Object)e));
        }
    }

    protected void PhysicalClose() {
        this.MOMSessionClose();
    }

    public void close() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.closed = true;
        if (this.txover) {
            this.PhysicalClose();
        } else if (this.currtx == null) {
            System.out.println("should be in a tx");
        } else {
            try {
                this.currtx.delistResource(this.xares, 0x4000000);
            }
            catch (SystemException e) {
                throw new JMSException(e.toString());
            }
        }
    }

    public void commit() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        throw new JMSException("JSession: commit Operation Not Allowed");
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createBrowser(queue, messageSelector);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createBytesMessage();
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createConsumer(destination, messageSelector);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createConsumer(destination, messageSelector, NoLocal);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createDurableSubscriber(topic, name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public MapMessage createMapMessage() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createObjectMessage(object);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createProducer(destination);
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createQueue(queueName);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createTemporaryTopic();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createTextMessage(text);
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().createTopic(topicName);
    }

    public MessageListener getMessageListener() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().getMessageListener();
    }

    public boolean getTransacted() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this.getMOMSession().getAcknowledgeMode();
    }

    public void recover() throws JMSException {
        throw new JMSException("JSession: recover Operation Not Allowed");
    }

    public void rollback() throws JMSException {
        throw new JMSException("JSession: rollback Operation Not Allowed");
    }

    public void run() {
        try {
            this.logger.log(BasicLevel.DEBUG, (Object)"");
            this.getMOMSession().run();
        }
        catch (JMSException e) {
            System.out.println("exception: " + (Object)((Object)e));
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.getMOMSession().setMessageListener(listener);
    }

    public void unsubscribe(String name) throws JMSException {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.getMOMSession().unsubscribe(name);
    }

    public void beforeCompletion() {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
    }

    public void afterCompletion(int status) {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.txover = true;
        if (this.closed) {
            this.PhysicalClose();
        }
    }
}

