/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jotm.jms;

import java.util.ArrayList;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.MonologFactory;
import org.ow2.jotm.jms.JConnectionFactory;
import org.ow2.jotm.jms.JQueueConnectionFactory;
import org.ow2.jotm.jms.JTopicConnectionFactory;
import org.ow2.jotm.jms.JmsAdminForJoram;
import org.ow2.jotm.jms.api.JmsAdministration;
import org.ow2.jotm.jms.api.JmsManager;

public class JmsManagerImpl
implements JmsManager {
    private JmsAdministration momadmin = null;
    private InitialContext ictx = null;
    private ConnectionFactory cf = null;
    private TopicConnectionFactory tcf = null;
    private QueueConnectionFactory qcf = null;
    private ArrayList<String> namelist = new ArrayList();
    private static TransactionManager tm = null;
    private static JmsManagerImpl unique = null;
    private Logger logger;

    private JmsManagerImpl() {
        MonologFactory lf = Monolog.initialize();
        this.logger = lf.getLogger("org.ow2.jotm.jms");
        this.logger.log(BasicLevel.INFO, (Object)"JmsManager initialized");
    }

    public static JmsManager getInstance() {
        if (unique == null) {
            unique = new JmsManagerImpl();
        }
        return unique;
    }

    public static TransactionManager getTransactionManager() {
        return tm;
    }

    private XAConnectionFactory getXAConnectionFactory() {
        return this.momadmin.getXAConnectionFactory();
    }

    private XATopicConnectionFactory getXATopicConnectionFactory() {
        return this.momadmin.getXATopicConnectionFactory();
    }

    private XAQueueConnectionFactory getXAQueueConnectionFactory() {
        return this.momadmin.getXAQueueConnectionFactory();
    }

    public void init(Class cl, boolean collocated, String url, TransactionManager trm) throws Exception {
        tm = trm;
        this.ictx = new InitialContext();
        int maxloops = collocated ? 1 : 5;
        for (int i = 0; i < maxloops; ++i) {
            try {
                if (cl != null) {
                    this.momadmin = (JmsAdministration)cl.newInstance();
                } else {
                    this.logger.log(BasicLevel.DEBUG, (Object)"Using Joram");
                    this.momadmin = new JmsAdminForJoram();
                }
                this.momadmin.start(collocated, url);
                continue;
            }
            catch (NamingException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            catch (Exception e) {
                if (i < maxloops) {
                    System.out.println("cannot reach the MOM - retrying...");
                    try {
                        Thread.sleep(2000 * (i + 1));
                        continue;
                    }
                    catch (InterruptedException e2) {
                        System.out.println("cannot reach the MOM");
                        throw e;
                    }
                }
                throw e;
            }
        }
        this.getQueueConnectionFactory();
        this.getTopicConnectionFactory();
        this.getConnectionFactory();
    }

    public Queue createQueue(String name) throws Exception {
        try {
            Queue queue = (Queue)this.ictx.lookup(name);
            return queue;
        }
        catch (NamingException namingException) {
            Queue queue = this.momadmin.createQueue(name);
            this.namelist.add(name);
            return queue;
        }
    }

    public Topic createTopic(String name) throws Exception {
        try {
            Topic topic = (Topic)this.ictx.lookup(name);
            return topic;
        }
        catch (NamingException namingException) {
            Topic topic = this.momadmin.createTopic(name);
            this.namelist.add(name);
            return topic;
        }
    }

    public ConnectionFactory getConnectionFactory() throws Exception {
        if (this.cf == null) {
            String name = "CF";
            this.logger.log(BasicLevel.DEBUG, (Object)("Creating " + name));
            this.cf = new JConnectionFactory(name, this.getXAConnectionFactory(), this.logger);
            this.ictx.rebind(name, (Object)this.cf);
        }
        return this.cf;
    }

    public QueueConnectionFactory getQueueConnectionFactory() throws Exception {
        if (this.qcf == null) {
            String name = "QCF";
            this.logger.log(BasicLevel.DEBUG, (Object)("Creating " + name));
            this.qcf = new JQueueConnectionFactory(name, this.getXAQueueConnectionFactory(), this.logger);
            this.ictx.rebind(name, (Object)this.qcf);
        }
        return this.qcf;
    }

    public TopicConnectionFactory getTopicConnectionFactory() throws Exception {
        if (this.tcf == null) {
            String name = "TCF";
            this.logger.log(BasicLevel.DEBUG, (Object)("Creating " + name));
            this.tcf = new JTopicConnectionFactory(name, this.getXATopicConnectionFactory(), this.logger);
            this.ictx.rebind(name, (Object)this.tcf);
        }
        return this.tcf;
    }

    public void stop() throws Exception {
        if (this.cf != null) {
            ((JConnectionFactory)this.cf).cleanPool();
        }
        if (this.tcf != null) {
            ((JConnectionFactory)this.tcf).cleanPool();
        }
        if (this.qcf != null) {
            ((JConnectionFactory)this.qcf).cleanPool();
        }
        if (this.momadmin != null) {
            this.momadmin.stop();
        }
        for (String name : this.namelist) {
            try {
                this.ictx.unbind(name);
            }
            catch (NamingException e) {
                System.out.println("cannot unbind " + name);
            }
        }
    }
}

