/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jotm.jms;

import java.io.Serializable;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jotm.jms.JConnection;
import org.ow2.jotm.jms.JmsManagerImpl;
import org.ow2.jotm.jms.api.JmsManager;

public class JConnectionFactory
implements ConnectionFactory,
Referenceable,
Serializable {
    protected JmsManager jms;
    protected String name;
    protected XAConnectionFactory xacf;
    protected Logger logger;
    private final LinkedList<JConnection> connectionpool = new LinkedList();

    public JConnectionFactory(String name, XAConnectionFactory xacf, Logger logger) {
        this.name = name;
        this.xacf = xacf;
        this.logger = logger;
        this.jms = JmsManagerImpl.getInstance();
    }

    public Connection createConnection() throws JMSException {
        JConnection c = this.getJConnection(null);
        if (c == null) {
            c = new JConnection(this, this.xacf, this.logger);
        }
        return c;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        JConnection c = this.getJConnection(userName);
        if (c == null) {
            c = new JConnection(this, this.xacf, userName, password, this.logger);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeJConnection(JConnection con) {
        LinkedList<JConnection> linkedList = this.connectionpool;
        synchronized (linkedList) {
            this.connectionpool.addLast(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanPool() {
        LinkedList<JConnection> linkedList = this.connectionpool;
        synchronized (linkedList) {
            for (JConnection con : this.connectionpool) {
                try {
                    con.finalClose();
                }
                catch (JMSException e) {
                    System.out.println("Could not close connection: " + (Object)((Object)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JConnection getJConnection(String user) {
        if (user == null) {
            user = "anybody";
        }
        LinkedList<JConnection> linkedList = this.connectionpool;
        synchronized (linkedList) {
            for (JConnection con : this.connectionpool) {
                if (!con.getUser().equals(user)) continue;
                this.connectionpool.remove(con);
                return con;
            }
        }
        return null;
    }

    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getName(), "org.ow2.jotm.jms.JObjectFactory", null);
    }
}

