/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jotm.jms;

import fr.dyade.aaa.agent.AgentServer;
import java.util.StringTokenizer;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.XAConnectionFactory;
import org.objectweb.joram.client.jms.XAQueueConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.local.XALocalConnectionFactory;
import org.objectweb.joram.client.jms.local.XAQueueLocalConnectionFactory;
import org.objectweb.joram.client.jms.local.XATopicLocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.QueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XAQueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XATcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XATopicTcpConnectionFactory;
import org.ow2.jotm.jms.api.JmsAdministration;

public class JmsAdminForJoram
implements JmsAdministration {
    private static String QUEUE_CONN_FACT_NAME = "JQCF";
    private static String TOPIC_CONN_FACT_NAME = "JTCF";
    private static String CONN_FACT_NAME = "JCF";
    private InitialContext ictx = null;
    private javax.jms.XAConnectionFactory xacf = null;
    private XATopicConnectionFactory xatcf = null;
    private javax.jms.XAQueueConnectionFactory xaqcf = null;
    private User user = null;
    private String host = null;
    private int port;

    private void startMOM() throws Exception {
        System.setProperty("Transaction", "fr.dyade.aaa.util.NullTransaction");
        AgentServer.init((short)0, (String)"s0", null);
        AgentServer.start();
        Thread.sleep(10L);
        short sid = AgentServer.getServerId();
        this.host = AgentServer.getHostname((short)sid);
        this.port = 16010;
        try {
            String s = AgentServer.getServiceArgs((short)sid, (String)"org.objectweb.joram.mom.proxies.tcp.TcpProxyService");
            StringTokenizer st = new StringTokenizer(s);
            this.port = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException exc) {
            System.out.println("exception: " + exc);
        }
        catch (Exception e) {
            System.out.println("MOM exception:" + e);
            throw e;
        }
        System.out.println("starting MOM on host " + this.host + ", port " + this.port);
    }

    public void start(boolean collocated, String url) throws Exception {
        if (collocated) {
            this.startMOM();
        }
        this.ictx = new InitialContext();
        if (this.host != null) {
            AdminModule.collocatedConnect((String)"root", (String)"root");
        } else if (url != null && url.length() > 0) {
            int indexOfHost = url.indexOf("//") + 2;
            int indexOfPort = url.indexOf(":", indexOfHost) + 1;
            this.host = url.substring(indexOfHost, indexOfPort - 1);
            this.port = Integer.parseInt(url.substring(indexOfPort));
            AdminModule.connect((String)this.host, (int)this.port, (String)"root", (String)"root", (int)100);
        } else {
            AdminModule.connect((String)"root", (String)"root", (int)100);
        }
        this.user = User.create((String)"anonymous", (String)"anonymous");
        if (collocated) {
            this.xacf = XALocalConnectionFactory.create();
            ((XAConnectionFactory)this.xacf).getParameters().queueMessageReadMax = 2;
            this.xatcf = XATopicLocalConnectionFactory.create();
            ((org.objectweb.joram.client.jms.XATopicConnectionFactory)this.xatcf).getParameters().queueMessageReadMax = 2;
            this.xaqcf = XAQueueLocalConnectionFactory.create();
            ((XAQueueConnectionFactory)this.xaqcf).getParameters().queueMessageReadMax = 2;
        } else {
            this.xacf = XATcpConnectionFactory.create((String)this.host, (int)this.port);
            ((XAConnectionFactory)this.xacf).getParameters().queueMessageReadMax = 2;
            this.xatcf = XATopicTcpConnectionFactory.create((String)this.host, (int)this.port);
            ((org.objectweb.joram.client.jms.XATopicConnectionFactory)this.xatcf).getParameters().queueMessageReadMax = 2;
            this.xaqcf = XAQueueTcpConnectionFactory.create((String)this.host, (int)this.port);
            ((XAQueueConnectionFactory)this.xaqcf).getParameters().queueMessageReadMax = 2;
        }
        String name = CONN_FACT_NAME;
        try {
            ConnectionFactory jcf = TcpConnectionFactory.create((String)this.host, (int)this.port);
            this.ictx.rebind(name, (Object)jcf);
        }
        catch (NamingException e) {
            System.out.println("cannot register " + name);
        }
        name = QUEUE_CONN_FACT_NAME;
        try {
            QueueConnectionFactory jqcf = QueueTcpConnectionFactory.create((String)this.host, (int)this.port);
            this.ictx.rebind(name, (Object)jqcf);
        }
        catch (NamingException e) {
            System.out.println("cannot register " + name);
        }
        name = TOPIC_CONN_FACT_NAME;
        try {
            TopicConnectionFactory jtcf = TopicTcpConnectionFactory.create((String)this.host, (int)this.port);
            this.ictx.rebind(name, (Object)jtcf);
        }
        catch (NamingException e) {
            System.out.println("cannot register " + name);
        }
    }

    public void stop() {
        try {
            this.ictx.unbind(CONN_FACT_NAME);
            this.ictx.unbind(QUEUE_CONN_FACT_NAME);
            this.ictx.unbind(TOPIC_CONN_FACT_NAME);
        }
        catch (Exception ex) {
            System.out.println("cannot unbind connection factories");
        }
    }

    public javax.jms.XAConnectionFactory getXAConnectionFactory() {
        return this.xacf;
    }

    public XATopicConnectionFactory getXATopicConnectionFactory() {
        return this.xatcf;
    }

    public javax.jms.XAQueueConnectionFactory getXAQueueConnectionFactory() {
        return this.xaqcf;
    }

    public Queue createQueue(String name) throws Exception {
        org.objectweb.joram.client.jms.Queue queue;
        try {
            queue = (org.objectweb.joram.client.jms.Queue)this.ictx.lookup(name);
        }
        catch (Exception e) {
            queue = org.objectweb.joram.client.jms.Queue.create((String)name);
            this.ictx.rebind(name, (Object)queue);
        }
        queue.setWriter(this.user);
        queue.setReader(this.user);
        return queue;
    }

    public javax.jms.Topic createTopic(String name) throws Exception {
        Topic topic;
        try {
            topic = (Topic)this.ictx.lookup(name);
        }
        catch (Exception e) {
            topic = Topic.create((String)name);
            this.ictx.rebind(name, (Object)topic);
        }
        topic.setWriter(this.user);
        topic.setReader(this.user);
        return topic;
    }
}

