/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.WriterTarget;
import org.apache.log.output.io.rotate.FileStrategy;
import org.apache.log.output.io.rotate.RevolvingFileStrategy;
import org.apache.log.output.io.rotate.RotateStrategy;
import org.apache.log.output.io.rotate.RotateStrategyBySize;
import org.apache.log.output.io.rotate.RotatingFileTarget;
import org.jacorb.config.Configuration;
import org.jacorb.config.LoggerFactory;

public class LogKitLoggerFactory
implements LoggerFactory {
    private static final String DEFAULT_LOG_PATTERN = "[%.20{category}] %.7{priority} : %{message}\\n%{throwable}";
    private static final String name = "logkit";
    private PatternFormatter logFormatter = null;
    private int defaultPriority = 0;
    private final Map namedLoggers = new HashMap();
    private boolean append = false;
    private Writer consoleWriter;
    private LogTarget consoleTarget;
    private LogTarget defaultTarget = null;
    private Configuration configuration = null;

    public void configure(org.apache.avalon.framework.configuration.Configuration configuration) throws ConfigurationException {
        this.configuration = (Configuration)configuration;
        this.defaultPriority = configuration.getAttributeAsInteger("jacorb.log.default.verbosity", 0);
        this.append = configuration.getAttribute("jacorb.logfile.append", "off").equals("on");
        this.logFormatter = new PatternFormatter(configuration.getAttribute("jacorb.log.default.log_pattern", DEFAULT_LOG_PATTERN));
        switch (this.defaultPriority) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new ConfigurationException("'" + this.defaultPriority + "' is an illegal" + " value for the property jacorb.log.default.verbosity. Valid values are [0-4]");
            }
        }
        this.consoleWriter = new OutputStreamWriter(System.err);
        this.consoleTarget = new WriterTarget(this.consoleWriter, (Formatter)this.logFormatter);
    }

    public void setDefaultPriority(int n) {
        this.defaultPriority = n;
    }

    public final String getLoggingBackendName() {
        return name;
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String string) {
        return this.getNamedLogger(string, null);
    }

    public org.apache.avalon.framework.logger.Logger getNamedRootLogger(String string) {
        return this.getNamedLogger(string, this.consoleTarget);
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String string, String string2, long l) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Log file name must not be null!");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string2, this.append);
        WriterTarget writerTarget = null;
        if (l == 0L) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            writerTarget = new WriterTarget((Writer)outputStreamWriter, (Formatter)this.logFormatter);
        } else {
            writerTarget = new RotatingFileTarget(this.append, (Formatter)this.logFormatter, (RotateStrategy)new RotateStrategyBySize(l * 1000L), (FileStrategy)new RevolvingFileStrategy(new File(string2), 10000));
        }
        return this.getNamedLogger(string, (LogTarget)writerTarget);
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String string, LogTarget logTarget) {
        Object v = this.namedLoggers.get(string);
        if (v != null) {
            return (org.apache.avalon.framework.logger.Logger)v;
        }
        Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(string);
        int n = this.getPriorityForNamedLogger(string);
        logger.setPriority(LogKitLoggerFactory.intToPriority(n));
        if (logTarget != null) {
            logger.setLogTargets(new LogTarget[]{logTarget});
        } else if (this.defaultTarget == null) {
            logger.setLogTargets(new LogTarget[]{this.consoleTarget});
        } else {
            logger.setLogTargets(new LogTarget[]{this.defaultTarget});
        }
        LogKitLogger logKitLogger = new LogKitLogger(logger);
        this.namedLoggers.put(string, logKitLogger);
        return logKitLogger;
    }

    public int getPriorityForNamedLogger(String string) {
        String string2 = string;
        while (!string2.equals("")) {
            Object var3_3 = null;
            try {
                int n = this.configuration.getAttributeAsInteger(string2 + ".log.verbosity");
                if (n > 4) {
                    n = 4;
                } else if (n < 0) {
                    n = 0;
                }
                return n;
            }
            catch (ConfigurationException configurationException) {
                if (string2.lastIndexOf(".") >= 0) {
                    string2 = string2.substring(0, string2.lastIndexOf("."));
                    continue;
                }
                string2 = "";
            }
        }
        return this.defaultPriority;
    }

    public static Priority intToPriority(int n) {
        switch (n) {
            case 4: {
                return Priority.DEBUG;
            }
            case 3: {
                return Priority.INFO;
            }
            case 2: {
                return Priority.WARN;
            }
            case 1: {
                return Priority.ERROR;
            }
        }
        return Priority.FATAL_ERROR;
    }

    public void setDefaultLogFile(String string, long l) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string, this.append);
        if (l == 0L) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            this.defaultTarget = new WriterTarget((Writer)outputStreamWriter, (Formatter)this.logFormatter);
        } else {
            this.defaultTarget = new RotatingFileTarget(this.append, (Formatter)this.logFormatter, (RotateStrategy)new RotateStrategyBySize(l * 1000L), (FileStrategy)new RevolvingFileStrategy(new File(string), 10000));
        }
    }
}

