/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.joram.mom.dest.scheduler;

import com.scalagent.scheduler.AddConditionListener;
import com.scalagent.scheduler.Condition;
import com.scalagent.scheduler.RemoveConditionListener;
import com.scalagent.scheduler.ScheduleEvent;
import com.scalagent.scheduler.Scheduler;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Notification;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class SchedulerQueueImpl
extends QueueImpl {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)"com.scalagent.joram.scheduler.SchedulerQueueImpl");
    public static final String SCHEDULE_DATE = "scheduleDate";
    public static final String SCHEDULED = "scheduled";

    public SchedulerQueueImpl(AgentId destId, AgentId adminId, Properties prop) {
        super(destId, adminId, prop);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SchedulerQueueImpl.<init>(" + destId + ',' + adminId + ')'));
        }
    }

    public void postProcess(ClientMessages not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SchedulerQueueImpl.postProcess(" + not + ')'));
        }
        Enumeration msgs = not.getMessages().elements();
        while (msgs.hasMoreElements()) {
            Message msg = (Message)msgs.nextElement();
            long scheduleDate = SchedulerQueueImpl.getScheduleDate(msg);
            if (scheduleDate < 0L) {
                return;
            }
            this.forward(Scheduler.getDefault(), (Notification)new AddConditionListener(msg.id));
            this.forward(Scheduler.getDefault(), (Notification)new ScheduleEvent(msg.id, new Date(scheduleDate)));
        }
    }

    private static long getScheduleDate(Message msg) {
        Object scheduleDateValue = msg.getProperty(SCHEDULE_DATE);
        if (scheduleDateValue == null) {
            return -1L;
        }
        try {
            return (Long)scheduleDateValue;
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"Scheduled message error", (Throwable)exc);
            }
            return -1L;
        }
    }

    public void condition(Condition not) {
        String msgId = not.name;
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)this.messages.elementAt(i);
            if (!msg.getIdentifier().equals(msgId)) continue;
            try {
                msg.setObjectProperty(SCHEDULED, "" + System.currentTimeMillis());
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.forward(Scheduler.getDefault(), (Notification)new RemoveConditionListener(msg.getIdentifier()));
            break;
        }
        this.deliverMessages(0);
    }

    protected boolean checkDelivery(Message msg) {
        long scheduleDate;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SchedulerQueueImpl.checkDelivery(" + msg + ')'));
        }
        if ((scheduleDate = SchedulerQueueImpl.getScheduleDate(msg)) < 0L) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        return scheduleDate <= currentTime;
    }
}

