/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.DriverConnect;
import fr.dyade.aaa.agent.DriverDone;
import fr.dyade.aaa.agent.DriverIn;
import fr.dyade.aaa.agent.DriverMonitor;
import fr.dyade.aaa.agent.DriverOut;
import fr.dyade.aaa.agent.FlowControlNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.NotificationInputStream;
import fr.dyade.aaa.agent.NotificationOutputStream;
import fr.dyade.aaa.util.Queue;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class ProxyAgent
extends Agent {
    public static final int DRIVER_IN = 1;
    public static final int DRIVER_OUT = 2;
    protected boolean blockingCnx = true;
    protected boolean multipleCnx = false;
    protected int inFlowControl = 20;
    protected transient Queue qout;
    private transient DriverIn drvIn = null;
    private transient DriverOut drvOut = null;
    private transient DriverConnect drvCnx = null;
    protected boolean multiConn = false;
    protected transient Hashtable driversTable;
    private int driversKey = 1;
    boolean finalizing = false;
    protected transient NotificationInputStream ois = null;
    protected transient NotificationOutputStream oos = null;

    protected String getLogTopic() {
        String classname = this.getClass().getName();
        return "fr.dyade.aaa.agent.Agent.ProxyAgent." + classname.substring(classname.lastIndexOf(46) + 1);
    }

    public ProxyAgent() {
        this(null);
    }

    public ProxyAgent(String n) {
        this(AgentServer.getServerId(), n);
    }

    public ProxyAgent(short to, String n) {
        super(to, n, true);
    }

    public ProxyAgent(String name, int stamp) {
        super(name, true, stamp);
    }

    public String toString() {
        return "(" + super.toString() + ",blockingCnx=" + this.blockingCnx + ",multipleCnx=" + this.multipleCnx + ",inFlowControl=" + this.inFlowControl + ",multiConn=" + this.multiConn + ",qout=" + this.qout + ",driversKey=" + this.driversKey + ")";
    }

    public void setMultiConn() {
        this.multiConn = true;
    }

    protected void agentInitialize(boolean firstTime) throws Exception {
        super.agentInitialize(firstTime);
        if (!this.multiConn) {
            this.qout = new Queue();
        } else {
            this.driversTable = new Hashtable();
        }
        this.reinitialize();
    }

    protected void reinitialize() throws IOException {
        if (!(this.drvIn == null && this.drvOut == null || this.multiConn)) {
            throw new IllegalStateException();
        }
        this.drvCnx = new DriverConnect(this, this.blockingCnx, this.multipleCnx);
        this.drvCnx.start();
        if (this.multiConn) {
            DriverMonitor dMonitor = new DriverMonitor(this.drvIn, this.drvOut, this.qout, this.ois, this.oos, this.drvCnx);
            this.driversTable.put(new Integer(this.driversKey), dMonitor);
            ++this.driversKey;
        }
    }

    public abstract void connect() throws Exception;

    public abstract void disconnect() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDrivers() throws Exception {
        this.drvCnx.canStop = true;
        try {
            this.connect();
        }
        catch (InterruptedException exc) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + "InterruptedException"));
        }
        finally {
            if (this.drvCnx != null) {
                this.drvCnx.canStop = false;
            }
        }
        if (this.drvCnx == null || !this.drvCnx.isRunning) {
            return;
        }
        if (!this.multiConn) {
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connected"));
            }
            if (this.oos != null) {
                this.drvOut = new DriverOut(2, this, this.qout, this.oos);
                this.drvOut.start();
            }
            if (this.ois != null) {
                this.drvIn = new DriverIn(1, this, this.ois, this.inFlowControl);
                this.drvIn.start();
            }
        } else {
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)("connected - driversKey=" + this.driversKey));
            }
            if (this.ois != null) {
                this.drvIn = new DriverIn(1, this, this.ois, this.inFlowControl, this.driversKey);
                this.drvIn.start();
            }
            if (this.oos != null) {
                this.qout = new Queue();
                this.drvOut = new DriverOut(2, this, this.qout, this.oos, this.driversKey);
                this.drvOut.start();
            }
        }
    }

    protected void stop() {
        if (this.multiConn) {
            return;
        }
        if (this.drvCnx != null) {
            this.drvCnx.stop();
            this.drvCnx = null;
        }
        if (this.drvIn != null) {
            this.drvIn.stop();
            this.drvIn = null;
        }
        if (this.drvOut != null) {
            this.drvOut.stop();
            this.drvOut = null;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)"stopped");
        }
    }

    protected void stop(int drvKey) {
        DriverMonitor dMonitor = (DriverMonitor)this.driversTable.get(new Integer(drvKey));
        if (dMonitor != null) {
            if (dMonitor.drvCnx != null) {
                dMonitor.drvCnx.stop();
                dMonitor.drvCnx = null;
            }
            if (dMonitor.drvIn != null) {
                dMonitor.drvIn.stop();
                dMonitor.drvIn = null;
            }
            if (dMonitor.drvOut != null) {
                dMonitor.drvOut.stop();
                dMonitor.drvOut = null;
            }
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)("stopped - driversKey=" + this.driversKey));
            }
        }
    }

    public void cleanDriverOut() {
        if (!this.multiConn && this.drvOut != null) {
            this.drvOut.clean();
        }
    }

    public void cleanDriverOut(int drvKey) {
        DriverMonitor dMonitor = (DriverMonitor)this.driversTable.get(new Integer(drvKey));
        if (dMonitor != null && dMonitor.drvOut != null) {
            dMonitor.drvOut.clean();
        }
    }

    protected void closeAllConnections() {
        Enumeration keys = this.driversTable.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            DriverMonitor dMonitor = (DriverMonitor)this.driversTable.get(key);
            if (dMonitor == null) continue;
            if (dMonitor.ois != null) {
                try {
                    dMonitor.ois.close();
                }
                catch (IOException exc) {
                    // empty catch block
                }
                dMonitor.ois = null;
            }
            if (dMonitor.oos != null) {
                try {
                    dMonitor.oos.close();
                }
                catch (IOException exc) {
                    // empty catch block
                }
                dMonitor.oos = null;
                dMonitor.qout = null;
            }
            this.stop(key);
        }
        this.driversTable.clear();
    }

    protected void driverReact(int key, Notification not) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)("Proxy " + this + " gets not " + not + " from driver " + key));
        }
        this.sendTo(this.getId(), not);
    }

    protected void sendOut(int key, Notification not) throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)("Proxy " + this + " gets not " + not + " to pass to driver " + key));
        }
        try {
            DriverMonitor dMon = (DriverMonitor)this.driversTable.get(new Integer(key));
            dMon.getQout().push((Object)not);
        }
        catch (Exception e) {
            throw new Exception("Can't forward notification " + not + " to driver out " + key + ": " + e);
        }
    }

    public void react(AgentId from, Notification not) throws Exception {
        try {
            if (not instanceof DriverDone) {
                this.driverDone((DriverDone)not);
            } else if (not instanceof FlowControlNot) {
                int drvKey = ((FlowControlNot)not).driverKey;
                if (drvKey != 0) {
                    DriverMonitor dMon = (DriverMonitor)this.driversTable.get(new Integer(drvKey));
                    DriverIn dIn = dMon.drvIn;
                    dIn.recvFlowControl((FlowControlNot)not);
                } else {
                    this.drvIn.recvFlowControl((FlowControlNot)not);
                }
            } else if (not instanceof DeleteNot) {
                this.closeAllConnections();
                super.react(from, not);
            } else if (!from.equals(this.getId())) {
                this.qout.push((Object)not);
            } else {
                super.react(from, not);
            }
        }
        catch (Exception exc) {
            if (this.logmon.isLoggable(BasicLevel.ERROR)) {
                this.logmon.log(BasicLevel.ERROR, (Object)("error in " + this + ".react(" + from + ", " + not + ")"), (Throwable)exc);
            }
            this.stop();
        }
    }

    protected void driverDone(DriverDone not) throws IOException {
        if (!this.multiConn) {
            switch (not.getDriver()) {
                case 1: {
                    try {
                        this.ois.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.ois = null;
                    this.drvIn = null;
                    break;
                }
                case 2: {
                    try {
                        this.oos.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.oos = null;
                    this.drvOut = null;
                }
            }
        } else {
            int drvKey = not.getDriverKey();
            DriverMonitor dMonitor = (DriverMonitor)this.driversTable.get(new Integer(drvKey));
            if (dMonitor != null) {
                switch (not.getDriver()) {
                    case 1: {
                        if (dMonitor.drvIn != null) {
                            dMonitor.drvIn.close();
                        }
                        dMonitor.ois = null;
                        dMonitor.drvIn = null;
                        break;
                    }
                    case 2: {
                        if (dMonitor.drvOut != null) {
                            dMonitor.drvOut.close();
                        }
                        dMonitor.oos = null;
                        dMonitor.drvOut = null;
                    }
                }
                if (dMonitor.drvIn == null && dMonitor.drvOut == null) {
                    this.driversTable.remove(new Integer(drvKey));
                }
            }
        }
    }

    public void agentFinalize(boolean lastime) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.toString() + " agentFinalize -> " + this.drvCnx));
        }
        this.finalizing = true;
        if (this.multiConn) {
            this.closeAllConnections();
        } else {
            try {
                this.ois.close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                this.oos.close();
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stop();
        this.qout = null;
        this.ois = null;
        this.oos = null;
    }
}

