/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.soap;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.util.Queue;
import java.util.Hashtable;
import org.objectweb.joram.mom.notifications.GetProxyIdNot;
import org.objectweb.joram.mom.proxies.ConnectionManager;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.StandardConnectionContext;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsMessage;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CnxCloseReply;
import org.objectweb.joram.shared.excepts.StateException;
import org.objectweb.util.monolog.api.BasicLevel;

public class SoapProxyService {
    private Hashtable connections;

    public void start(int serverId, String serverName) throws Exception {
        String[] args = new String[]{"" + serverId, serverName};
        AgentServer.init(args);
        AgentServer.start();
        this.connections = new Hashtable();
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"SoapProxyService started.");
        }
    }

    public int setConnection(String userName, String userPassword, int heartBeat) throws Exception {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("SoapProxyService.setConnection(" + userName + ',' + userPassword + ',' + heartBeat + ')'));
        }
        GetProxyIdNot gpin = new GetProxyIdNot(userName, userPassword, null);
        gpin.invoke(new AgentId(AgentServer.getServerId(), AgentServer.getServerId(), AgentId.JoramAdminStamp));
        AgentId proxyId = gpin.getProxyId();
        OpenConnectionNot ocn = new OpenConnectionNot(false, heartBeat);
        ocn.invoke(proxyId);
        StandardConnectionContext cc = (StandardConnectionContext)ocn.getConnectionContext();
        ProxyConnectionContext pcc = new ProxyConnectionContext(proxyId, cc.getQueue());
        this.connections.put(new ConnectionKey(userName, cc.getKey()), pcc);
        return cc.getKey();
    }

    public void send(String name, int cnxId, Hashtable h) throws Exception {
        ProxyConnectionContext ctx;
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("SoapProxyService.send(" + name + ',' + cnxId + ',' + h + ')'));
        }
        AbstractJmsRequest request = (AbstractJmsRequest)AbstractJmsMessage.soapDecode((Hashtable)h);
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("--- " + this + " passes request " + request + " with id " + request.getRequestId() + " to proxy's cnx " + cnxId));
        }
        if ((ctx = (ProxyConnectionContext)this.connections.get(new ConnectionKey(name, cnxId))) == null) {
            throw new StateException("Connection " + name + ':' + cnxId + " closed.");
        }
        ConnectionManager.sendToProxy(ctx.proxyId, cnxId, request, request);
    }

    public Hashtable getReply(String name, int cnxId) throws Exception {
        ConnectionKey ckey = new ConnectionKey(name, cnxId);
        ProxyConnectionContext ctx = (ProxyConnectionContext)this.connections.get(ckey);
        if (ctx == null) {
            throw new StateException("Connection " + name + ':' + cnxId + " closed.");
        }
        Object obj = ctx.replyQueue.get();
        if (obj instanceof Exception) {
            this.connections.remove(ckey);
            throw (Exception)obj;
        }
        AbstractJmsReply reply = (AbstractJmsReply)obj;
        ctx.replyQueue.pop();
        if (reply instanceof CnxCloseReply) {
            this.connections.remove(ckey);
        }
        return reply.soapCode();
    }

    static class ProxyConnectionContext {
        AgentId proxyId;
        Queue replyQueue;

        ProxyConnectionContext(AgentId proxyId, Queue replyQueue) {
            this.proxyId = proxyId;
            this.replyQueue = replyQueue;
        }
    }

    static class ConnectionKey {
        private String userName;
        private int key;

        public ConnectionKey(String userName, int key) {
            this.userName = userName;
            this.key = key;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionKey) {
                ConnectionKey ck = (ConnectionKey)obj;
                return ck.userName.equals(this.userName) && ck.key == this.key;
            }
            return false;
        }
    }
}

