/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.component.event;

import java.util.LinkedList;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.event.CMIEventComponent;
import org.ow2.cmi.event.CMIEventListener;
import org.ow2.cmi.event.CMIManagedObject;
import org.ow2.cmi.rpc.CMIInvocationHandler;
import org.ow2.util.component.api.ComponentException;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.event.impl.EventService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventComponent
implements CMIEventComponent {
    private IEventService service;
    private final LinkedList<IEventListener> listeners = new LinkedList();
    private final LinkedList<CMIManagedObject> objects = new LinkedList();

    public synchronized void setEventService(IEventService service) {
        this.service = service;
    }

    public void init() throws ComponentException {
        if (this.service == null) {
            this.service = new EventService();
            this.service.start();
        }
    }

    public void start() throws ComponentException {
    }

    public void stop() throws ComponentException {
        for (IEventListener listener : this.listeners) {
            this.service.unregisterListener(listener);
        }
        for (CMIManagedObject object : this.objects) {
            this.service.unregisterDispatcher(object.getCMIManagedObjectId());
        }
        this.listeners.clear();
        this.objects.clear();
    }

    public synchronized void registerEventListener(CMIEventListener eventListener) {
        this.service.registerListener((IEventListener)eventListener, eventListener.getEventProviderFilter());
        this.listeners.add((IEventListener)eventListener);
    }

    public synchronized void unregisterEventListener(CMIEventListener eventListener) {
        this.service.unregisterListener((IEventListener)eventListener);
        this.listeners.remove(eventListener);
    }

    public synchronized void registerCMIManagedObject(CMIManagedObject object, IEventDispatcher dispatcher) {
        if (ClusterViewManager.class.isAssignableFrom(object.getClass())) {
            this.registerClusterViewManager((ClusterViewManager)object, dispatcher);
        } else if (CMIInvocationHandler.class.isAssignableFrom(object.getClass())) {
            this.registerCMIInvocationHandler((CMIInvocationHandler)object, dispatcher);
        }
    }

    public synchronized void unregisterCMIManagedObject(CMIManagedObject object) {
        if (ClusterViewManager.class.isAssignableFrom(object.getClass())) {
            this.unregisterClusterViewManager((ClusterViewManager)object);
        } else if (CMIInvocationHandler.class.isAssignableFrom(object.getClass())) {
            this.unregisterCMIInvocationHandler((CMIInvocationHandler)object);
        }
    }

    private void unregisterCMIInvocationHandler(CMIInvocationHandler<?> invocationHandler) {
        this.service.unregisterDispatcher(invocationHandler.getCMIManagedObjectId());
        this.objects.remove(invocationHandler);
    }

    private void unregisterClusterViewManager(ClusterViewManager manager) {
        this.service.unregisterDispatcher(manager.getCMIManagedObjectId());
        this.objects.remove(manager);
    }

    private void registerClusterViewManager(ClusterViewManager clusterViewManager, IEventDispatcher dispatcher) {
        this.service.registerDispatcher(clusterViewManager.getCMIManagedObjectId(), dispatcher);
        this.objects.add((CMIManagedObject)clusterViewManager);
    }

    private void registerCMIInvocationHandler(CMIInvocationHandler<?> invocationHandler, IEventDispatcher dispatcher) {
        this.service.registerDispatcher(invocationHandler.getCMIManagedObjectId(), dispatcher);
        this.objects.add((CMIManagedObject)invocationHandler);
    }
}

