/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.messages;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.util.Transaction;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.excepts.MessageException;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.util.monolog.api.BasicLevel;

public final class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    public transient long order;
    public transient int acksCounter;
    public transient int durableAcksCounter;
    public transient org.objectweb.joram.shared.messages.Message msg;
    transient String txname = null;

    public Message(org.objectweb.joram.shared.messages.Message msg) {
        this.msg = msg;
    }

    public void setIdentifier(String id) {
        this.msg.id = id;
    }

    public void setPersistent(boolean persistent) {
        this.msg.persistent = persistent;
    }

    public void setPriority(int priority) {
        if (priority >= 0 && priority <= 9) {
            this.msg.priority = priority;
        }
    }

    public void setExpiration(long expiration) {
        if (expiration >= 0L) {
            this.msg.expiration = expiration;
        }
    }

    public void setTimestamp(long timestamp) {
        this.msg.timestamp = timestamp;
    }

    public void setCorrelationId(String correlationId) {
        this.msg.correlationId = correlationId;
    }

    public int getType() {
        return this.msg.type;
    }

    public String getIdentifier() {
        return this.msg.id;
    }

    public boolean getPersistent() {
        return this.msg.persistent;
    }

    public int getPriority() {
        return this.msg.priority;
    }

    public long getExpiration() {
        return this.msg.expiration;
    }

    public long getTimestamp() {
        return this.msg.timestamp;
    }

    public final String getCorrelationId() {
        return this.msg.correlationId;
    }

    public void setObjectProperty(String name, Object value) throws MessageException {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        if (!(value instanceof Boolean || value instanceof Number || value instanceof String)) {
            throw new MessageValueException("Can't set non primitive Java object as a property value.");
        }
        this.msg.setProperty(name, value);
    }

    public boolean isValid(long currentTime) {
        if (this.msg.expiration == 0L) {
            return true;
        }
        return this.msg.expiration - currentTime > 0L;
    }

    public void setTxName(String txname) {
        this.txname = txname;
    }

    public String getTxName() {
        return this.txname;
    }

    public static Message load(String txname) throws IOException, ClassNotFoundException {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("Message.load:" + txname));
        }
        Message msg = (Message)AgentServer.getTransaction().load(txname);
        msg.txname = txname;
        return msg;
    }

    public void save() {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("Message.save:" + this.txname));
        }
        if (!this.getPersistent()) {
            return;
        }
        try {
            AgentServer.getTransaction().save((Serializable)this, this.txname);
        }
        catch (IOException exc) {
            JoramTracing.dbgMessage.log(BasicLevel.ERROR, (Object)("Message named [" + this.txname + "] could not be saved"), (Throwable)exc);
        }
    }

    public void delete() {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("Message.delete:" + this.txname));
        }
        if (!this.getPersistent()) {
            return;
        }
        AgentServer.getTransaction().delete(this.txname);
    }

    public static Vector loadAll(String msgTxname) {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("MessagePersistenceModule.loadAll() " + msgTxname));
        }
        Vector<Message> messages = new Vector<Message>();
        Transaction tx = AgentServer.getTransaction();
        String[] names = tx.getList(msgTxname);
        for (int i = 0; i < names.length; ++i) {
            try {
                Message msg = (Message)tx.load(names[i]);
                msg.txname = names[i];
                if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("loadAll: names[" + i + "] = " + msg));
                }
                messages.add(msg);
                continue;
            }
            catch (Exception exc) {
                JoramTracing.dbgMessage.log(BasicLevel.ERROR, (Object)("Message named [" + names[i] + "] could not be loaded"), (Throwable)exc);
            }
        }
        return messages;
    }

    public static void deleteAll(String msgTxname) {
        if (JoramTracing.dbgMessage.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgMessage.log(BasicLevel.DEBUG, (Object)("MessagePersistenceModule.deleteAll() " + msgTxname));
        }
        Transaction tx = AgentServer.getTransaction();
        String[] names = tx.getList(msgTxname);
        for (int i = 0; i < names.length; ++i) {
            tx.delete(names[i]);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.order);
        this.msg.writeTo((OutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.order = in.readLong();
        this.acksCounter = 0;
        this.durableAcksCounter = 0;
        this.msg = new org.objectweb.joram.shared.messages.Message();
        this.msg.readFrom((InputStream)in);
    }
}

