/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.xmlconfig;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.mapping.AttributeMapping;
import org.ow2.util.xmlconfig.mapping.ClassMapping;
import org.ow2.util.xmlconfig.mapping.XMLMapping;
import org.ow2.util.xmlconfig.mapping.XMLMappingBuilder;
import org.ow2.util.xmlconfig.properties.IPropertyResolver;
import org.ow2.util.xmlconfig.properties.PropertyResolverHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration {
    private static final String HTTP_NAMESPACE = "http://";
    private static final boolean VALIDATING_OFF = false;
    private final String mappingFilename;
    private static final String MAPPING_SUFFIX = "-mapping.xml";
    private static final int MIN_PROPERTY_LENGTH = 4;
    private Log logger = LogFactory.getLog(XMLConfiguration.class);
    private boolean validating = false;
    private URL xmlConfigurationURL;
    private InputStream xmlConfigurationStream;
    private Map<String, XMLMapping> mappings = new HashMap<String, XMLMapping>();
    private HashMap<String, Object> configuredElements = new HashMap();
    private IPropertyResolver propertyResolver = null;

    @Deprecated
    public XMLConfiguration(URL xmlConfigurationURL, String mappingNS, String mappingFilename) {
        this(xmlConfigurationURL, mappingFilename);
    }

    public XMLConfiguration(URL xmlConfigurationURL, String mappingFilename) {
        this(mappingFilename);
        this.xmlConfigurationURL = xmlConfigurationURL;
    }

    public XMLConfiguration(InputStream stream, String mappingFilename) {
        this(mappingFilename);
        this.xmlConfigurationStream = stream;
    }

    private XMLConfiguration(String mappingFilename) {
        this.mappingFilename = mappingFilename;
    }

    public void configure(Object object) throws XMLConfigurationException {
        Element rootElement = this.analyzeXmlFile();
        this.setAttributesOfRootElement(object, rootElement);
        this.configure(object, rootElement, null);
    }

    private void setAttributesOfRootElement(Object object, Element element) throws XMLConfigurationException {
        ClassMapping classMapping;
        try {
            classMapping = this.getClassMapping(element.getNamespaceURI(), element.getLocalName());
        }
        catch (XMLConfigurationException e) {
            this.logger.debug("No mapping for the root element.", new Object[0]);
            return;
        }
        this.setAttributes(element, object, classMapping);
    }

    private Element analyzeXmlFile() throws XMLConfigurationException {
        Document xmlConfigurationDocument = null;
        try {
            xmlConfigurationDocument = this.xmlConfigurationStream != null ? DocumentParser.getDocument((InputStream)this.xmlConfigurationStream, (boolean)this.validating, null) : DocumentParser.getDocument((URL)this.xmlConfigurationURL, (boolean)this.validating, null);
        }
        catch (DocumentParserException e) {
            throw new XMLConfigurationException("Cannot get a document on the given url '" + this.xmlConfigurationURL + "'.", e);
        }
        Element rootElement = xmlConfigurationDocument.getDocumentElement();
        String nameSpace = rootElement.getNamespaceURI();
        this.getXMLMapping(nameSpace, rootElement.getLocalName());
        return rootElement;
    }

    public boolean isElementMapping(String name, ClassMapping classMapping) {
        AttributeMapping attributeMapping = classMapping.getAttributeMapping(name);
        if (attributeMapping != null) {
            return attributeMapping.isElement();
        }
        return false;
    }

    public boolean isListElement(String name, ClassMapping classMapping) {
        AttributeMapping attributeMapping = classMapping.getAttributeMapping(name);
        if (attributeMapping != null) {
            return attributeMapping.isListElement();
        }
        return false;
    }

    public void configure(Object object, Element element, ClassMapping parentClassMapping) throws XMLConfigurationException {
        NodeList nodeList = element.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            if (parentClassMapping != null && this.isElementMapping(node.getLocalName(), parentClassMapping)) {
                Node txtNode = node.getFirstChild();
                String val = null;
                if (txtNode != null) {
                    val = txtNode.getNodeValue();
                }
                if (val == null) continue;
                val = val.trim();
                if (!this.isListElement(node.getLocalName(), parentClassMapping)) {
                    this.setAttribute(object, node.getLocalName(), val, parentClassMapping);
                    continue;
                }
                this.addSetElement(object, val, node.getLocalName(), parentClassMapping);
                continue;
            }
            ClassMapping classMapping = this.getClassMapping(node.getNamespaceURI(), node.getLocalName());
            Object newObject = this.newInstance(node, classMapping, object.getClass().getClassLoader());
            Method getterMethod = this.findSingleGetterMethod(object, newObject);
            if (getterMethod != null) {
                this.logger.debug("Calling method {0} on object {1}", getterMethod, object);
                Object getterObject = null;
                try {
                    getterObject = getterMethod.invoke(object, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new XMLConfigurationException("Cannot call method '" + getterMethod + "' on object '" + object + "'.", e);
                }
                catch (IllegalAccessException e) {
                    throw new XMLConfigurationException("Cannot call method '" + getterMethod + "' on object '" + object + "'.", e);
                }
                catch (InvocationTargetException e) {
                    throw new XMLConfigurationException("Cannot call method '" + getterMethod + "' on object '" + object + "'.", e);
                }
                if (getterObject != null) {
                    newObject = getterObject;
                }
            }
            this.setAttributes((Element)node, newObject, classMapping);
            this.addSetElement(object, newObject, node.getLocalName(), classMapping);
            this.configuredElements.put(node.getLocalName(), newObject);
            this.configure(newObject, (Element)node, classMapping);
        }
    }

    protected void setAttributes(Element node, Object object, ClassMapping classMapping) throws XMLConfigurationException {
        NamedNodeMap attributes = node.getAttributes();
        int attributesLength = attributes.getLength();
        for (int a = 0; a < attributesLength; ++a) {
            Node nodeAttribute = attributes.item(a);
            if (nodeAttribute.getNamespaceURI() != null) continue;
            String propertyName = nodeAttribute.getLocalName();
            String propertyValue = nodeAttribute.getNodeValue();
            this.setAttribute(object, propertyName, propertyValue, classMapping);
        }
        String elementAttribute = classMapping.getElementAttribute();
        if (elementAttribute != null) {
            Node txtNode = node.getFirstChild();
            String val = null;
            if (txtNode != null) {
                val = txtNode.getNodeValue();
            }
            this.setAttribute(object, elementAttribute, val, classMapping);
        }
    }

    private ClassMapping getClassMapping(String nameSpaceURI, String name) throws XMLConfigurationException {
        XMLMapping xmlMapping = this.mappings.get(nameSpaceURI);
        if (xmlMapping == null && (xmlMapping = this.getXMLMapping(nameSpaceURI, name)) == null) {
            throw new XMLConfigurationException("No mapping found for namespace '" + nameSpaceURI + "'.");
        }
        ClassMapping classMapping = xmlMapping.getClassMapping(name);
        if (classMapping == null) {
            throw new XMLConfigurationException("No class found for element '" + name + "' withing xmlmapping '" + xmlMapping + "'.");
        }
        return classMapping;
    }

    private Object newInstance(Node node, ClassMapping classMapping, ClassLoader objectClassLoader) throws XMLConfigurationException {
        Class<?> clazz;
        String className = classMapping.getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            clazz = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = objectClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e1) {
                throw new XMLConfigurationException("Cannot load the class '" + className + "'.", e);
            }
        }
        this.logger.debug("Building instance of the class {0}", className);
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new XMLConfigurationException("Cannot build an instance of class '" + className + "' using classloader '" + classLoader + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new XMLConfigurationException("Cannot build an instance of class '" + className + "' using classloader '" + classLoader + "'.", e);
        }
        catch (NoClassDefFoundError e) {
            throw new XMLConfigurationException("Cannot build an instance of class '" + className + "' using classloader '" + classLoader + "'.", e);
        }
    }

    private void setAttribute(Object configuringObject, String propertyName, String propertyValue, ClassMapping classMapping) throws XMLConfigurationException {
        String name;
        Class<?> configuringClass = configuringObject.getClass();
        Method[] methods = configuringClass.getMethods();
        String updatedPropertyName = propertyName;
        AttributeMapping attributeMapping = classMapping.getAttributeMapping(propertyName);
        if (attributeMapping != null && (name = attributeMapping.getName()) != null) {
            updatedPropertyName = name;
        }
        String setterName = "set" + updatedPropertyName.substring(0, 1).toUpperCase() + updatedPropertyName.substring(1);
        Object paramObject = null;
        Method foundMethod = null;
        if (methods != null) {
            for (Method m : methods) {
                Class<?>[] parameters;
                if (!m.getName().equals(setterName) || (parameters = m.getParameterTypes()).length != 1) continue;
                foundMethod = m;
                Class<?> parameterClass = parameters[0];
                if (propertyValue.startsWith("#") && propertyValue.length() >= 2) {
                    paramObject = this.configuredElements.get(propertyValue.substring(1));
                    break;
                }
                if (propertyValue.contains("${") && propertyValue.length() >= 4 && this.propertyResolver != null) {
                    try {
                        paramObject = PropertyResolverHelper.resolve(this.propertyResolver, propertyValue);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error("Cannot resolve the property {1}", propertyValue, e);
                    }
                    break;
                }
                if (String.class.equals(parameterClass)) {
                    paramObject = propertyValue;
                    break;
                }
                if (Integer.TYPE.equals(parameterClass)) {
                    paramObject = new Integer(propertyValue);
                    break;
                }
                if (Long.TYPE.equals(parameterClass)) {
                    paramObject = new Long(propertyValue);
                    break;
                }
                if (!Boolean.TYPE.equals(parameterClass)) break;
                paramObject = Boolean.valueOf(propertyValue);
                break;
            }
        }
        if (foundMethod != null && paramObject != null) {
            this.logger.debug("Calling {0} on object {1} with value {2}", setterName, configuringObject, paramObject);
            try {
                foundMethod.invoke(configuringObject, paramObject);
            }
            catch (IllegalArgumentException e) {
                throw new XMLConfigurationException("Cannot call method '" + foundMethod + "' on object '" + configuringObject + "' with parameter '" + paramObject + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new XMLConfigurationException("Cannot call method '" + foundMethod + "' on object '" + configuringObject + "' with parameter '" + paramObject + "'.", e);
            }
            catch (InvocationTargetException e) {
                throw new XMLConfigurationException("Cannot call method '" + foundMethod + "' on object '" + configuringObject + "' with parameter '" + paramObject + "'.", e);
            }
        } else {
            throw new XMLConfigurationException("No setter method found for parameter '" + propertyName + "' on class '" + configuringClass + "'.");
        }
    }

    private Method findSingleSetterMethod(Object configuringObject, Object paramObject, String attributeName) {
        Method setterMethod = null;
        Class<?> configuringClass = configuringObject.getClass();
        Method[] methods = configuringClass.getMethods();
        Class<?> parameterClass = paramObject.getClass();
        String className = parameterClass.getSimpleName();
        if (methods != null) {
            for (Method m : methods) {
                Class<?>[] parameters;
                if (!m.getName().startsWith("set" + className) && !m.getName().startsWith("add" + className) && !m.getName().equalsIgnoreCase("set" + attributeName) || (parameters = m.getParameterTypes()).length != 1 || !parameters[0].equals(parameterClass) && !parameters[0].isAssignableFrom(parameterClass)) continue;
                setterMethod = m;
                break;
            }
        }
        return setterMethod;
    }

    private Method findSingleGetterMethod(Object configuringObject, Object paramObject) {
        Method getterMethod = null;
        Class<?> configuringClass = configuringObject.getClass();
        Method[] methods = configuringClass.getMethods();
        Class<?> parameterClass = paramObject.getClass();
        String className = parameterClass.getSimpleName();
        if (methods != null) {
            for (Method m : methods) {
                Class<?> returnType;
                Class<?>[] parameters;
                if (!m.getName().startsWith("get" + className) || (parameters = m.getParameterTypes()).length != 0 || (returnType = m.getReturnType()) == null || !returnType.equals(paramObject.getClass())) continue;
                getterMethod = m;
                break;
            }
        }
        return getterMethod;
    }

    private Method[] findListGetterSetterMethod(Object configuringObject, Object paramObject, String getter, String setter) {
        Class<?> configuringClass = configuringObject.getClass();
        Method[] methods = configuringClass.getMethods();
        Class<?> parameterClass = paramObject.getClass();
        String className = parameterClass.getSimpleName();
        String argName = null;
        argName = className.endsWith("y") ? className.substring(0, className.length() - 1) + "ies" : (className.endsWith("ss") ? className + "es" : className + "s");
        Method[] searchMethods = this.searchListGetterSetterMethod(methods, argName, parameterClass, getter, setter);
        return searchMethods;
    }

    private Method[] searchListGetterSetterMethod(Method[] methods, String argName, Class<?> parameterClass, String getter, String setter) {
        Class<?>[] interfaces;
        Method[] returnedMethods = null;
        Method getterMethod = null;
        Method setterMethod = null;
        if (methods != null) {
            for (Method m : methods) {
                ParameterizedType parameterizedType;
                Type[] typeArguments;
                Type type;
                Class<?>[] parameters;
                Class<?> returnTypeClass;
                if (m.getName().startsWith("set" + argName) || m.getName().equals(setter)) {
                    ParameterizedType parameterizedType2;
                    Type[] typeArguments2;
                    Type[] types;
                    Class<?>[] parameters2 = m.getParameterTypes();
                    if (parameters2.length != 1 || !parameters2[0].equals(List.class) || (types = m.getGenericParameterTypes()).length != 1 || !(types[0] instanceof ParameterizedType) || (typeArguments2 = (parameterizedType2 = (ParameterizedType)types[0]).getActualTypeArguments()).length != 1 || !typeArguments2[0].equals(parameterClass)) continue;
                    setterMethod = m;
                    continue;
                }
                if (!m.getName().startsWith("get" + argName) && !m.getName().equals(getter) || (returnTypeClass = m.getReturnType()) == null || !returnTypeClass.equals(List.class) || (parameters = m.getParameterTypes()).length != 0 || !((type = m.getGenericReturnType()) instanceof ParameterizedType) || (typeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length != 1 || !typeArguments[0].equals(parameterClass)) continue;
                getterMethod = m;
            }
        }
        if ((interfaces = parameterClass.getInterfaces()) != null) {
            Class<?> itf;
            String itfName;
            String argItfName;
            Class<?>[] arr$ = interfaces;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (returnedMethods = this.searchListGetterSetterMethod(methods, argItfName = (itfName = (itf = arr$[i$]).getSimpleName()) + "s", itf, getter, setter)) == null; ++i$) {
            }
        }
        if (getterMethod != null && setterMethod != null) {
            returnedMethods = new Method[]{getterMethod, setterMethod};
        }
        return returnedMethods;
    }

    private void addSetElement(Object configuringObject, Object newObject, String attributeName, ClassMapping classMapping) throws XMLConfigurationException {
        String getter = null;
        String setter = null;
        boolean isListAttribute = false;
        AttributeMapping attributeMapping = classMapping.getAttributeMapping(attributeName);
        if (attributeMapping != null) {
            getter = attributeMapping.getGetter();
            setter = attributeMapping.getSetter();
            isListAttribute = attributeMapping.isListElement();
        }
        Method foundMethod = null;
        if (!isListAttribute) {
            foundMethod = this.findSingleSetterMethod(configuringObject, newObject, attributeName);
        }
        if (foundMethod != null) {
            this.logger.debug("Calling method {0} on object {1} with value {2}", foundMethod, configuringObject, newObject);
            try {
                foundMethod.invoke(configuringObject, newObject);
            }
            catch (IllegalArgumentException e) {
                throw new XMLConfigurationException("Unable to invoke the method '" + foundMethod + "' on '" + configuringObject + "' with arg '" + newObject + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new XMLConfigurationException("Unable to invoke the method '" + foundMethod + "' on '" + configuringObject + "' with arg '" + newObject + "'.", e);
            }
            catch (InvocationTargetException e) {
                throw new XMLConfigurationException("Unable to invoke the method '" + foundMethod + "' on '" + configuringObject + "' with arg '" + newObject + "'.", e);
            }
        }
        Method[] getterAndSetter = this.findListGetterSetterMethod(configuringObject, newObject, getter, setter);
        if (getterAndSetter != null) {
            Method getterMethod = getterAndSetter[0];
            Method setterMethod = getterAndSetter[1];
            ArrayList<Object> currentList = null;
            try {
                this.logger.debug("Calling method {0} on object {1}", getterMethod, configuringObject);
                currentList = (ArrayList<Object>)getterMethod.invoke(configuringObject, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new XMLConfigurationException("Unable to invoke the method '" + getterMethod + "' on '" + configuringObject + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new XMLConfigurationException("Unable to invoke the method '" + getterMethod + "' on '" + configuringObject + "'.", e);
            }
            catch (InvocationTargetException e) {
                throw new XMLConfigurationException("Unable to invoke the method '" + getterMethod + "' on '" + configuringObject + "'.", e);
            }
            if (currentList == null) {
                currentList = new ArrayList<Object>();
            }
            this.logger.debug("Adding element  {0} to the list {1}", newObject, currentList);
            currentList.add(newObject);
            try {
                this.logger.debug("Calling method {0} on object {1} with value {2}", setterMethod, configuringObject, currentList);
                setterMethod.invoke(configuringObject, currentList);
            }
            catch (IllegalArgumentException e) {
                throw new XMLConfigurationException("Unable to invoke the method '" + setterMethod + "' on '" + configuringObject + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new XMLConfigurationException("Unable to invoke the method '" + setterMethod + "' on '" + configuringObject + "'.", e);
            }
            catch (InvocationTargetException e) {
                throw new XMLConfigurationException("Unable to invoke the method '" + setterMethod + "' on '" + configuringObject + "'.", e);
            }
        }
        throw new XMLConfigurationException("No setter method found for parameter '" + newObject.getClass() + "' on class '" + configuringObject.getClass() + "'.");
    }

    private XMLMapping getXMLMapping(String nameSpace, String optionalName) throws XMLConfigurationException {
        if (nameSpace == null || "".equals(nameSpace)) {
            throw new XMLConfigurationException("Empty default namespace not supported.");
        }
        if (this.mappings.containsKey(nameSpace)) {
            return this.mappings.get(nameSpace);
        }
        XMLMapping xmlMapping = null;
        if (nameSpace != null) {
            if (nameSpace.startsWith(HTTP_NAMESPACE)) {
                String packageName = nameSpace.substring(HTTP_NAMESPACE.length());
                String resourceName = packageName.replaceAll("\\.", "/") + "/" + this.mappingFilename;
                URL mappingURL = Thread.currentThread().getContextClassLoader().getResource(resourceName);
                if (mappingURL == null && optionalName != null) {
                    resourceName = packageName.replaceAll("\\.", "/") + "/" + optionalName + MAPPING_SUFFIX;
                    mappingURL = Thread.currentThread().getContextClassLoader().getResource(resourceName);
                }
                if (mappingURL != null) {
                    xmlMapping = this.createXMLMapping(mappingURL);
                }
            } else {
                this.logger.warn("Namespace found ''{0}}'' but this is not an HTTP namespace", nameSpace);
            }
        }
        this.mappings.put(nameSpace, xmlMapping);
        return xmlMapping;
    }

    private XMLMapping createXMLMapping(URL mappingURL) throws XMLConfigurationException {
        XMLMappingBuilder xmlMappingBuilder = new XMLMappingBuilder(mappingURL);
        xmlMappingBuilder.build();
        return xmlMappingBuilder.getXmlMapping();
    }

    public IPropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public void setPropertyResolver(IPropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }
}

