/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.factory;

import java.lang.reflect.Constructor;
import java.util.List;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.config.CMIConfigException;
import org.ow2.cmi.config.CMIConfigurator;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.common.IConfig;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactoryException;
import org.ow2.cmi.controller.factory.server.ClusterViewManagerFactoryConfig;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusterViewManagerFactory {
    private static Log logger = LogFactory.getLog(ClusterViewManagerFactory.class);
    private static String clientClusterViewManagerClassname = "org.ow2.cmi.controller.client.ClientClusterViewManagerImpl";
    private static ClusterViewManagerFactory factory;
    private org.ow2.cmi.controller.factory.ClusterViewManagerFactoryConfig<?> factoryConfig;
    private ClusterViewManager clusterViewManager;

    private ClusterViewManagerFactory() {
    }

    public static ClusterViewManagerFactory getFactory() {
        if (factory == null) {
            factory = new ClusterViewManagerFactory();
        }
        return factory;
    }

    public ClusterViewManager getClusterViewManager() {
        return this.clusterViewManager;
    }

    public ClusterViewManager create() throws ClusterViewManagerFactoryException {
        if (this.clusterViewManager == null) {
            List<ServerRef> serverRefs;
            if (this.factoryConfig == null) {
                logger.error((Object)"No configuration", new Object[0]);
                throw new ClusterViewManagerFactoryException("No configuration");
            }
            if (this.factoryConfig instanceof ClusterViewManagerFactoryConfig) {
                Class<?> serverClusterViewManagerClass;
                String classname = ((ClusterViewManagerFactoryConfig)this.factoryConfig).getServerClusterViewManagerClassname();
                try {
                    serverClusterViewManagerClass = CMIConfig.class.getClassLoader().loadClass(classname);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)"Cannot load the class implementing a server-side manager.", new Object[0]);
                    throw new ClusterViewManagerFactoryException("Cannot load the class implementing a server-side manager.", e);
                }
                logger.debug((Object)"The ServerClusterViewManager is: {0}", new Object[]{serverClusterViewManagerClass.getName()});
                try {
                    this.clusterViewManager = (ClusterViewManager)serverClusterViewManagerClass.newInstance();
                }
                catch (Exception e) {
                    logger.error((Object)"Cannot create the instance (singleton) of ServerClusterViewManager", new Object[]{e});
                    throw new ClusterViewManagerFactoryException("Cannot get an instance of ServerClusterViewManager", e);
                }
            }
            logger.debug((Object)"Constructing a ClientClusterviewManager...", new Object[0]);
            String protocol = ((org.ow2.cmi.controller.factory.client.ClusterViewManagerFactoryConfig)this.factoryConfig).getProtocol();
            String initialContextFactoryName = ((org.ow2.cmi.controller.factory.client.ClusterViewManagerFactoryConfig)this.factoryConfig).getInitialContextFactoryName();
            List<String> clusterViewProviderUrls = ((org.ow2.cmi.controller.factory.client.ClusterViewManagerFactoryConfig)this.factoryConfig).getClusterViewProviderUrls();
            try {
                serverRefs = CMIConfigurator.extractServerRefs(protocol, clusterViewProviderUrls);
            }
            catch (CMIConfigException e) {
                logger.error((Object)("Unable to extract some server refs from the provider URL " + clusterViewProviderUrls), new Object[]{e});
                throw new ClusterViewManagerFactoryException("Unable to extract some server refs from the provider URL " + clusterViewProviderUrls, e);
            }
            try {
                Class<?> clientClusterViewManagerClass = this.getClass().getClassLoader().loadClass(clientClusterViewManagerClassname);
                Constructor<?> constructor = clientClusterViewManagerClass.getConstructor(String.class, String.class, List.class);
                this.clusterViewManager = (ClusterViewManager)constructor.newInstance(initialContextFactoryName, protocol, serverRefs);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to create a client cluster view manager for the class " + clientClusterViewManagerClassname), new Object[]{e});
                throw new ClusterViewManagerFactoryException("Unable to create a client cluster view manager for the class " + clientClusterViewManagerClassname, e);
            }
        }
        return this.clusterViewManager;
    }

    public IConfig getConfig() {
        return this.factoryConfig.getConfig();
    }

    public void destroy() {
        if (this.clusterViewManager != null) {
            this.clusterViewManager.destroy();
            this.clusterViewManager = null;
        }
    }

    public boolean isDestroyed() {
        return this.clusterViewManager == null;
    }

    public void configure(org.ow2.cmi.controller.factory.ClusterViewManagerFactoryConfig<?> clusterViewManagerFactoryConfig) {
        if (this.factoryConfig == null) {
            this.factoryConfig = clusterViewManagerFactoryConfig;
        }
    }
}

