/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.pool;

import javax.naming.NamingException;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.server.ProtocolNotFoundException;
import org.ow2.cmi.pool.NamingPoolException;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.CMIReferenceableWrapper;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.rpc.StubOrProxyHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.PoolEntryStatistics;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class StubOrProxyFactory
implements PoolFactory<CMIReferenceable<?>, CMIReference> {
    private static final Log LOGGER = LogFactory.getLog(StubOrProxyFactory.class);
    private final ClusterViewManager clusterViewManager;

    public StubOrProxyFactory(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    public CMIReferenceable<?> create(CMIReference cmiReference) throws PoolException {
        try {
            return StubOrProxyHelper.download(this.clusterViewManager, cmiReference);
        }
        catch (ProtocolNotFoundException e) {
            LOGGER.error((Object)("Cannot get a CMIReferenceable for " + cmiReference), new Object[]{e});
            throw new PoolException("Cannot get a CMIReferenceable for " + cmiReference, (Throwable)e);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)("Cannot get a CMIReferenceable for " + cmiReference), new Object[]{e});
            throw new PoolException("Cannot get a CMIReferenceable for " + cmiReference, (Throwable)e);
        }
        catch (NamingException e) {
            LOGGER.debug((Object)("No CMIReferenceable is bound for " + cmiReference), new Object[]{e});
            throw new NamingPoolException("No CMIReferenceable is bound for " + cmiReference, (Throwable)e);
        }
    }

    public boolean isMatching(CMIReferenceable<?> cmiReferenceable, CMIReference cmiReference) {
        LOGGER.debug((Object)"{0} == {1} ?", new Object[]{cmiReferenceable.getReference(), cmiReference});
        return cmiReferenceable.getReference().equals((Object)cmiReference);
    }

    public void remove(CMIReferenceable<?> cmiReferenceable) {
    }

    public boolean validate(CMIReferenceable<?> cmiReferenceable, PoolEntryStatistics stats) {
        return true;
    }

    public void setClue(CMIReferenceable<?> cmiReferenceable, CMIReference cmiRef) throws PoolException {
        if (!(cmiReferenceable instanceof CMIReferenceableWrapper)) {
            throw new PoolException("Cannot set the given clue on the instance");
        }
        ((CMIReferenceableWrapper)cmiReferenceable).setReference(cmiRef);
    }
}

