/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManagerException;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.lb.PropertyConfigurationException;
import org.ow2.cmi.lb.data.PropertyData;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.lb.util.PolicyFactoryException;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class PolicyFactory<T extends LoadBalanceable> {
    private static final Log LOGGER = LogFactory.getLog(PolicyFactory.class);
    private final ClusterViewManager clusterViewManager;
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, PropertyData>> policyClassName2PropertyData = new ConcurrentHashMap();

    public PolicyFactory(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    public IPolicy<T> getPolicy(String objectName) throws PolicyFactoryException, ObjectNotFoundException {
        Class strategyClass;
        Class policyClass;
        try {
            policyClass = this.clusterViewManager.getPolicyClass(objectName);
        }
        catch (ClusterViewManagerException e) {
            LOGGER.error((Object)"Error while finding the policy class", new Object[]{e});
            throw new PolicyFactoryException("Error while finding the policy class", e);
        }
        Map properties = this.clusterViewManager.getPropertiesForPolicy(objectName);
        try {
            strategyClass = this.clusterViewManager.getStrategyClass(objectName);
        }
        catch (ClusterViewManagerException e) {
            LOGGER.error((Object)"Error while finding the strategy class", new Object[]{e});
            throw new PolicyFactoryException("Error while finding the strategy class", e);
        }
        return this.getPolicy(policyClass, strategyClass, properties);
    }

    public IPolicy<T> getPolicy(Class<? extends IPolicy> policyClass, Class<? extends IStrategy> strategyClass, Map<String, ?> properties) throws PolicyFactoryException {
        IPolicy<T> policy = this.createPolicy(policyClass);
        try {
            PolicyFactory.findProperties(policy.getClass());
        }
        catch (PropertyConfigurationException e) {
            LOGGER.error((Object)"Error while finding properties", new Object[]{e});
            throw new PolicyFactoryException("Error while finding properties", e);
        }
        if (properties != null) {
            try {
                this.setProperties(policy, properties);
            }
            catch (PropertyConfigurationException e) {
                LOGGER.error((Object)"Error while configuring the properties", new Object[]{e});
                throw new PolicyFactoryException("Error while configuring the properties", e);
            }
        }
        IStrategy<T> strategy = this.createStrategy(strategyClass);
        policy.setStrategy(strategy);
        return policy;
    }

    private static void findProperties(Class<? extends IPolicy> policyClass) throws PropertyConfigurationException {
        String policyClassname = policyClass.getName();
        if (policyClassName2PropertyData.containsKey(policyClassname)) {
            return;
        }
        ConcurrentHashMap<String, PropertyData> properties = new ConcurrentHashMap<String, PropertyData>();
        for (Method method : policyClass.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || methodName.equals("getStrategy")) continue;
            PropertyData propertyData = new PropertyData(method, policyClass);
            properties.putIfAbsent(propertyData.getPropertyName(), propertyData);
        }
        policyClassName2PropertyData.putIfAbsent(policyClassname, properties);
    }

    public IPolicy<T> createPolicy(Class<? extends IPolicy> policyClass) throws PolicyFactoryException {
        Constructor<?>[] constructors;
        IPolicy policy = null;
        for (Constructor<?> constructor : constructors = policyClass.getDeclaredConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length != 1 || !paramTypes[0].equals(ClusterViewManager.class)) continue;
            try {
                policy = (IPolicy)constructor.newInstance(this.clusterViewManager);
                break;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot construct the policy with the instance of ClusterViewManager", new Object[]{e});
                throw new PolicyFactoryException("Cannot construct the policy with the instance of ClusterViewManager", e);
            }
        }
        if (policy == null) {
            try {
                policy = policyClass.newInstance();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot construct the LB policy", new Object[]{e});
                throw new PolicyFactoryException("Cannot construct the LB policy", e);
            }
        }
        try {
            Method setter = policyClass.getMethod("setClusterViewManager", ClusterViewManager.class);
            setter.invoke((Object)policy, this.clusterViewManager);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot set the manager of cluster view", new Object[]{e});
        }
        return policy;
    }

    private void setProperties(IPolicy<T> policy, Map<String, ?> properties) throws PropertyConfigurationException {
        for (Map.Entry<String, ?> propertyEntry : properties.entrySet()) {
            this.setProperty(policy, propertyEntry.getKey(), propertyEntry.getValue());
        }
    }

    private void setProperty(IPolicy<T> policy, String propertyName, Object propertyValue) throws PropertyConfigurationException {
        Class<?> policyClass = policy.getClass();
        PropertyData propertyData = policyClassName2PropertyData.get(policyClass.getName()).get(propertyName);
        try {
            propertyData.getSetter().invoke(policy, propertyValue);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot set the property for name {0} with {1}", new Object[]{propertyName, propertyValue, e});
            throw new PropertyConfigurationException("Cannot set the property for name " + propertyName + " with " + propertyValue, (Throwable)e);
        }
    }

    private IStrategy<T> createStrategy(Class<? extends IStrategy> strategyClass) throws PolicyFactoryException {
        Constructor<?>[] constructors;
        IStrategy strategy = null;
        for (Constructor<?> constructor : constructors = strategyClass.getDeclaredConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length != 1 || !paramTypes[0].equals(ClusterViewManager.class)) continue;
            try {
                strategy = (IStrategy)constructor.newInstance(this.clusterViewManager);
                break;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot construct the strategy with the instance of ClusterViewManager", new Object[]{e});
                throw new PolicyFactoryException("Cannot construct the strategy with the instance of ClusterViewManager", e);
            }
        }
        if (strategy == null) {
            try {
                strategy = strategyClass.newInstance();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot construct the strategy with the default constructor", new Object[]{e});
                throw new PolicyFactoryException("Cannot construct the strategy with the default constructor", e);
            }
        }
        return strategy;
    }

    public static Map<String, Object> getProperties(IPolicy<?> policy) throws PropertyConfigurationException {
        Class<?> policyClass = policy.getClass();
        PolicyFactory.findProperties(policyClass);
        Map propertyData = policyClassName2PropertyData.get(policyClass.getName());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String propertyName : propertyData.keySet()) {
            Object propertyValue = PolicyFactory.getProperty(policy, propertyName);
            properties.put(propertyName, propertyValue);
        }
        return properties;
    }

    public static Object getProperty(IPolicy<?> policy, String propertyName) throws PropertyConfigurationException {
        Class<?> policyClass = policy.getClass();
        PolicyFactory.findProperties(policyClass);
        Map propertyData = policyClassName2PropertyData.get(policyClass.getName());
        PropertyData property = (PropertyData)propertyData.get(propertyName);
        try {
            return property.getGetter().invoke(policy, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot invoke the getter for property {0}", new Object[]{propertyName, e});
            return null;
        }
    }

    public static Type getPropertyRawType(Class<? extends IPolicy> policyClass, String propertyName) throws PropertyConfigurationException {
        Type propertyType = PolicyFactory.getPropertyType(policyClass, propertyName);
        if (propertyType instanceof ParameterizedType) {
            return ((ParameterizedType)propertyType).getRawType();
        }
        return propertyType;
    }

    public static Type getPropertyType(Class<? extends IPolicy> policyClass, String propertyName) throws PropertyConfigurationException {
        PolicyFactory.findProperties(policyClass);
        return policyClassName2PropertyData.get(policyClass.getName()).get(propertyName).getPropertyType();
    }

    public static Map<String, PropertyData> getPropertyData(Class<? extends IPolicy> policyClass) throws PropertyConfigurationException {
        PolicyFactory.findProperties(policyClass);
        return policyClassName2PropertyData.get(policyClass.getName());
    }

    public static Object convertString(Class<? extends IPolicy> policyClass, String propertyName, String svalue) throws PropertyConfigurationException {
        Type propertyType = PolicyFactory.getPropertyType(policyClass, propertyName);
        return PolicyFactory.convertString(propertyType, svalue);
    }

    public static Object convertString(Type propertyType, String svalue) throws PropertyConfigurationException {
        Class<?> propertyValue;
        Type type = propertyType instanceof ParameterizedType ? ((ParameterizedType)propertyType).getRawType() : propertyType;
        Class klass = (Class)type;
        if (klass.equals(String.class)) {
            propertyValue = svalue;
        } else if (klass.equals(Boolean.TYPE) || klass.equals(Boolean.class)) {
            propertyValue = Boolean.valueOf(svalue);
        } else if (klass.equals(Byte.TYPE) || klass.equals(Byte.class)) {
            propertyValue = Byte.valueOf(svalue);
        } else if (klass.equals(Integer.TYPE) || klass.equals(Integer.class)) {
            propertyValue = Integer.valueOf(svalue);
        } else if (klass.equals(Long.TYPE) || klass.equals(Long.class)) {
            propertyValue = Long.valueOf(svalue);
        } else if (klass.equals(Float.TYPE) || klass.equals(Float.class)) {
            propertyValue = Float.valueOf(svalue);
        } else if (klass.equals(Double.TYPE) || klass.equals(Double.class)) {
            propertyValue = Double.valueOf(svalue);
        } else if (klass.equals(URL.class)) {
            try {
                propertyValue = new URL(svalue);
            }
            catch (MalformedURLException e) {
                throw new PropertyConfigurationException("Cannot convert the string " + svalue + " to an URL", (Throwable)e);
            }
        } else if (klass.equals(File.class)) {
            propertyValue = new File(svalue);
        } else if (klass.equals(Class.class)) {
            try {
                propertyValue = Class.forName(svalue);
            }
            catch (ClassNotFoundException e) {
                throw new PropertyConfigurationException("Cannot convert the string " + svalue + " to a class", (Throwable)e);
            }
        } else {
            LOGGER.error((Object)"Type of field not supported: {0}", new Object[]{klass.getName()});
            throw new PropertyConfigurationException("Type of field not supported: " + klass.getName());
        }
        return propertyValue;
    }

    public static List<?> convertStrings(Class<? extends IPolicy> policyClass, String propertyName, List<String> slist) throws PropertyConfigurationException {
        Type parameterizedType = PolicyFactory.getPropertyType(policyClass, propertyName);
        if (!(parameterizedType instanceof ParameterizedType)) {
            LOGGER.error((Object)"{0} is not a parameterized type: cannot convert the elements of this collection", new Object[]{parameterizedType});
            throw new PropertyConfigurationException(parameterizedType + "is not a parameterized type: cannot convert the elements of this collection");
        }
        Type propertyType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
        ArrayList<Object> values = new ArrayList<Object>();
        for (String svalue : slist) {
            values.add(PolicyFactory.convertString(propertyType, svalue));
        }
        return values;
    }
}

