/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.rpc;

import java.lang.reflect.Method;
import javax.naming.NamingException;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.server.ProtocolNotFoundException;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.SessionId;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.cmi.reference.CMIProxyHandle;
import org.ow2.cmi.reference.CMIProxyHandleImpl;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.rpc.CMIInvocationHandler;
import org.ow2.cmi.rpc.CMIInvocationHandlerException;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.cmi.rpc.POJOInvocationHandlerException;
import org.ow2.cmi.rpc.StubOrProxyHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulPOJOInvocationHandler
extends CMIInvocationHandler<Object> {
    private static final long serialVersionUID = -5482752408858461947L;
    private static Log logger = LogFactory.getLog(StatefulPOJOInvocationHandler.class);
    private transient ClassLoader classLoader;
    private boolean onFailover = false;
    private SessionId sessionId;
    private int requestNb = 0;

    protected StatefulPOJOInvocationHandler(ClassLoader classLoader, ClusterViewManager clusterViewManager, String objectName, String protocolName, Class<?> itf, SessionId sessionId) {
        super(clusterViewManager, objectName, protocolName, true, itf);
        this.classLoader = classLoader;
        this.sessionId = sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeRemoteMethod(Object proxy, Method method, Object ... args) throws Throwable {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.setClassLoader(oldClassLoader);
        try {
            RequestId requestId = new RequestId(this.sessionId, this.requestNb);
            HACurrent.getHACurrent().putNextReq(requestId);
            Object result = super.invokeRemoteMethod(proxy, method, args);
            ++this.requestNb;
            if (this.onFailover) {
                this.onFailover = false;
                HACurrent.getHACurrent().setOnFailover(false);
            }
            Object object = result;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected void checkInitialized() throws CMIInvocationHandlerException {
        if (this.classLoader == null) {
            try {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception e) {
                throw new POJOInvocationHandlerException("Cannot retrieve the classloader for object with name " + this.objectName, e);
            }
        }
    }

    protected CMIProxyHandle getHandle(CMIProxy cmiProxy) {
        if (this.cmiProxyHandle == null) {
            this.cmiProxyHandle = new CMIProxyHandleImpl(this.objectName, this.itf.getName(), cmiProxy);
        }
        return this.cmiProxyHandle;
    }

    protected CMIReferenceable<Object> getCMIReferenceable(CMIReference cmiReference) throws POJOInvocationHandlerException {
        try {
            return StubOrProxyHelper.download((ClusterViewManager)this.clusterViewManager, (CMIReference)cmiReference);
        }
        catch (ProtocolNotFoundException e) {
            logger.error((Object)("Cannot get a CMIReferenceable for " + cmiReference), new Object[]{e});
            throw new POJOInvocationHandlerException("Cannot get a CMIReferenceable for " + cmiReference, e);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)("Cannot get a CMIReferenceable for " + cmiReference), new Object[]{e});
            throw new POJOInvocationHandlerException("Cannot get a CMIReferenceable for " + cmiReference, e);
        }
        catch (NamingException e) {
            logger.debug((Object)("No CMIReferenceable is bound for " + cmiReference), new Object[]{e});
            throw new POJOInvocationHandlerException("No CMIReferenceable is bound for " + cmiReference, e);
        }
    }

    protected void onExceptionHook(String objectName, CMIReferenceable<Object> cmiReferenceable) throws Throwable {
        this.setCurrentRef(null);
        this.onFailover = true;
        HACurrent.getHACurrent().setOnFailover(true);
    }

    protected void onFinallyHook(String objectName, CMIReferenceable<Object> cmiReferenceable) {
    }
}

