/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.common.ImmutableClusteredObjectInfos;
import org.ow2.cmi.controller.server.filter.IFilter;
import org.ow2.cmi.lb.data.PolicyData;
import org.ow2.util.pool.api.IPoolConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class DistributedObjectInfo
extends ImmutableClusteredObjectInfos
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7128398689206804315L;
    private volatile PolicyData policyData;
    private final List<IFilter> filters = Collections.synchronizedList(new ArrayList());
    private final boolean replicated;
    private volatile IPoolConfiguration poolConfiguration;

    public DistributedObjectInfo(String clusterName, boolean proxyEnabled, String objectName, String itfName, String businessName, PolicyData policyData, boolean stateful, boolean replicated, Set<String> applicationExceptionNames, IPoolConfiguration poolConfiguration) {
        super(clusterName, proxyEnabled, objectName, itfName, businessName, stateful, applicationExceptionNames);
        this.policyData = policyData;
        this.replicated = replicated;
        this.poolConfiguration = poolConfiguration;
    }

    public void setPolicyData(PolicyData policyData) {
        this.policyData = policyData;
    }

    public PolicyData getPolicyData() {
        return this.policyData;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public IPoolConfiguration getPoolConfiguration() {
        return this.poolConfiguration;
    }

    public void setPoolConfiguration(IPoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
    }

    public List<? extends IFilter> getFilters() {
        return this.filters;
    }

    public void addFilter(IFilter filter) {
        this.filters.add(filter);
    }

    public boolean removeFilter(IFilter filter) {
        return this.filters.remove(filter);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DistributedObjectInfo)) {
            return false;
        }
        DistributedObjectInfo distributedObjectInfo = (DistributedObjectInfo)object;
        return super.equals((Object)distributedObjectInfo) && (this.policyData == null ? distributedObjectInfo.policyData == null : this.policyData.equals((Object)distributedObjectInfo.policyData)) && this.replicated == distributedObjectInfo.replicated && (this.poolConfiguration == null ? distributedObjectInfo.poolConfiguration == null : this.poolConfiguration.equals(distributedObjectInfo.poolConfiguration)) && ((Object)this.filters).equals(distributedObjectInfo.filters);
    }

    public int hashCode() {
        return super.hashCode() + (this.poolConfiguration == null ? 0 : this.poolConfiguration.hashCode()) + (this.policyData == null ? 0 : this.policyData.hashCode()) + Boolean.valueOf(this.replicated).hashCode() + ((Object)this.filters).hashCode();
    }

    public String toString() {
        return "DistributedObjectInfo=[" + super.toString() + ",lbPolicyData=" + this.policyData + ",filters= " + this.filters + ",replicated=" + this.replicated + ",poolConfiguration=" + this.poolConfiguration + "]";
    }

    public DistributedObjectInfo clone() throws CloneNotSupportedException {
        DistributedObjectInfo distributedObjectInfo = (DistributedObjectInfo)super.clone();
        distributedObjectInfo.policyData = this.policyData.clone();
        return distributedObjectInfo;
    }

    public ImmutableClusteredObjectInfos getImmutableInfos() {
        return new ImmutableClusteredObjectInfos(this.getClusterName(), this.isProxyEnabled(), this.getObjectName(), this.getItfName(), this.getBusinessName(), this.isStateful(), this.getApplicationExceptionNames());
    }
}

