/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.HAEngine;
import fr.dyade.aaa.agent.HAStateReply;
import fr.dyade.aaa.agent.HAStateRequest;
import fr.dyade.aaa.agent.JGroupsAckMsg;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.agent.ServiceManager;
import fr.dyade.aaa.agent.SimpleNetwork;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.Util;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

final class JGroups
implements MembershipListener,
MessageListener {
    static Logger logmon = null;
    private int nbClusterExpected = 2;
    boolean coordinator = false;
    private Channel channel = null;
    private Address myAddr = null;
    private Address coordinatorAddr = null;
    private String channelName = null;
    HAEngine engine = null;
    SimpleNetwork network = null;
    Object lock;
    int state = -11;
    static final int NONE = -11;
    static final int STARTING = 1;
    static final int INITIALIZING = 2;
    static final int RUNNING = 3;

    JGroups() throws Exception {
        logmon = Debug.getLogger((String)"fr.dyade.aaa.agent.JGroups");
        logmon.log(BasicLevel.DEBUG, (Object)"JGroups created.");
        this.nbClusterExpected = AgentServer.getInteger("nbClusterExpected", this.nbClusterExpected);
    }

    void init(String name) throws Exception {
        this.channelName = "HAJGroups." + name;
        this.lock = new Object();
        this.state = 1;
        String addr = System.getProperty("JGroups.MCastAddr", "224.0.0.35");
        String port = System.getProperty("JGroups.MCastPort", "25566");
        String props = System.getProperty("JGroupsProps", "UDP(mcast_addr=" + addr + ";mcast_port=" + port + ";ip_ttl=32;" + "mcast_send_buf_size=150000;mcast_recv_buf_size=80000):" + "PING(timeout=2000;num_initial_members=3):" + "MERGE2(min_interval=5000;max_interval=10000):" + "FD_SOCK:" + "VERIFY_SUSPECT(timeout=1500):" + "pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):" + "UNICAST(timeout=5000):" + "pbcast.STABLE(desired_avg_gossip=20000):" + "FRAG(frag_size=4096;down_thread=false;up_thread=false):" + "pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;" + "shun=false;print_local_addr=true)");
        this.channel = new JChannel(props);
        this.channel.connect(this.channelName);
        new PullPushAdapter((Transport)this.channel, (MessageListener)this, (MembershipListener)this);
        this.myAddr = this.channel.getLocalAddress();
    }

    void disconnect() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"disconnect()");
        }
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel = null;
        }
    }

    void connect() throws ChannelException, ChannelClosedException {
        if (this.channel != null && !this.channel.isConnected()) {
            this.channel.connect(this.channelName);
        }
    }

    void startConsAndServ() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"start service and comsumer");
        }
        Thread t = new Thread(){

            public void run() {
                try {
                    ServiceManager.start();
                }
                catch (Exception exc) {
                    logmon.log(BasicLevel.WARN, (Object)"services start failed.", (Throwable)exc);
                }
                try {
                    AgentServer.startConsumers();
                }
                catch (Throwable exc) {
                    logmon.log(BasicLevel.WARN, (Object)"consumer start failed.", exc);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Serializable message) throws Exception {
        if (this.channel == null) {
            return;
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("JGroups send(" + message + ")"));
        }
        byte[] buf = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(message);
            buf = bos.toByteArray();
            oos.flush();
        }
        catch (Exception e) {
            logmon.log(BasicLevel.ERROR, (Object)"JGroups send message", (Throwable)e);
            throw e;
        }
        if (buf == null) {
            return;
        }
        org.jgroups.Message msg = new org.jgroups.Message(null, null, buf);
        Object object = this.lock;
        synchronized (object) {
            this.channel.send(msg);
            this.lock.wait();
        }
    }

    void sendTo(Address dst, Serializable obj) throws Exception {
        if (this.channel == null) {
            return;
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("JGroups sendTo(" + dst + "," + obj + ")"));
        }
        this.channel.send(dst, this.myAddr, obj);
    }

    Address getCoordinatorAddr() {
        return this.coordinatorAddr;
    }

    void setEngine(HAEngine engine) {
        logmon.log(BasicLevel.DEBUG, (Object)"setEngine");
        this.engine = engine;
    }

    void setNetWork(SimpleNetwork network) {
        this.network = network;
    }

    boolean isCoordinator() {
        return this.coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(org.jgroups.Message msg) {
        try {
            Object obj = Util.objectFromByteBuffer((byte[])msg.getBuffer());
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)(" receive obj = " + obj + "\nmsg.getSrc =" + msg.getSrc() + "\nmsg.getDest =" + msg.getDest() + "\nmyAddr = " + this.myAddr + "\ncoordinator = " + this.coordinator + "\nstate=" + this.state));
            }
            if (this.myAddr.equals(msg.getSrc())) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)"jgroups, I am the sender.");
                }
                if (obj instanceof Message || obj instanceof JGroupsAckMsg || obj instanceof HAStateReply) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.notify();
                    }
                }
                return;
            }
            if (obj instanceof HAStateRequest && this.coordinator) {
                HAStateRequest req = (HAStateRequest)obj;
                this.engine.requestor.add(req.getAddress());
            } else if (obj instanceof HAStateReply) {
                if (this.state != 2) {
                    return;
                }
                HAStateReply reply = (HAStateReply)obj;
                ServiceDesc[] services = ServiceManager.getServices();
                if (services != null) {
                    for (int i = 0; i < services.length; ++i) {
                        services[i].initialized = true;
                    }
                }
                if (this.network != null) {
                    this.network.setStamp(reply.getNetworkStamp());
                }
                this.engine.setState(reply);
                this.state = 3;
            } else if (obj instanceof Message) {
                if (this.state != 3) {
                    return;
                }
                Message m = (Message)obj;
                if (this.network != null && m.from.getTo() != AgentServer.getServerId()) {
                    this.network.deliver(m);
                } else {
                    this.engine.receiveFromJGroups(m);
                }
            } else if (obj instanceof JGroupsAckMsg && this.network != null) {
                if (this.state != 3) {
                    return;
                }
                this.network.ackMsg((JGroupsAckMsg)obj);
            }
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.ERROR, (Object)("JGroups part receive msg = " + msg), (Throwable)exc);
        }
    }

    public byte[] getState() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"=== MessageListener getState");
        }
        return null;
    }

    public void setState(byte[] state) {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"=== MessageListener setState");
        }
    }

    public void viewAccepted(View view) {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("==== viewAccepted: " + view));
        }
        Vector mbrs = view.getMembers();
        this.coordinatorAddr = (Address)mbrs.elementAt(0);
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("JGroups setView: " + this.coordinator + ", " + this.state));
        }
        if (this.coordinator) {
            if (!this.coordinatorAddr.equals(this.myAddr)) {
                logmon.log(BasicLevel.FATAL, (Object)"Bad view for coordinator");
                throw new RuntimeException("Bad view for coordinator");
            }
            return;
        }
        if (this.state != 3 && !this.coordinatorAddr.equals(this.myAddr)) {
            try {
                this.sendTo(this.coordinatorAddr, new HAStateRequest(this.myAddr));
                this.state = 2;
            }
            catch (Exception exc) {
                logmon.log(BasicLevel.ERROR, (Object)"JGroups sendTo()", (Throwable)exc);
            }
        }
        if (mbrs.size() >= this.nbClusterExpected && this.coordinatorAddr.equals(this.myAddr)) {
            this.coordinator = true;
            this.startConsAndServ();
            this.state = 3;
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("JGroups setView: " + this.coordinator + ", " + this.state));
        }
    }

    public void suspect(Address suspected_mbr) {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("==== suspect(): " + suspected_mbr));
        }
    }

    public void block() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"==== block()");
        }
    }
}

