/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.joram.mom.dest.mail;

import com.scalagent.joram.mom.dest.mail.AddSenderInfo;
import com.scalagent.joram.mom.dest.mail.JavaMailQueueImplMBean;
import com.scalagent.joram.mom.dest.mail.JavaMailUtil;
import com.scalagent.joram.mom.dest.mail.MailMessage;
import com.scalagent.joram.mom.dest.mail.RemoveSenderInfo;
import com.scalagent.joram.mom.dest.mail.SenderInfo;
import com.scalagent.joram.mom.dest.mail.UpdateSenderInfo;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.util.Debug;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.SpecialAdminRequest;
import org.objectweb.joram.shared.admin.SpecialAdmin;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JavaMailQueueImpl
extends QueueImpl
implements JavaMailQueueImplMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)JavaMailQueueImpl.class.getName());
    private String smtpServer = null;
    private String to = null;
    private String cc = null;
    private String bcc = null;
    private String from = null;
    private String subject = null;
    private String selector = null;
    private long popPeriod = -1L;
    private String popServer = null;
    private String popUser = null;
    private String popPassword = null;
    private boolean expunge = false;
    private Vector senderInfos = null;
    private transient JavaMailUtil javaMailUtil = null;

    public JavaMailQueueImpl(AgentId destId, AgentId adminId, Properties prop) {
        super(destId, adminId, prop);
        this.setProperties(prop);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " JavaMailQueueImpl : " + "\nsenderInfos=" + this.senderInfos + "\npopServer=" + this.popServer + "\npopUser=" + this.popUser + "\npopPeriod=" + this.popPeriod + "\nexpunge=" + this.expunge));
        }
    }

    public void setProperties(Properties prop) {
        this.smtpServer = prop.getProperty("smtpServer", this.smtpServer);
        this.to = prop.getProperty("to", this.to);
        this.cc = prop.getProperty("cc", this.cc);
        this.bcc = prop.getProperty("bcc", this.bcc);
        this.from = prop.getProperty("from", this.from);
        this.subject = prop.getProperty("subject", this.subject);
        this.selector = prop.getProperty("selector", this.selector);
        this.senderInfos = new Vector();
        this.senderInfos.add(new SenderInfo(this.smtpServer, this.to, this.cc, this.bcc, this.from, this.subject, this.selector));
        try {
            this.popPeriod = Long.valueOf(prop.getProperty("popPeriod"));
        }
        catch (NumberFormatException exc) {
            this.popPeriod = -1L;
        }
        this.popServer = prop.getProperty("popServer", this.popServer);
        this.popUser = prop.getProperty("popUser", this.popUser);
        this.popPassword = prop.getProperty("popPassword", this.popPassword);
        this.expunge = Boolean.valueOf(prop.getProperty("expunge"));
    }

    public String getSMTPServer() {
        return this.smtpServer;
    }

    public void setSMTPServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getDefaultTo() {
        return this.to;
    }

    public void setDefaultTo(String to) {
        this.to = to;
    }

    public String getDefaultCC() {
        return this.cc;
    }

    public void setDefaultCC(String cc) {
        this.cc = cc;
    }

    public String getDefaultBcc() {
        return this.bcc;
    }

    public void setDefaultBcc(String bcc) {
        this.bcc = bcc;
    }

    public String getDefaultFrom() {
        return this.from;
    }

    public void setDefaultFrom(String from) {
        this.from = from;
    }

    public String getDefaultSubject() {
        return this.subject;
    }

    public void setDefaultSubject(String subject) {
        this.subject = subject;
    }

    public String getDefaultSelector() {
        return this.selector;
    }

    public void setDefaultSelector(String selector) {
        this.selector = selector;
    }

    public long getPopPeriod() {
        return this.popPeriod;
    }

    public void setPopPeriod(long period) {
        this.popPeriod = period;
    }

    public String getPopServer() {
        return this.popServer;
    }

    public void setPopServer(String server) {
        this.popServer = server;
    }

    public String getPopUser() {
        return this.popUser;
    }

    public void setPopUser(String user) {
        this.popUser = user;
    }

    public String getPopPassword() {
        return this.popPassword;
    }

    public void setPopPassword(String pass) {
        this.popPassword = pass;
    }

    public boolean getExpunge() {
        return this.expunge;
    }

    public void setExpunge(boolean expunge) {
        this.expunge = expunge;
    }

    public String toString() {
        return "JavaMailQueueImpl:" + this.destId.toString();
    }

    protected Object specialAdminProcess(SpecialAdminRequest not) throws RequestException {
        try {
            SpecialAdmin req = not.getRequest();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " specialAdminProcess : " + req));
            }
            if (req instanceof AddSenderInfo) {
                this.addSenderInfo(((AddSenderInfo)req).si, ((AddSenderInfo)req).index);
            } else if (req instanceof RemoveSenderInfo) {
                if (((RemoveSenderInfo)req).index > -1) {
                    this.removeSenderInfo(((RemoveSenderInfo)req).index);
                } else {
                    this.removeSenderInfo(((RemoveSenderInfo)req).si);
                }
            } else if (req instanceof UpdateSenderInfo) {
                this.updateSenderInfo(((UpdateSenderInfo)req).oldSi, ((UpdateSenderInfo)req).newSi);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " specialAdminProcess senderInfos=" + this.senderInfos));
            }
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)("--- " + this + " specialAdminProcess"), (Throwable)exc);
            }
            throw new RequestException(exc.getMessage());
        }
        return "done";
    }

    protected void addSenderInfo(SenderInfo si, int index) throws ArrayIndexOutOfBoundsException {
        if (index > -1) {
            this.senderInfos.add(index, si);
        } else {
            this.senderInfos.add(si);
        }
    }

    protected SenderInfo removeSenderInfo(int index) throws ArrayIndexOutOfBoundsException {
        return (SenderInfo)this.senderInfos.remove(index);
    }

    protected boolean removeSenderInfo(SenderInfo si) {
        return this.senderInfos.remove(si);
    }

    protected boolean updateSenderInfo(SenderInfo oldSi, SenderInfo newSi) throws ArrayIndexOutOfBoundsException {
        int index = this.senderInfos.indexOf(oldSi);
        if (index > -1) {
            return false;
        }
        this.senderInfos.set(index, newSi);
        return true;
    }

    public ClientMessages preProcess(AgentId from, ClientMessages not) {
        Enumeration msgs = not.getMessages().elements();
        while (msgs.hasMoreElements()) {
            Message msg = (Message)msgs.nextElement();
            SenderInfo si = this.match(msg);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " match=" + (si != null)));
            }
            if (si == null) continue;
            try {
                this.javaMailUtil.sendJavaMail(si, new MailMessage(msg));
            }
            catch (Exception exc) {
                ClientMessages deadM = new ClientMessages(not.getClientContext(), not.getRequestId());
                deadM.addMessage(msg);
                this.sendToDMQ(deadM, not.getDMQId());
                logger.log(BasicLevel.WARN, (Object)"JavaMailQueueImpl.sendJavaMail", (Throwable)exc);
            }
            not.getMessages().remove(msg);
        }
        if (not.getMessages().size() > 0) {
            return not;
        }
        return null;
    }

    protected SenderInfo match(Message msg) {
        Enumeration e = this.senderInfos.elements();
        while (e.hasMoreElements()) {
            SenderInfo si = (SenderInfo)e.nextElement();
            if (si.selector == null) {
                return si;
            }
            if (!Selector.matches((Message)msg, (String)si.selector)) continue;
            return si;
        }
        return null;
    }

    public void doPop() {
        long count = 0L;
        Vector<javax.mail.Message> toExpunge = new Vector<javax.mail.Message>();
        javax.mail.Message[] msgs = this.javaMailUtil.popMail(this.popServer, this.popUser, this.popPassword, this.expunge);
        if (msgs != null) {
            for (int i = 0; i < msgs.length; ++i) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " doPop : msgs[" + i + "] = " + msgs[i]));
                }
                try {
                    Properties prop = this.javaMailUtil.getMOMProperties(msgs[i]);
                    MailMessage m = this.javaMailUtil.createMessage(prop, this.destId.toString() + "mail_" + ++count, Queue.getDestinationType(), this.destId.toString(), Queue.getDestinationType());
                    this.storeMessage(new org.objectweb.joram.mom.messages.Message(m.getSharedMessage()));
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " doPop : storeMessage m = " + m));
                    }
                    if (!this.expunge) continue;
                    toExpunge.add(msgs[i]);
                    continue;
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " doPop"), (Throwable)exc);
                }
            }
            this.deliverMessages(0);
        }
        this.javaMailUtil.closeFolder(toExpunge, this.expunge);
        toExpunge.clear();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " JavaMailQueueImpl.readObject : " + "\nsenderInfos=" + this.senderInfos + "\npopServer=" + this.popServer + "\npopUser=" + this.popUser + "\npopPeriod=" + this.popPeriod + "\nexpunge=" + this.expunge));
        }
        this.javaMailUtil = new JavaMailUtil();
    }
}

