/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.distributed;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.jndi2.distributed.CreateRemoteSubcontextRequest;
import fr.dyade.aaa.jndi2.distributed.DistributedJndiServer;
import fr.dyade.aaa.jndi2.distributed.InitJndiServerNot;
import fr.dyade.aaa.jndi2.distributed.JndiUpdateNot;
import fr.dyade.aaa.jndi2.distributed.SyncReplyNot;
import fr.dyade.aaa.jndi2.distributed.SyncRequestNot;
import fr.dyade.aaa.jndi2.impl.BindEvent;
import fr.dyade.aaa.jndi2.impl.ChangeOwnerEvent;
import fr.dyade.aaa.jndi2.impl.ContextRecord;
import fr.dyade.aaa.jndi2.impl.CreateSubcontextEvent;
import fr.dyade.aaa.jndi2.impl.DestroySubcontextEvent;
import fr.dyade.aaa.jndi2.impl.MissingContextException;
import fr.dyade.aaa.jndi2.impl.MissingRecordException;
import fr.dyade.aaa.jndi2.impl.NamingContext;
import fr.dyade.aaa.jndi2.impl.NamingContextInfo;
import fr.dyade.aaa.jndi2.impl.NotOwnerException;
import fr.dyade.aaa.jndi2.impl.RebindEvent;
import fr.dyade.aaa.jndi2.impl.Record;
import fr.dyade.aaa.jndi2.impl.UnbindEvent;
import fr.dyade.aaa.jndi2.impl.UpdateEvent;
import fr.dyade.aaa.jndi2.impl.UpdateListener;
import fr.dyade.aaa.jndi2.msg.ChangeOwnerRequest;
import fr.dyade.aaa.jndi2.msg.CreateSubcontextRequest;
import fr.dyade.aaa.jndi2.msg.JndiError;
import fr.dyade.aaa.jndi2.msg.JndiReply;
import fr.dyade.aaa.jndi2.msg.JndiRequest;
import fr.dyade.aaa.jndi2.server.JndiReplyNot;
import fr.dyade.aaa.jndi2.server.JndiScriptReplyNot;
import fr.dyade.aaa.jndi2.server.JndiScriptRequestNot;
import fr.dyade.aaa.jndi2.server.RequestContext;
import fr.dyade.aaa.jndi2.server.RequestManager;
import fr.dyade.aaa.jndi2.server.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;

public class ReplicationManager
extends RequestManager
implements UpdateListener {
    private static final long serialVersionUID = 1L;
    public static final String INIT_REQUEST_TABLE = "initRequestTable";
    public static final String SYNC_REQUEST_TABLE = "syncRequestTable";
    public static final String WRITE_REQUEST_TABLE = "writeRequestTable";
    public static final String SERVER_LIST = "serverList";
    private AgentId rootOwnerId;
    private short[] serverIds;
    private transient Vector servers;
    private transient Hashtable writeRequestContextLists;
    private transient Hashtable initRequestContextLists;
    private transient Hashtable syncRequestContextLists;
    private boolean looseCoupling;

    public ReplicationManager(short[] serverIds) {
        this.serverIds = serverIds;
    }

    protected AgentId getRootOwnerId() {
        return this.rootOwnerId;
    }

    public void agentInitialize(boolean firstTime) throws Exception {
        if (firstTime) {
            this.looseCoupling = Boolean.getBoolean("fr.dyade.aaa.jndi2.impl.LooseCoupling");
            this.rootOwnerId = this.serverIds.length > 0 && !this.looseCoupling ? DistributedJndiServer.getDefault(this.serverIds[0]) : this.getId();
        }
        super.agentInitialize(firstTime);
        this.writeRequestContextLists = (Hashtable)AgentServer.getTransaction().load(WRITE_REQUEST_TABLE);
        if (this.writeRequestContextLists == null) {
            this.writeRequestContextLists = new Hashtable();
        }
        this.initRequestContextLists = (Hashtable)AgentServer.getTransaction().load(INIT_REQUEST_TABLE);
        if (this.initRequestContextLists == null) {
            this.initRequestContextLists = new Hashtable();
        }
        this.syncRequestContextLists = (Hashtable)AgentServer.getTransaction().load(SYNC_REQUEST_TABLE);
        if (this.syncRequestContextLists == null) {
            this.syncRequestContextLists = new Hashtable();
        }
        this.servers = (Vector)AgentServer.getTransaction().load(SERVER_LIST);
        if (this.servers == null) {
            this.servers = new Vector();
            for (int i = 0; i < this.serverIds.length; ++i) {
                AgentId aid = DistributedJndiServer.getDefault(this.serverIds[i]);
                this.servers.addElement(aid);
                this.sendTo(aid, new InitJndiServerNot(null, null, true));
            }
            this.saveServers();
        }
        this.getServerImpl().setUpdateListener(this);
    }

    void doReact(AgentId from, JndiUpdateNot not) throws Exception {
        block15: {
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)("ReplicationManager[" + this.getId() + "].doReact(" + from + ',' + not + ')'));
            }
            UpdateEvent updateEvent = not.getUpdateEvent();
            try {
                if (updateEvent instanceof BindEvent) {
                    this.onUpdateEvent(from, (BindEvent)updateEvent);
                } else if (updateEvent instanceof RebindEvent) {
                    this.onUpdateEvent(from, (RebindEvent)updateEvent);
                } else if (updateEvent instanceof UnbindEvent) {
                    this.onUpdateEvent(from, (UnbindEvent)updateEvent);
                } else if (updateEvent instanceof CreateSubcontextEvent) {
                    this.onUpdateEvent(from, (CreateSubcontextEvent)updateEvent);
                } else if (updateEvent instanceof DestroySubcontextEvent) {
                    this.onUpdateEvent(from, (DestroySubcontextEvent)updateEvent);
                } else if (updateEvent instanceof ChangeOwnerEvent) {
                    this.onUpdateEvent(from, (ChangeOwnerEvent)updateEvent);
                }
            }
            catch (NotOwnerException exc) {
                Trace.logger.log(BasicLevel.WARN, (Object)"Distributed jndi update warn:", (Throwable)exc);
            }
            catch (NamingException exc) {
                if (this.looseCoupling) break block15;
                Trace.logger.log(BasicLevel.ERROR, (Object)"Distributed jndi update error:", (Throwable)exc);
                throw new Error(exc.toString());
            }
        }
    }

    private void onUpdateEvent(AgentId from, BindEvent evt) throws NamingException {
        if (!this.looseCoupling) {
            this.getServerImpl().bind(this.getServerImpl().getNamingContext(evt.getUpdatedContextId()), evt.getName(), evt.getObject(), from);
        } else {
            NamingContext nc = this.getServerImpl().getNamingContext(evt.getPath());
            this.getServerImpl().bind(nc, evt.getName(), evt.getObject(), from);
        }
    }

    private void onUpdateEvent(AgentId from, RebindEvent evt) throws NamingException {
        if (!this.looseCoupling) {
            this.getServerImpl().rebind(this.getServerImpl().getNamingContext(evt.getUpdatedContextId()), evt.getName(), evt.getObject(), from);
        } else {
            NamingContext nc = this.getServerImpl().getNamingContext(evt.getPath());
            this.getServerImpl().rebind(nc, evt.getName(), evt.getObject(), from);
        }
    }

    private void onUpdateEvent(AgentId from, UnbindEvent evt) throws NamingException {
        if (!this.looseCoupling) {
            this.getServerImpl().unbind(this.getServerImpl().getNamingContext(evt.getUpdatedContextId()), evt.getName(), from);
        } else {
            NamingContext nc = this.getServerImpl().getNamingContext(evt.getPath());
            this.getServerImpl().unbind(nc, evt.getName(), from);
        }
    }

    private void onUpdateEvent(AgentId from, CreateSubcontextEvent evt) throws NamingException {
        if (!this.looseCoupling) {
            this.getServerImpl().createSubcontext(this.getServerImpl().getNamingContext(evt.getUpdatedContextId()), evt.getName(), evt.getPath(), evt.getContextId(), evt.getOwnerId(), from);
        } else {
            CompositeName parentPath = (CompositeName)evt.getPath().clone();
            parentPath.remove(parentPath.size() - 1);
            NamingContext nc = this.getServerImpl().getNamingContext(parentPath);
            this.getServerImpl().createSubcontext(nc, evt.getName(), evt.getPath(), evt.getContextId(), this.getId(), from);
        }
    }

    private void onUpdateEvent(AgentId from, DestroySubcontextEvent evt) throws NamingException {
        if (!this.looseCoupling) {
            this.getServerImpl().destroySubcontext(this.getServerImpl().getNamingContext(evt.getUpdatedContextId()), evt.getName(), evt.getPath(), from);
        } else {
            CompositeName parentPath = (CompositeName)evt.getPath().clone();
            parentPath.remove(parentPath.size() - 1);
            NamingContext nc = this.getServerImpl().getNamingContext(parentPath);
            this.getServerImpl().destroySubcontext(nc, evt.getName(), evt.getPath(), from);
        }
    }

    private void onUpdateEvent(AgentId from, ChangeOwnerEvent evt) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ReplicationManager.onUpdateEvent(" + from + ',' + evt + ')'));
        }
        NamingContextInfo[] contexts = evt.getNamingContexts();
        for (int i = 0; i < contexts.length; ++i) {
            NamingContext nc = this.getServerImpl().getNamingContext(contexts[i].getNamingContext().getId());
            if (nc == null) {
                this.getServerImpl().addNamingContext(contexts[i]);
                continue;
            }
            nc.setOwnerId(contexts[i].getNamingContext().getOwnerId());
            this.getServerImpl().resetNamingContext(contexts[i].getNamingContext());
        }
    }

    protected JndiReply invokeOwner(AgentId owner, RequestContext reqCtx) {
        Object request;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ReplicationManager.invokeOwner(" + owner + ',' + reqCtx + ')'));
        }
        if ((request = reqCtx.getRequest()) instanceof CreateSubcontextRequest) {
            CreateSubcontextRequest csr = (CreateSubcontextRequest)request;
            request = new CreateRemoteSubcontextRequest(csr.getName(), this.getId());
        }
        this.sendTo(owner, new JndiScriptRequestNot(new JndiRequest[]{request}, true));
        RequestContextList list = (RequestContextList)this.writeRequestContextLists.get(owner);
        if (list == null) {
            list = new RequestContextList();
            this.writeRequestContextLists.put(owner, list);
        }
        list.put(reqCtx);
        this.saveWriteRequestTable();
        return null;
    }

    void doReact(AgentId from, JndiScriptReplyNot not) throws Exception {
        this.onReply(from, not.getReplies()[0]);
    }

    void doReact(AgentId from, JndiReplyNot not) throws Exception {
        this.onReply(from, not.getReply());
    }

    private void onReply(AgentId from, JndiReply reply) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ReplicationManager[" + this.getId() + "].onReply(" + from + ',' + reply + ')'));
        }
        RequestContextList ctxList = (RequestContextList)this.writeRequestContextLists.get(from);
        RequestContext ctx = ctxList.get();
        ctxList.pop();
        if (ctxList.getSize() == 0) {
            this.writeRequestContextLists.remove(from);
        }
        if (ctx != null) {
            ctx.reply(reply);
            this.saveWriteRequestTable();
        } else {
            Trace.logger.log(BasicLevel.ERROR, (Object)("Reply context not found: " + from + ", " + reply));
        }
    }

    void doReact(AgentId from, InitJndiServerNot not) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ReplicationManager.doReact(" + from + ',' + not + ')'));
        }
        if (this.servers == null) {
            return;
        }
        AgentId[] jndiServerIds = not.getJndiServerIds();
        Vector<AgentId> initServers = new Vector<AgentId>();
        if (jndiServerIds != null) {
            for (int i = 0; i < jndiServerIds.length; ++i) {
                if (this.servers.indexOf(jndiServerIds[i]) >= 0) continue;
                initServers.addElement(jndiServerIds[i]);
            }
        }
        if (not.isRequest() || this.servers.indexOf(from) < 0) {
            initServers.addElement(from);
        }
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)(" -> initServers = " + initServers));
        }
        if (initServers.size() > 0) {
            Object[] localJndiServerIds = new AgentId[this.servers.size()];
            this.servers.copyInto(localJndiServerIds);
            NamingContextInfo[] localContexts = this.getServerImpl().copyNamingContexts(this.getId());
            int serversInitialLength = this.servers.size();
            for (int i = 0; i < initServers.size(); ++i) {
                AgentId newServerId = (AgentId)initServers.elementAt(i);
                if (!this.rootOwnerId.equals((AgentId)initServers.elementAt(i))) {
                    this.sendTo(newServerId, new InitJndiServerNot((AgentId[])localJndiServerIds, localContexts, !from.equals(newServerId)));
                }
                if (this.servers.indexOf(newServerId) >= 0) continue;
                this.servers.addElement(newServerId);
            }
            if (this.servers.size() > serversInitialLength) {
                this.saveServers();
            }
        }
        NamingContextInfo[] contexts = not.getContexts();
        Hashtable<Record, CompositeName> record_compositeName = new Hashtable<Record, CompositeName>();
        Hashtable<CompositeName, NamingContext> composite_context = new Hashtable<CompositeName, NamingContext>();
        if (contexts != null) {
            Vector<CompositeName> newNames = new Vector<CompositeName>();
            for (int i = 0; i < contexts.length; ++i) {
                NamingContext nc;
                if (!this.looseCoupling) {
                    nc = this.getServerImpl().getNamingContext(contexts[i].getNamingContext().getId());
                    if (nc != null) continue;
                    this.getServerImpl().addNamingContext(contexts[i]);
                    newNames.addElement(contexts[i].getCompositeName());
                    continue;
                }
                try {
                    nc = this.getServerImpl().getNamingContext(contexts[i].getCompositeName());
                }
                catch (MissingRecordException mre) {
                    nc = null;
                }
                catch (MissingContextException mce) {
                    nc = null;
                }
                if (nc == null) {
                    nc = this.getServerImpl().newNamingContext(this.getId(), null, contexts[i].getCompositeName());
                    contexts[i].getNamingContext().setOwnerId(this.getId());
                }
                Enumeration enumRecord = contexts[i].getNamingContext().getEnumRecord();
                while (enumRecord.hasMoreElements()) {
                    Record record = (Record)enumRecord.nextElement();
                    Record r = nc.getRecord(record.getName());
                    if (r == null) {
                        nc.addRecord(record);
                    }
                    if (!(record instanceof ContextRecord)) continue;
                    CompositeName parentPath = contexts[i].getCompositeName();
                    record_compositeName.put(record, parentPath);
                }
                composite_context.put(contexts[i].getCompositeName(), nc);
            }
            if (this.looseCoupling) {
                Enumeration enumKeyRecord = record_compositeName.keys();
                while (enumKeyRecord.hasMoreElements()) {
                    Record recor = (Record)enumKeyRecord.nextElement();
                    CompositeName cn = (CompositeName)((CompositeName)record_compositeName.get(recor)).clone();
                    cn.add(recor.getName());
                    if (!composite_context.containsKey(cn)) continue;
                    NamingContext nc = (NamingContext)composite_context.get(cn);
                    ((ContextRecord)recor).setId(nc.getId());
                }
                Enumeration enumContext = composite_context.elements();
                while (enumContext.hasMoreElements()) {
                    NamingContext nc = (NamingContext)enumContext.nextElement();
                    this.getServerImpl().storeNamingContext(nc);
                }
            }
            Vector<CompositeName> retryNames = new Vector<CompositeName>();
            Vector<RequestContextList> retryLists = new Vector<RequestContextList>();
            Enumeration names = this.initRequestContextLists.keys();
            Enumeration lists = this.initRequestContextLists.elements();
            while (lists.hasMoreElements()) {
                CompositeName name = (CompositeName)names.nextElement();
                RequestContextList ctxList = (RequestContextList)lists.nextElement();
                boolean retry = false;
                for (int i = 0; i < newNames.size(); ++i) {
                    CompositeName newName = (CompositeName)newNames.elementAt(i);
                    if (!name.startsWith(newName)) continue;
                    retry = true;
                    break;
                }
                if (!retry) continue;
                retryNames.addElement(name);
                retryLists.addElement(ctxList);
            }
            for (int i = 0; i < retryNames.size(); ++i) {
                CompositeName name = (CompositeName)retryNames.elementAt(i);
                RequestContextList ctxList = (RequestContextList)retryLists.elementAt(i);
                this.initRequestContextLists.remove(name);
                while (ctxList.getSize() > 0) {
                    RequestContext reqCtx = ctxList.get();
                    JndiReply reply = this.invoke(reqCtx);
                    if (reply != null) {
                        reqCtx.reply(reply);
                    }
                    ctxList.pop();
                }
            }
            this.saveInitRequestTable();
        }
    }

    protected JndiReply onMissingContext(MissingContextException mce, RequestContext reqCtx) {
        RequestContextList ctxList;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ReplicationManager.onMissingContext(" + mce + ',' + reqCtx + ')'));
        }
        if ((ctxList = (RequestContextList)this.initRequestContextLists.get(mce.getName())) == null) {
            ctxList = new RequestContextList();
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)(" -> add a waiting request context: " + mce.getName()));
            }
            this.initRequestContextLists.put(mce.getName(), ctxList);
        }
        ctxList.put(reqCtx);
        this.saveInitRequestTable();
        return null;
    }

    protected JndiReply onMissingRecord(MissingRecordException mre, RequestContext reqCtx) {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ReplicationManager.onMissingRecord(" + mre + ',' + reqCtx + ')'));
        }
        CompositeName resolvedName = (CompositeName)mre.getNameNotFoundException().getResolvedName();
        if (mre.getOwnerId().equals(this.getId()) || resolvedName.equals(reqCtx.getResolvedName())) {
            return new JndiError((NamingException)mre.getNameNotFoundException());
        }
        reqCtx.setResolvedName(resolvedName);
        this.synchronizeRequest((AgentId)mre.getOwnerId(), reqCtx);
        return null;
    }

    private void synchronizeRequest(AgentId owner, RequestContext reqCtx) {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ReplicationManager.synchronizeRequest(" + owner + ',' + reqCtx + ')'));
        }
        this.sendTo(owner, new SyncRequestNot());
        RequestContextList list = (RequestContextList)this.syncRequestContextLists.get(owner);
        if (list == null) {
            list = new RequestContextList();
            this.syncRequestContextLists.put(owner, list);
        }
        list.put(reqCtx);
        this.saveSyncRequestTable();
    }

    void doReact(AgentId from, SyncRequestNot not) {
        this.sendTo(from, new SyncReplyNot());
    }

    void doReact(AgentId from, SyncReplyNot not) {
        JndiReply reply;
        RequestContextList ctxList = (RequestContextList)this.syncRequestContextLists.get(from);
        RequestContext ctx = ctxList.get();
        ctxList.pop();
        if (ctxList.getSize() == 0) {
            this.syncRequestContextLists.remove(from);
        }
        if (ctx != null && (reply = this.invoke(ctx)) != null) {
            ctx.reply(reply);
            this.saveSyncRequestTable();
        }
    }

    public void onUpdate(UpdateEvent event) {
        for (int i = 0; i < this.servers.size(); ++i) {
            AgentId aid = (AgentId)this.servers.elementAt(i);
            this.sendTo(aid, new JndiUpdateNot(event));
        }
    }

    protected void createSubcontext(CreateSubcontextRequest request) throws NamingException {
        if (request instanceof CreateRemoteSubcontextRequest) {
            this.createRemoteSubcontext((CreateRemoteSubcontextRequest)request);
        } else {
            super.createSubcontext(request);
        }
    }

    private void createRemoteSubcontext(CreateRemoteSubcontextRequest request) throws NamingException {
        this.getServerImpl().createSubcontext(request.getName(), request.getOwnerId());
    }

    protected void changeOwner(ChangeOwnerRequest request) throws NamingException {
        super.changeOwner(request);
        this.writeRequestContextLists.remove(request.getOwnerId());
        this.syncRequestContextLists.remove(request.getOwnerId());
    }

    private void saveInitRequestTable() {
        try {
            AgentServer.getTransaction().save((Serializable)this.initRequestContextLists, INIT_REQUEST_TABLE);
        }
        catch (IOException exc) {
            throw new Error(exc.toString());
        }
    }

    private void saveWriteRequestTable() {
        try {
            AgentServer.getTransaction().save((Serializable)this.writeRequestContextLists, WRITE_REQUEST_TABLE);
        }
        catch (IOException exc) {
            throw new Error(exc.toString());
        }
    }

    private void saveSyncRequestTable() {
        try {
            AgentServer.getTransaction().save((Serializable)this.syncRequestContextLists, SYNC_REQUEST_TABLE);
        }
        catch (IOException exc) {
            throw new Error(exc.toString());
        }
    }

    private void saveServers() {
        try {
            AgentServer.getTransaction().save((Serializable)this.servers, SERVER_LIST);
        }
        catch (IOException exc) {
            throw new Error(exc.toString());
        }
    }

    static class RequestContextList
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Vector list = new Vector();

        RequestContextList() {
        }

        void put(RequestContext ctx) {
            this.list.addElement(ctx);
        }

        RequestContext get() {
            if (this.list.size() > 0) {
                return (RequestContext)this.list.elementAt(0);
            }
            return null;
        }

        void pop() {
            if (this.list.size() > 0) {
                this.list.removeElementAt(0);
            }
        }

        int getSize() {
            return this.list.size();
        }

        public String toString() {
            return '(' + super.toString() + ",list=" + this.list + ')';
        }
    }
}

