/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.JTransactionMBean;
import fr.dyade.aaa.util.StartWithFilter;
import fr.dyade.aaa.util.Transaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public final class JTransaction
implements Transaction,
JTransactionMBean {
    public static final String EMPTY_STRING = new String();
    private File dir = null;
    private static final String LOG = "log";
    private RandomAccessFile logFile = null;
    private Hashtable log = null;
    static final int SAVE = 1;
    static final int DELETE = 2;
    private int phase;

    public boolean isPersistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String path) throws IOException {
        this.phase = 0;
        this.dir = new File(path);
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        if (!this.dir.isDirectory()) {
            throw new FileNotFoundException(path + " is not a directory.");
        }
        FilterOutputStream dos = null;
        try {
            File tfc = new File(this.dir, "TFC");
            if (!tfc.exists()) {
                dos = new DataOutputStream(new FileOutputStream(tfc));
                ((DataOutputStream)dos).writeUTF(this.getClass().getName());
                ((DataOutputStream)dos).flush();
            }
        }
        finally {
            if (dos != null) {
                dos.close();
            }
        }
        int oldPhase = 1;
        this.logFile = new RandomAccessFile(new File(this.dir, LOG), "rw");
        this.log = new Hashtable();
        if (this.logFile.length() != 0L) {
            this.logFile.seek(0L);
            oldPhase = this.logFile.readInt();
            if (oldPhase == 3) {
                String name;
                while (!(name = this.logFile.readUTF()).equals("")) {
                    String dirName = this.logFile.readUTF();
                    if (dirName.length() == 0) {
                        dirName = null;
                    }
                    Object key = OperationKey.newKey(dirName, name);
                    int op = this.logFile.read();
                    if (op == 1) {
                        byte[] buf = new byte[this.logFile.readInt()];
                        this.logFile.readFully(buf);
                        this.log.put(key, new Operation(1, dirName, name, buf));
                        continue;
                    }
                    this.log.put(key, new Operation(op, dirName, name));
                }
            }
            this._commit();
        }
        this.setPhase(1);
    }

    public File getDir() {
        return this.dir;
    }

    public String getPersistenceDir() {
        return this.dir.getPath();
    }

    public int getPhase() {
        return this.phase;
    }

    public String getPhaseInfo() {
        return PhaseInfo[this.phase];
    }

    private void setPhase(int newPhase) throws IOException {
        this.logFile.seek(0L);
        this.logFile.writeInt(newPhase);
        this.logFile.getFD().sync();
        this.phase = newPhase;
    }

    public synchronized void begin() throws IOException {
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(2);
    }

    public String[] getList(String prefix) {
        return this.dir.list(new StartWithFilter(prefix));
    }

    public final void create(Serializable obj, String name) throws IOException {
        this.save(obj, null, name);
    }

    public void save(Serializable obj, String name) throws IOException {
        this.save(obj, null, name);
    }

    public final void create(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, dirName, name);
    }

    public final void save(Serializable obj, String dirName, String name) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        this.saveByteArray(bos.toByteArray(), dirName, name);
    }

    public void saveByteArray(byte[] buf, String name) throws IOException {
        this.saveByteArray(buf, null, name);
    }

    public void saveByteArray(byte[] buf, String dirName, String name) throws IOException {
        if (this.phase == 2) {
            Object key = OperationKey.newKey(dirName, name);
            this.log.put(key, new Operation(1, dirName, name, buf));
        } else {
            File file;
            if (dirName == null) {
                file = new File(this.dir, name);
            } else {
                File parentDir = new File(this.dir, dirName);
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                file = new File(parentDir, name);
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(buf);
            fos.close();
        }
    }

    public Object load(String name) throws IOException, ClassNotFoundException {
        return this.load(null, name);
    }

    public final Object load(String dirName, String name) throws IOException, ClassNotFoundException {
        Object obj;
        Object key;
        Operation op;
        if (this.phase == 2 && (op = (Operation)this.log.get(key = OperationKey.newKey(dirName, name))) != null) {
            if (op.type == 1) {
                ByteArrayInputStream bis = new ByteArrayInputStream(op.value);
                ObjectInputStream ois = new ObjectInputStream(bis);
                return ois.readObject();
            }
            if (op.type == 2) {
                return null;
            }
        }
        try {
            File file;
            if (dirName == null) {
                file = new File(this.dir, name);
            } else {
                File parentDir = new File(this.dir, dirName);
                file = new File(parentDir, name);
            }
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            obj = ois.readObject();
            fis.close();
        }
        catch (FileNotFoundException exc) {
            return null;
        }
        return obj;
    }

    public byte[] loadByteArray(String name) throws IOException {
        return this.loadByteArray(null, name);
    }

    public byte[] loadByteArray(String dirName, String name) throws IOException {
        Object key;
        Operation op;
        if (this.phase == 2 && (op = (Operation)this.log.get(key = OperationKey.newKey(dirName, name))) != null) {
            if (op.type == 1) {
                return op.value;
            }
            if (op.type == 2) {
                return null;
            }
        }
        try {
            int ret;
            File file;
            if (dirName == null) {
                file = new File(this.dir, name);
            } else {
                File parentDir = new File(this.dir, dirName);
                file = new File(parentDir, name);
            }
            FileInputStream fis = new FileInputStream(file);
            byte[] buf = new byte[(int)file.length()];
            for (int nb = 0; nb < buf.length; nb += ret) {
                ret = fis.read(buf, nb, buf.length - nb);
                if (ret != -1) continue;
                throw new EOFException();
            }
            fis.close();
            return buf;
        }
        catch (FileNotFoundException exc) {
            return null;
        }
    }

    public void delete(String name) {
        this.delete(null, name);
    }

    public final void delete(String dirName, String name) {
        if (this.phase == 2) {
            Object key = OperationKey.newKey(dirName, name);
            this.log.put(key, new Operation(2, dirName, name));
        } else if (dirName == null) {
            File file = new File(this.dir, name);
            file.delete();
        } else {
            File parentDir = new File(this.dir, dirName);
            File file = new File(parentDir, name);
            file.delete();
            this.deleteDir(parentDir);
        }
    }

    private void deleteDir(File dir) {
        String[] children = dir.list();
        if (children != null && children.length == 0) {
            dir.delete();
            if (dir.getAbsolutePath().length() > this.dir.getAbsolutePath().length()) {
                this.deleteDir(dir.getParentFile());
            }
        }
    }

    public synchronized void commit(boolean release) throws IOException {
        if (this.phase != 2) {
            throw new NotActiveException("Can not commit inexistent transaction.");
        }
        this.logFile.seek(4L);
        Enumeration e = this.log.elements();
        while (e.hasMoreElements()) {
            Operation op = (Operation)e.nextElement();
            this.logFile.writeUTF(op.name);
            if (op.dirName != null) {
                this.logFile.writeUTF(op.dirName);
            } else {
                this.logFile.writeUTF(EMPTY_STRING);
            }
            this.logFile.writeByte(op.type);
            if (op.type != 1) continue;
            this.logFile.writeInt(op.value.length);
            this.logFile.write(op.value);
        }
        this.logFile.writeUTF("");
        this.setPhase(3);
        this._commit();
        this.log.clear();
        if (release) {
            this.setPhase(1);
            this.notify();
        }
    }

    private void _commit() throws IOException {
        Enumeration e = this.log.elements();
        while (e.hasMoreElements()) {
            File parentDir;
            File file;
            Operation op = (Operation)e.nextElement();
            if (op.type == 1) {
                if (op.dirName == null) {
                    file = new File(this.dir, op.name);
                } else {
                    parentDir = new File(this.dir, op.dirName);
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    file = new File(parentDir, op.name);
                }
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(op.value);
                fos.getFD().sync();
                fos.close();
                continue;
            }
            if (op.type == 2) {
                if (op.dirName == null) {
                    file = new File(this.dir, op.name);
                    file.delete();
                    continue;
                }
                parentDir = new File(this.dir, op.dirName);
                file = new File(parentDir, op.name);
                file.delete();
                this.deleteDir(parentDir);
                continue;
            }
            throw new InvalidObjectException("Unknow object in log.");
        }
    }

    public synchronized void release() throws IOException {
        if (this.phase != 3 && this.phase != 4) {
            throw new NotActiveException("Can not release transaction.");
        }
        this.setPhase(1);
        this.notify();
    }

    public synchronized void stop() {
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final synchronized void close() {
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {}
        }
        try {
            this.setPhase(6);
            this.logFile.close();
            this.setPhase(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class OperationKey {
        private String dirName;
        private String name;

        static Object newKey(String dirName, String name) {
            if (dirName == null) {
                return name;
            }
            return new OperationKey(dirName, name);
        }

        private OperationKey(String dirName, String name) {
            this.dirName = dirName;
            this.name = name;
        }

        public int hashCode() {
            return this.dirName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OperationKey) {
                OperationKey opk = (OperationKey)obj;
                if (opk.name.length() != this.name.length()) {
                    return false;
                }
                if (opk.dirName.length() != this.dirName.length()) {
                    return false;
                }
                if (!opk.dirName.equals(this.dirName)) {
                    return false;
                }
                return opk.name.equals(this.name);
            }
            return false;
        }
    }

    class Operation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String dirName;
        String name;
        int type;
        byte[] value = null;

        Operation(int type, String dirName, String name) {
            this(type, dirName, name, null);
        }

        Operation(int type, String dirName, String name, byte[] value) {
            this.type = type;
            this.dirName = dirName;
            this.name = name;
            this.value = value;
        }
    }
}

