/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.jotm.JotmRecovery;
import org.objectweb.jotm.RecoverRmInfo;
import org.objectweb.jotm.RmRegistration;
import org.objectweb.jotm.StatusHelper;
import org.objectweb.jotm.TimerManager;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.TransactionRecovery;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.TxRecovered;
import org.objectweb.jotm.TxxidRecovered;
import org.objectweb.jotm.XATerminatorImpl;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;
import org.objectweb.transaction.jta.ResourceManagerEvent;
import org.objectweb.transaction.jta.TransactionManager;

public class Current
implements UserTransaction,
TransactionManager,
Referenceable,
Serializable {
    private static final long serialVersionUID = 67411825766929272L;
    private static transient ThreadLocal<TransactionImpl> threadTx = new ThreadLocal();
    private static transient ThreadLocal<Integer> threadTimeout = new ThreadLocal();
    private static transient ThreadLocal<Stack<List<ResourceManagerEvent>>> eventListStack = new ThreadLocal();
    private static transient Map<Xid, TransactionImpl> txXids = new HashMap<Xid, TransactionImpl>();
    private static transient Current unique = null;
    private static transient TimerManager timermgr = null;
    private static transient TransactionFactory tm = null;
    private static transient TransactionRecovery tr = null;
    private static final int DEFAULT_TIMEOUT = 60;
    private int defaultTimeout = 60;
    private static final boolean DEFAULT_RECOVERY = false;
    private static boolean transactionRecovery = false;
    private static boolean appServer = true;
    private transient int nb_bg_tx = 0;
    private transient int nb_rb_tx = 0;
    private transient int nb_cm_tx = 0;
    private transient int nb_to = 0;

    public Current() {
        unique = this;
        timermgr = TimerManager.getInstance();
        Current.transactionRecovery();
    }

    public Current(TransactionFactory tmfact) {
        unique = this;
        Current.setTMFactory(tmfact);
        timermgr = TimerManager.getInstance();
        Current.transactionRecovery();
    }

    public static void setTMFactory(TransactionFactory tmfact) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionFactory=" + tmfact);
        }
        tm = tmfact;
    }

    public static void transactionRecovery() {
        if (tr == null) {
            try {
                tr = new TransactionRecoveryImpl();
            }
            catch (Exception e) {
                Current.setDefaultRecovery(false);
                TraceTm.recovery.error("Cannot open Howl Log");
                TraceTm.recovery.error("JOTM Recovery is being disabled");
            }
        }
    }

    public static TransactionManager getTransactionManager() {
        return unique;
    }

    public void begin() throws NotSupportedException, SystemException {
        TransactionImpl tx = threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("begin transaction threadTx = " + threadTx.toString());
        }
        if (tx != null) {
            if (txXids.containsValue(tx)) {
                if (!this.txcanrollback(tx)) {
                    throw new NotSupportedException("Nested transactions not supported");
                }
            } else if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("Resetting current tx = " + tx + " since it is already completed.");
            }
        }
        Integer mytimeobj = threadTimeout.get();
        int transactionTimeout = this.defaultTimeout;
        if (mytimeobj != null) {
            if (mytimeobj == 0) {
                transactionTimeout = this.defaultTimeout;
            } else {
                transactionTimeout = mytimeobj;
                threadTimeout.set(0);
            }
        }
        XidImpl otid = new XidImpl();
        tx = new TransactionImpl(otid, transactionTimeout);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("new tx=" + tx);
        }
        try {
            tx.doAttach(0x200000);
        }
        catch (RollbackException e) {
            TraceTm.jotm.error("doAttach: RollbackException");
            throw new SystemException("RollbackException in occured in begin() " + e.getMessage());
        }
        threadTx.set(tx);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("threadTx.set= " + threadTx.toString());
        }
        this.putTxXid(otid, tx);
        if (timermgr != null) {
            tx.setTimer(timermgr.addTimer(tx, transactionTimeout, null, false));
        }
        tx.setTxDate(new Date());
        Stack<List<ResourceManagerEvent>> curStack = eventListStack.get();
        if (curStack != null) {
            try {
                List<ResourceManagerEvent> list = curStack.peek();
                if (list != null) {
                    Vector<ResourceManagerEvent> templist = new Vector<ResourceManagerEvent>(list);
                    for (ResourceManagerEvent event : templist) {
                        if (TraceTm.jta.isDebugEnabled()) {
                            TraceTm.jta.debug("Enlist open connection at begin");
                        }
                        event.enlistConnection(tx);
                    }
                }
            }
            catch (EmptyStackException e) {
                TraceTm.jta.debug("Current.begin called with empty stack");
            }
        }
    }

    public void begin(javax.transaction.xa.Xid passxid) throws NotSupportedException, SystemException {
        Integer mytimeobj = threadTimeout.get();
        if (mytimeobj == null || mytimeobj == 0) {
            this.begin(passxid, this.defaultTimeout);
        } else {
            this.begin(passxid, mytimeobj.intValue());
            threadTimeout.set(0);
        }
    }

    public void begin(javax.transaction.xa.Xid passxid, long timeout) throws NotSupportedException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("begin inflow transaction, timeout = " + timeout);
        }
        if (timeout <= 0L) {
            timeout = this.defaultTimeout;
        }
        TransactionImpl tx = threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("threadTx.get= " + threadTx.toString());
        }
        if (tx != null) {
            if (txXids.containsValue(tx) && !this.txcanrollback(tx)) {
                throw new NotSupportedException("Nested transactions not supported");
            }
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("Resetting current tx = " + tx + " since it is already completed.");
            }
        }
        XidImpl pxid = new XidImpl(passxid);
        tx = new TransactionImpl(pxid, (int)timeout);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("tx=" + tx);
        }
        threadTx.set(tx);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("threadTx.set= " + threadTx.toString());
        }
        this.putTxXid(pxid, tx);
        if (timermgr != null) {
            tx.setTimer(timermgr.addTimer(tx, (int)timeout, null, false));
        }
        tx.setTxDate(new Date());
    }

    public XATerminator getXATerminator() throws XAException {
        XATerminatorImpl xaterm;
        block2: {
            xaterm = null;
            try {
                xaterm = new XATerminatorImpl();
            }
            catch (XAException e) {
                if (!TraceTm.jta.isDebugEnabled()) break block2;
                TraceTm.jta.debug("Cannot create XATerminatorImpl" + e);
            }
        }
        return xaterm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("commit transaction ");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for commit");
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("tx=" + tx);
        }
        try {
            tx.commit();
        }
        finally {
            threadTx.set(null);
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.rollback()");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for rollback");
        }
        threadTx.set(null);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("threadTx.set= null");
        }
        tx.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.setRollbackOnly()");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for setRollbackOnly");
        }
        tx.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.getStatus()");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            return 6;
        }
        return tx.getStatus();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        TransactionImpl tx = threadTx.get();
        if (tx != null && txXids.containsValue(tx)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("Cannot reset transaction timeout, tx in execution");
            }
            return;
        }
        threadTimeout.set(timeout);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Resetting transaction timeout= " + timeout);
        }
    }

    public int getTransactionTimeout() {
        Integer mytimeobj = threadTimeout.get();
        if (mytimeobj == null || mytimeobj == 0) {
            return this.defaultTimeout;
        }
        return mytimeobj;
    }

    public void setTransactionRecovery(boolean recovery) throws SystemException {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("recovery=" + recovery);
        }
        transactionRecovery = recovery;
    }

    public Transaction getTransaction() throws SystemException {
        return threadTx.get();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (tobj == null) {
            TraceTm.jotm.error("resume: null arg.");
            throw new InvalidTransactionException("resume(null) is not valid");
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("resume transaction:" + tobj);
        }
        Transaction mytx = threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("mytx= " + mytx);
        }
        if (mytx != null) {
            if (mytx.equals(tobj)) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug("nothing to do");
                }
                return;
            }
            TraceTm.jotm.error("resume: already associated with another transaction.");
            throw new IllegalStateException("the thread is already associated with another transaction.");
        }
        if (!(tobj instanceof TransactionImpl)) {
            TraceTm.jotm.error("resume: non TransactionImpl arg.");
            throw new InvalidTransactionException("resume(" + tobj.getClass().getName() + ") is not valid");
        }
        TransactionImpl tx = (TransactionImpl)tobj;
        threadTx.set(tx);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("threadTx.set= " + threadTx.toString());
        }
        if (!appServer) {
            try {
                tx.doAttach(0x8000000);
            }
            catch (RollbackException e) {
                TraceTm.jotm.error("RollbackException occured in resume()");
                throw new SystemException("RollbackException in occured in resume() " + e.getMessage());
            }
        }
    }

    public Transaction suspend() throws SystemException {
        TransactionImpl tx = threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("suspend transaction = " + tx);
        }
        if (tx != null) {
            if (!appServer) {
                tx.doDetach(0x2000000);
            }
            threadTx.set(null);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("threadTx.set= null");
            }
        }
        return tx;
    }

    public void connectionOpened(ResourceManagerEvent event) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.connectionOpened " + this);
        }
        List<ResourceManagerEvent> list = null;
        Stack<List<ResourceManagerEvent>> curStack = eventListStack.get();
        if (curStack == null) {
            curStack = new Stack();
            eventListStack.set(curStack);
        } else {
            try {
                list = curStack.pop();
            }
            catch (EmptyStackException e) {
                // empty catch block
            }
        }
        if (list == null) {
            list = new Vector<ResourceManagerEvent>(1);
        }
        list.add(event);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("list.add(event) = " + event);
        }
        curStack.push(list);
    }

    public void connectionClosed(ResourceManagerEvent event) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.connectionClosed, remove");
        }
        this.removeFromCurrentStack(event);
    }

    public void connectionErrorOccured(ResourceManagerEvent event) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.connectionErrorOccured");
        }
        this.removeFromCurrentStack(event);
    }

    private void removeFromCurrentStack(ResourceManagerEvent event) {
        Stack<List<ResourceManagerEvent>> curStack = eventListStack.get();
        if (curStack == null) {
            return;
        }
        try {
            List<ResourceManagerEvent> list = curStack.peek();
            if (list != null) {
                list.remove(event);
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void pushThreadLocalRMEventList(List eventList) {
        Stack<List<ResourceManagerEvent>> curStack;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.pushThreadLocalRMEventList");
        }
        if ((curStack = eventListStack.get()) == null) {
            curStack = new Stack();
            eventListStack.set(curStack);
        }
        curStack.push(eventList);
    }

    public List popThreadLocalRMEventList() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.popThreadLocalRMEventList");
        }
        Stack<List<ResourceManagerEvent>> curStack = eventListStack.get();
        return curStack.pop();
    }

    public Reference getReference() throws NamingException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.getReference()");
        }
        Reference ref = new Reference(this.getClass().getName(), "org.objectweb.jotm.UserTransactionFactory", null);
        Integer i = threadTimeout.get();
        if (i == null || i == 0) {
            i = this.defaultTimeout;
        }
        ref.add(new StringRefAddr("jotm.timeout", i.toString()));
        return ref;
    }

    public static Current getCurrent() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.getCurrent unique= " + unique);
        }
        return unique;
    }

    public static TransactionFactory getJTM() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.getJTM tm= " + tm);
        }
        if (tm == null) {
            TraceTm.jotm.error("Current: TMFactory is null!");
        }
        return tm;
    }

    public static TransactionRecovery getTransactionRecovery() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Current.getTransactionRecovery tr= " + tr);
        }
        if (tr == null) {
            TraceTm.jotm.error("Current: Transaction Recovery is null!");
        }
        return tr;
    }

    public void setDefaultTimeout(int timeout) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("timeout= " + timeout);
        }
        if (timeout != 0) {
            this.defaultTimeout = timeout;
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("default timeout= " + this.defaultTimeout);
        }
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public static void setDefaultRecovery(boolean recovery) {
        TraceTm.recovery.info("Jotm Recovery= " + recovery);
        transactionRecovery = recovery;
    }

    public static boolean getDefaultRecovery() {
        return transactionRecovery;
    }

    public static void setAppServer(boolean appserver) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Application Server enabled= " + appserver);
        }
        appServer = appserver;
    }

    public static boolean getAppServer() {
        return appServer;
    }

    public void setPropagationContext(TransactionContext pctx, boolean isReply) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug("pctx=" + pctx + ", isReply=" + isReply);
        }
        if (pctx == null) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("detach tx");
            }
            TransactionImpl tx = threadTx.get();
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("threadTx.get= " + threadTx.toString());
            }
            if (tx != null) {
                if (tx.isRemovable()) {
                    this.forgetTx(tx.getXid());
                }
                threadTx.set(null);
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug("threadTx.set= null");
                }
            }
            return;
        }
        Xid xid = pctx.getXid();
        TransactionImpl tx = this.getTxXid(xid);
        if (tx == null) {
            if (!isReply) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug("new Tx");
                }
                tx = new TransactionImpl(pctx);
                this.putTxXid(xid, tx);
                tx.setTxDate(new Date());
            } else if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("unknown tx:" + xid);
            }
        } else if (isReply) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("updating Xid=" + xid);
            }
            tx.updatePropagationContext(pctx);
        } else if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("transaction already known:" + xid);
        }
        if (!isReply) {
            threadTx.set(tx);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("threadTx.set= " + threadTx.toString());
            }
        }
    }

    public TransactionContext getPropagationContext(boolean hold) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug("hold=" + hold);
        }
        try {
            TransactionImpl tx = (TransactionImpl)this.getTransaction();
            if (tx != null) {
                return tx.getPropagationContext(hold);
            }
        }
        catch (SystemException e) {
            TraceTm.jotm.error("getPropagationContext system exception:", e);
        }
        return null;
    }

    public void forgetTx(Xid xid) {
        TransactionImpl txCur = txXids.get(xid);
        if (txCur != null && txCur.equals(threadTx.get())) {
            threadTx.set(null);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("threadTx.set = null");
            }
        }
        this.removeTxXid(xid);
    }

    public TransactionImpl getTxByXid(Xid xid) {
        return txXids.get(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.transaction.xa.Xid[] getPreparedHeuristicXid() {
        if (txXids.size() == 0) {
            return null;
        }
        ArrayList<Xid> xidlist = new ArrayList<Xid>();
        Current current = this;
        synchronized (current) {
            for (Xid key : txXids.keySet()) {
                TransactionImpl tx = txXids.get(key);
                try {
                    if (tx.getStatus() != 2) continue;
                    xidlist.add(tx.getXid());
                }
                catch (SystemException e) {
                    TraceTm.jotm.error("getPreparedHeuristicsXid system exception:", e);
                }
            }
        }
        return xidlist.toArray(new Xid[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.transaction.xa.Xid[] getAllXid() {
        int xidCount = txXids.size();
        if (xidCount == 0) {
            return null;
        }
        ArrayList<Xid> xidlist = new ArrayList<Xid>();
        Current current = this;
        synchronized (current) {
            for (Xid key : txXids.keySet()) {
                xidlist.add(key);
            }
        }
        return (javax.transaction.xa.Xid[])xidlist.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllTx() {
        int txCount = txXids.size();
        if (txCount == 0) {
            return null;
        }
        ArrayList<String> txList = new ArrayList<String>();
        Current current = this;
        synchronized (current) {
            for (Xid key : txXids.keySet()) {
                String txStatusName;
                TransactionImpl mytx = txXids.get(key);
                try {
                    txStatusName = StatusHelper.getStatusName(mytx.getStatus());
                }
                catch (SystemException e) {
                    txStatusName = "No State Defined";
                }
                List txResourceList = mytx.getEnlistedXAResource();
                int txResourceCount = txResourceList.size();
                if (txResourceCount == 0) {
                    txList.add(mytx.getTxDate().toString() + "????" + mytx.toString() + "????" + "NO Resource Defined" + "????" + txStatusName);
                    continue;
                }
                for (int i = 0; i < txResourceCount; ++i) {
                    txList.add(mytx.getTxDate().toString() + "????" + mytx.toString() + "????" + txResourceList.get(i).toString() + "????" + txStatusName);
                }
            }
        }
        String[] myTxString = new String[txCount];
        for (int i = 0; i < txCount; ++i) {
            myTxString[i] = (String)txList.get(i);
        }
        return myTxString;
    }

    public String[] getAllRcTx() {
        if (tr == null) {
            TraceTm.recovery.debug("tr= null");
            return null;
        }
        JotmRecovery myjr = tr.getJotmRecovery();
        if (myjr == null) {
            return null;
        }
        Vector vTxRecovered = JotmRecovery.getTxRecovered();
        int txCount = vTxRecovered.size();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("txcount= " + txCount);
        }
        if (txCount == 0) {
            return null;
        }
        ArrayList<String> txList = new ArrayList<String>();
        for (int i = 0; i < txCount; ++i) {
            TxRecovered mytxRecovered = (TxRecovered)vTxRecovered.elementAt(i);
            XidImpl temptxxid = new XidImpl(mytxRecovered.gettxxid());
            txList.add(new String(mytxRecovered.gettxxid()) + "????" + ((Object)temptxxid).toString() + "????" + mytxRecovered.gettxdatetime() + "????" + mytxRecovered.getxidcount());
        }
        String[] myTxString = new String[txCount];
        for (int i = 0; i < txCount; ++i) {
            myTxString[i] = (String)txList.get(i);
        }
        return myTxString;
    }

    public String[] getAllXaTx(String stx) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("stx=" + stx);
        }
        if (tr == null) {
            TraceTm.recovery.debug("tr= null");
            return null;
        }
        JotmRecovery myjr = tr.getJotmRecovery();
        if (myjr == null) {
            return null;
        }
        TxRecovered txr = null;
        boolean mytxfound = false;
        Vector vTxRecovered = JotmRecovery.getTxRecovered();
        int txCount = vTxRecovered.size();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("txcount= " + txCount);
        }
        for (int i = 0; i < txCount; ++i) {
            txr = (TxRecovered)vTxRecovered.elementAt(i);
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("gettxxid= " + new String(txr.gettxxid()));
            }
            if (!new String(txr.gettxxid()).equals(stx)) continue;
            mytxfound = true;
            break;
        }
        if (!mytxfound) {
            return new String[0];
        }
        Vector vRecoverRmInfo = JotmRecovery.getRecoverRmInfo();
        int myxacount = txr.getxidcount();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("myxacount= " + myxacount);
        }
        ArrayList<String> xaList = new ArrayList<String>();
        for (int i = 0; i < myxacount; ++i) {
            String myxares;
            TxxidRecovered infoxid = txr.getRecoverTxXidInfo(i);
            if (infoxid == null) {
                xaList.add("NotFound????NotFound????NotFound????NotFound????NotFound");
                continue;
            }
            int rmiCount = vRecoverRmInfo.size();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("rmiCount= " + rmiCount);
            }
            String myrm = "NotFound";
            for (int j = 0; j < rmiCount; ++j) {
                RecoverRmInfo rmInfo = (RecoverRmInfo)vRecoverRmInfo.elementAt(j);
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug("getRecoverXaResName()= " + rmInfo.getRecoverXaResName());
                    TraceTm.recovery.debug("getRecoverxaresname()=" + infoxid.getRecoverxaresname());
                    TraceTm.recovery.debug("getRecoverXaRes()= " + new String(rmInfo.getRecoverXaRes()));
                    TraceTm.recovery.debug("getRecoverxares()=" + new String(infoxid.getRecoverxares()));
                }
                if (!rmInfo.getRecoverXaResName().equals(infoxid.getRecoverxaresname())) continue;
                myrm = rmInfo.getRecoverRm();
                myxares = new String(infoxid.getRecoverxares());
                if (!TraceTm.recovery.isDebugEnabled()) break;
                TraceTm.recovery.debug("myrm= " + myrm);
                TraceTm.recovery.debug("myxares= " + myxares);
                break;
            }
            Vector vRmRegistration = tr.getRmRegistration();
            myxares = "NotRegistered";
            if (vRmRegistration == null) {
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug("vRmRegistration is null");
                }
            } else {
                int rmregcount = vRmRegistration.size();
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug("rmregcount= " + rmregcount);
                }
                for (int j = 0; j < rmregcount; ++j) {
                    RmRegistration myRmRegistration = (RmRegistration)vRmRegistration.elementAt(j);
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug("myrm= " + myrm);
                        TraceTm.recovery.debug("rmGetName= " + myRmRegistration.rmGetName());
                    }
                    if (!myrm.equals(myRmRegistration.rmGetName())) continue;
                    if (myRmRegistration.rmGetXaRes() == null) {
                        myxares = "IsNull";
                        break;
                    }
                    myxares = myRmRegistration.rmGetXaRes().toString();
                    break;
                }
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug("myxares= " + myxares);
                }
            }
            XidImpl tempxid = new XidImpl(infoxid.getRecoverxid());
            xaList.add(myrm + "????" + myxares + "????" + infoxid.getRecoverxid() + "????" + ((Object)tempxid).toString() + "????" + StatusHelper.getStatusName(infoxid.getRecoverstatus()));
        }
        String[] myTxString = new String[myxacount];
        for (int i = 0; i < myxacount; ++i) {
            myTxString[i] = (String)xaList.get(i);
        }
        return myTxString;
    }

    public int actionXAResource(String xaAction, String xatx) {
        LinkedList<javax.transaction.xa.Xid> recoveredXidList;
        XAResource xaresource;
        String sFullXid;
        block19: {
            if (tr == null) {
                TraceTm.recovery.debug("tr= null");
                return 0;
            }
            JotmRecovery myjr = tr.getJotmRecovery();
            if (myjr == null) {
                return 0;
            }
            Vector vRmRegistration = tr.getRmRegistration();
            if (vRmRegistration == null) {
                return 0;
            }
            int myix1 = xatx.indexOf(10);
            String sResmgr = xatx.substring(0, myix1);
            int myix2 = xatx.indexOf(10, myix1 + 1);
            int myix3 = xatx.indexOf(10, myix2 + 1);
            sFullXid = xatx.substring(myix2 + 1, myix3);
            int rmregcount = vRmRegistration.size();
            xaresource = null;
            for (int i = 0; i < rmregcount; ++i) {
                RmRegistration myRmRegistration = (RmRegistration)vRmRegistration.elementAt(i);
                if (!sResmgr.equals(myRmRegistration.rmGetName())) continue;
                xaresource = myRmRegistration.rmGetXaRes();
                break;
            }
            if (xaresource == null) {
                TraceTm.recovery.error("xaResource is null");
                return 0;
            }
            recoveredXidList = new LinkedList<javax.transaction.xa.Xid>();
            try {
                javax.transaction.xa.Xid[] javaxids;
                boolean first = true;
                while ((javaxids = xaresource.recover(first ? 0x1000000 : 0)) != null && javaxids.length != 0) {
                    first = false;
                    recoveredXidList.addAll(Arrays.asList(javaxids));
                }
            }
            catch (XAException e) {
                if (!TraceTm.jta.isDebugEnabled()) break block19;
                TraceTm.recovery.debug("xaResource.recover call failed during recovery " + e.getMessage());
            }
        }
        if (recoveredXidList.size() == 0) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("No XIDs to recover for Xares= " + xaresource);
            }
            this.cleanuptxrecovery(sFullXid);
            return 0;
        }
        for (javax.transaction.xa.Xid recoveredXid : recoveredXidList) {
            if (!recoveredXid.toString().equals(sFullXid)) continue;
            if (xaAction.equals("commit")) {
                try {
                    xaresource.commit(recoveredXid, false);
                }
                catch (XAException e) {
                    TraceTm.recovery.error("Unable to commit Xid during Admin Recovery " + e.getMessage());
                }
                break;
            }
            if (xaAction.equals("rollback")) {
                try {
                    xaresource.rollback(recoveredXid);
                }
                catch (XAException e) {
                    TraceTm.recovery.error("Unable to rollback Xid during Admin Recovery " + e.getMessage());
                }
                break;
            }
            if (!xaAction.equals("forget")) break;
            try {
                xaresource.forget(recoveredXid);
            }
            catch (XAException e) {
                TraceTm.recovery.error("Unable to forget Xid during Admin Recovery " + e.getMessage());
            }
            break;
        }
        this.cleanuptxrecovery(sFullXid);
        return 0;
    }

    private void cleanuptxrecovery(String pFullXid) {
        boolean mytxxidrecoveredfound = false;
        byte[][] jotmDoneRecord = new byte[1][11];
        byte[] jotmDone = "RR3JOTMDONE".getBytes();
        Vector vTxRecovered = JotmRecovery.getTxRecovered();
        int txCount = vTxRecovered.size();
        for (int i = 0; i < txCount; ++i) {
            TxxidRecovered infoxid;
            TxRecovered txr = (TxRecovered)vTxRecovered.elementAt(i);
            int myxacount = txr.getxidcount();
            for (int j = 0; j < myxacount; ++j) {
                infoxid = txr.getRecoverTxXidInfo(j);
                if (infoxid == null || !pFullXid.equals(new String(infoxid.getRecoverxid()))) continue;
                infoxid.setRecoverstatus(3);
                mytxxidrecoveredfound = true;
                break;
            }
            boolean allcompleted = true;
            for (int j = 0; j < myxacount; ++j) {
                infoxid = txr.getRecoverTxXidInfo(j);
                if (infoxid.getRecoverstatus() == 3) continue;
                allcompleted = false;
                break;
            }
            if (allcompleted) {
                XACommittingTx xaCommitTx = txr.getXACommittingTx();
                jotmDoneRecord[0] = jotmDone;
                if (Current.getDefaultRecovery()) {
                    try {
                        if (TraceTm.recovery.isDebugEnabled()) {
                            TraceTm.recovery.debug("Done howl log, after admin action");
                        }
                        TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(jotmDoneRecord, xaCommitTx);
                    }
                    catch (Exception f) {
                        String howlerror = "Cannot howlDoneLog:" + f + "--" + f.getMessage();
                        TraceTm.jotm.error("Got LogException from howlDoneLog: " + howlerror);
                    }
                }
                vTxRecovered.remove(i);
                break;
            }
            if (mytxxidrecoveredfound) break;
        }
    }

    public void associateThreadTx(Xid xid) {
        TransactionImpl tx = this.getTxXid(xid);
        threadTx.set(tx);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("threadTx.set= " + threadTx.toString());
        }
    }

    public void clearThreadTx() {
        TransactionImpl tx = threadTx.get();
        if (tx != null) {
            threadTx.set(null);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug("threadTx.set=null");
            }
        }
    }

    private boolean txcanrollback(TransactionImpl tx) throws SystemException {
        switch (tx.getStatus()) {
            case 1: {
                tx.rollback();
                return true;
            }
        }
        return false;
    }

    private void putTxXid(Xid xid, TransactionImpl tx) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("Associate tx to xid (xid=" + xid + ")");
        }
        txXids.put(xid, tx);
    }

    private TransactionImpl getTxXid(Xid xid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("get tx from xid (xid=" + xid + ")");
        }
        return txXids.get(xid);
    }

    private void removeTxXid(Xid xid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("remove tx from xid (xid=" + xid + ")");
        }
        txXids.remove(xid);
    }

    void forget() {
        threadTx.set(null);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("threadTx.set= null");
        }
    }

    public int getTotalCurrentTransactions() {
        return txXids.size();
    }

    synchronized void incrementBeginCounter() {
        ++this.nb_bg_tx;
    }

    public int getTotalBegunTransactions() {
        return this.nb_bg_tx;
    }

    synchronized void incrementRollbackCounter() {
        ++this.nb_rb_tx;
    }

    public int getTotalRolledbackTransactions() {
        return this.nb_rb_tx;
    }

    synchronized void incrementCommitCounter() {
        ++this.nb_cm_tx;
    }

    public int getTotalCommittedTransactions() {
        return this.nb_cm_tx;
    }

    public synchronized void resetAllTxTotalCounters() {
        this.nb_bg_tx = 0;
        this.nb_cm_tx = 0;
        this.nb_rb_tx = 0;
        this.nb_to = 0;
    }

    synchronized void incrementExpiredCounter() {
        ++this.nb_to;
    }

    public int getTotalExpiredTransactions() {
        return this.nb_to;
    }

    public synchronized Integer[] getTransactionCounters() {
        Integer[] result = new Integer[]{txXids.size(), this.nb_bg_tx, this.nb_cm_tx, this.nb_rb_tx, this.nb_to};
        return result;
    }
}

