/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.NetSessionWrapper;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.PoolNetworkMBean;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.StreamNetwork;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.util.Daemon;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class PoolNetwork
extends StreamNetwork
implements PoolNetworkMBean {
    WakeOnConnection wakeOnConnection = null;
    NetSession[] sessions = null;
    Dispatcher dispatcher = null;
    WatchDog watchDog = null;
    int nbMaxCnx;
    int nbActiveCnx = 0;
    NetSession[] activeSessions;
    long current = 0L;

    public void init(String name, int port, short[] servers) throws Exception {
        super.init(name, port, servers);
        this.sessions = new NetSession[servers.length];
        for (int i = 0; i < this.sessions.length; ++i) {
            if (servers[i] == AgentServer.getServerId()) continue;
            this.sessions[i] = new NetSession(this.getName(), servers[i]);
        }
        this.wakeOnConnection = new WakeOnConnection(this.getName(), this.logmon);
        this.dispatcher = new Dispatcher(this.getName(), this.logmon);
        this.watchDog = new WatchDog(this.getName(), this.logmon);
    }

    synchronized void addServer(short id) throws Exception {
        int i;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer strbuf = new StringBuffer();
            for (i = 0; i < this.servers.length; ++i) {
                strbuf.append("\n\t").append(this.sessions[i]);
            }
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " before addServer:" + strbuf.toString()));
        }
        try {
            super.addServer(id);
            if (this.sessions.length == this.servers.length) {
                return;
            }
            NetSession[] newSessions = new NetSession[this.servers.length];
            for (i = 0; i < this.sessions.length; ++i) {
                if (this.sessions[i] == null || this.sessions[i].sid == AgentServer.getServerId()) continue;
                newSessions[this.index((short)((NetSession)this.sessions[i]).sid)] = this.sessions[i];
                this.sessions[i] = null;
            }
            this.sessions = newSessions;
            int idx = this.index(id);
            this.sessions[idx] = new NetSession(this.getName(), id);
            this.sessions[idx].init();
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                StringBuffer strbuf = new StringBuffer();
                for (int i2 = 0; i2 < this.servers.length; ++i2) {
                    strbuf.append("\t").append(this.sessions[i2]).append("\n");
                }
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " after addServer:" + strbuf.toString()));
            }
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + " addServer failed"), (Throwable)exc);
        }
        this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + " addServer ok"), (Throwable)new Exception());
    }

    synchronized void delServer(short id) throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer strbuf = new StringBuffer();
            for (int i = 0; i < this.servers.length; ++i) {
                strbuf.append("\t").append(this.sessions[i]).append("\n");
            }
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + strbuf.toString()));
        }
        try {
            super.delServer(id);
            NetSession[] newSessions = new NetSession[this.servers.length];
            int j = 0;
            for (int i = 0; i < this.servers.length; ++i) {
                if (this.sessions[i] == null) {
                    ++j;
                    continue;
                }
                if (this.sessions[i].sid == id) continue;
                newSessions[j++] = this.sessions[i];
                this.sessions[i] = null;
            }
            this.sessions = newSessions;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                StringBuffer strbuf = new StringBuffer();
                for (int i = 0; i < this.servers.length; ++i) {
                    strbuf.append("\t").append(this.sessions[i]).append("\n");
                }
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + strbuf.toString()));
            }
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + " delServer failed"), (Throwable)exc);
        }
        this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + " delServer ok"), (Throwable)new Exception());
    }

    private String getMBeanName(short sid) {
        return "server=" + AgentServer.getName() + ",cons=" + this.name + ",session=netSession#" + sid;
    }

    public void start() throws Exception {
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", starting"));
        try {
            this.nbMaxCnx = AgentServer.getInteger(this.getName() + ".nbMaxCnx");
        }
        catch (Exception exc) {
            try {
                this.nbMaxCnx = AgentServer.getInteger("PoolNetwork.nbMaxCnx");
            }
            catch (Exception exc2) {
                this.nbMaxCnx = 5;
            }
        }
        try {
            if (this.isRunning()) {
                throw new IOException("Consumer already running.");
            }
            for (int i = 0; i < this.sessions.length; ++i) {
                if (this.sessions[i] == null) continue;
                this.sessions[i].init();
                try {
                    MXWrapper.registerMBean((Object)new NetSessionWrapper(this, this.servers[i]), (String)"AgentServer", (String)this.getMBeanName(this.servers[i]));
                    continue;
                }
                catch (Exception exc) {
                    this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + " jmx failed"), (Throwable)exc);
                }
            }
            this.activeSessions = new NetSession[this.nbMaxCnx];
            this.wakeOnConnection.start();
            this.dispatcher.start();
            this.watchDog.start();
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't start"), (Throwable)exc);
            throw exc;
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", started"));
    }

    public void wakeup() {
        if (this.watchDog != null) {
            this.watchDog.wakeup();
        }
    }

    public void stop() {
        int i;
        if (this.wakeOnConnection != null) {
            this.wakeOnConnection.stop();
        }
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        if (this.watchDog != null) {
            this.watchDog.stop();
        }
        for (i = 0; i < this.activeSessions.length; ++i) {
            if (this.activeSessions[i] != null) {
                this.activeSessions[i].stop();
            }
            this.activeSessions[i] = null;
        }
        this.nbActiveCnx = 0;
        for (i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            try {
                MXWrapper.unregisterMBean((String)"AgentServer", (String)this.getMBeanName(this.sessions[i].sid));
                continue;
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + " jmx failed"), (Throwable)exc);
            }
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stopped"));
    }

    public boolean isRunning() {
        return this.wakeOnConnection != null && this.wakeOnConnection.isRunning() && this.dispatcher != null && this.dispatcher.isRunning() && this.watchDog != null && this.watchDog.isRunning();
    }

    final NetSession getSession(short sid) {
        return this.sessions[this.index(sid)];
    }

    public int getNbMaxActiveSession() {
        return this.nbMaxCnx;
    }

    public int getNbActiveSession() {
        return this.nbActiveCnx;
    }

    final boolean isSessionRunning(short sid) {
        return this.sessions[this.index(sid)].isRunning();
    }

    final int getSessionNbWaitingMessages(short sid) {
        return this.sessions[this.index(sid)].getNbWaitingMessages();
    }

    final int getNbMessageSent(short sid) {
        return this.sessions[this.index(sid)].getNbMessageSent();
    }

    final int getNbMessageReceived(short sid) {
        return this.sessions[this.index(sid)].getNbMessageReceived();
    }

    final int getNbAckSent(short sid) {
        return this.sessions[this.index(sid)].getNbAckSent();
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(super.toString()).append("\n\t");
        if (this.wakeOnConnection != null) {
            strbuf.append(this.wakeOnConnection.toString()).append("\n\t");
        }
        if (this.dispatcher != null) {
            strbuf.append(this.dispatcher.toString()).append("\n\t");
        }
        if (this.watchDog != null) {
            strbuf.append(this.watchDog.toString()).append("\n\t");
        }
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            strbuf.append(this.sessions[i].toString()).append("\n\t");
        }
        return strbuf.toString();
    }

    final void writeBoot(OutputStream out) throws IOException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", writeBoot: " + this.getBootTS()));
        }
        byte[] iobuf = new byte[]{(byte)(AgentServer.getServerId() >>> 8), (byte)(AgentServer.getServerId() >>> 0), (byte)(this.getBootTS() >>> 24), (byte)(this.getBootTS() >>> 16), (byte)(this.getBootTS() >>> 8), (byte)(this.getBootTS() >>> 0)};
        out.write(iobuf);
        out.flush();
    }

    final void readFully(InputStream is, byte[] iobuf) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = is.read(iobuf, n, iobuf.length - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < iobuf.length);
    }

    final Boot readBoot(InputStream in) throws IOException {
        Boot boot = new Boot();
        byte[] iobuf = new byte[6];
        this.readFully(in, iobuf);
        boot.sid = (short)(((iobuf[0] & 0xFF) << 8) + (iobuf[1] & 0xFF));
        boot.boot = ((iobuf[2] & 0xFF) << 24) + ((iobuf[3] & 0xFF) << 16) + ((iobuf[4] & 0xFF) << 8) + ((iobuf[5] & 0xFF) << 0);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", readBoot from #" + boot.sid + " -> " + boot.boot));
        }
        return boot;
    }

    final void writeAck(OutputStream out) throws IOException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", writeAck: " + this.getBootTS()));
        }
        byte[] iobuf = new byte[]{(byte)(this.getBootTS() >>> 24), (byte)(this.getBootTS() >>> 16), (byte)(this.getBootTS() >>> 8), (byte)(this.getBootTS() >>> 0)};
        out.write(iobuf);
        out.flush();
    }

    final int readAck(InputStream in) throws IOException {
        byte[] iobuf = new byte[4];
        this.readFully(in, iobuf);
        int boot = ((iobuf[0] & 0xFF) << 24) + ((iobuf[1] & 0xFF) << 16) + ((iobuf[2] & 0xFF) << 8) + ((iobuf[3] & 0xFF) << 0);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", readAck:" + boot));
        }
        return boot;
    }

    final class Boot {
        transient short sid;
        transient int boot;

        Boot() {
        }
    }

    final class NetSession
    implements Runnable {
        private short sid;
        private volatile boolean running = false;
        private boolean canStop = false;
        private Thread thread = null;
        private String name = null;
        private boolean local = false;
        private ServerDesc server;
        private Socket sock = null;
        MessageInputStream nis = null;
        MessageOutputStream nos = null;
        private MessageVector sendList;
        private long last = 0L;
        int nbMessageSent = 0;
        int nbMessageReceived = 0;
        int nbAckSent = 0;

        public String toString() {
            return this.toString(new StringBuffer()).toString();
        }

        public StringBuffer toString(StringBuffer strbuf) {
            strbuf.append("[sid=").append(this.sid);
            strbuf.append(",running=").append(this.running);
            strbuf.append(",name=").append(this.name).append("]");
            return strbuf;
        }

        NetSession(String name, short sid) {
            this.sid = sid;
            this.name = name + ".netSession#" + sid;
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", created"));
            }
            this.running = false;
            this.canStop = false;
            this.thread = null;
            this.sendList = new MessageVector();
        }

        void init() throws UnknownServerException {
            this.server = AgentServer.getServerDesc(this.sid);
        }

        public final String getName() {
            return this.name;
        }

        public short getRemoteSID() {
            return this.sid;
        }

        public boolean isRunning() {
            return this.running;
        }

        int getNbWaitingMessages() {
            return this.sendList.size();
        }

        int getNbMessageSent() {
            return this.nbMessageSent;
        }

        int getNbMessageReceived() {
            return this.nbMessageReceived;
        }

        int getNbAckSent() {
            return this.nbAckSent;
        }

        void start() {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", started"));
            }
            long currentTimeMillis = System.currentTimeMillis();
            if (this.server.retry < PoolNetwork.this.WDNbRetryLevel1 && this.server.last + PoolNetwork.this.WDRetryPeriod1 < currentTimeMillis || this.server.retry < PoolNetwork.this.WDNbRetryLevel2 && this.server.last + PoolNetwork.this.WDRetryPeriod2 < currentTimeMillis || this.server.last + PoolNetwork.this.WDRetryPeriod3 < currentTimeMillis) {
                if (this.localStart()) {
                    this.startEnd();
                } else {
                    this.server.last = currentTimeMillis;
                    ++this.server.retry;
                }
            }
        }

        void start(Socket sock, int boot) {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", remotely started"));
            }
            if (this.remoteStart(sock, boot)) {
                this.startEnd();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean localStart() {
            NetSession netSession = this;
            synchronized (netSession) {
                if (this.sock != null || this.local) {
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                        PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused"));
                    }
                    return false;
                }
                this.local = true;
            }
            Socket sock = null;
            try {
                sock = PoolNetwork.this.createSocket(this.server);
                PoolNetwork.this.setSocketOption(sock);
                PoolNetwork.this.writeBoot(sock.getOutputStream());
                int boot = PoolNetwork.this.readAck(sock.getInputStream());
                AgentServer.getTransaction().begin();
                PoolNetwork.this.testBootTS(this.sid, boot);
                AgentServer.getTransaction().commit(true);
                this.nis = new MessageInputStream(sock.getInputStream());
                this.nos = new MessageOutputStream(sock.getOutputStream());
            }
            catch (Exception exc) {
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused."), (Throwable)exc);
                }
                try {
                    sock.getOutputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.getInputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.local = false;
                this.nis = null;
                this.nos = null;
                return false;
            }
            this.sock = sock;
            this.local = false;
            return true;
        }

        synchronized boolean remoteStart(Socket sock, int boot) {
            try {
                if (this.sock != null || this.local && this.server.sid > AgentServer.getServerId()) {
                    throw new ConnectException("Already connected");
                }
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send AckStatus"));
                }
                PoolNetwork.this.writeAck(sock.getOutputStream());
                AgentServer.getTransaction().begin();
                PoolNetwork.this.testBootTS(this.sid, boot);
                AgentServer.getTransaction().commit(true);
                this.nis = new MessageInputStream(sock.getInputStream());
                this.nos = new MessageOutputStream(sock.getOutputStream());
                this.sock = sock;
                return true;
            }
            catch (Exception exc) {
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.WARN)) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused"), (Throwable)exc);
                }
                try {
                    sock.getOutputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.getInputStream().close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                try {
                    sock.close();
                }
                catch (Exception exc2) {
                    // empty catch block
                }
                this.nis = null;
                this.nos = null;
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startEnd() {
            this.server.active = true;
            this.server.retry = 0;
            NetSession[] netSessionArray = PoolNetwork.this.activeSessions;
            synchronized (PoolNetwork.this.activeSessions) {
                int i;
                if (PoolNetwork.this.nbActiveCnx < PoolNetwork.this.nbMaxCnx) {
                    PoolNetwork.this.activeSessions[PoolNetwork.this.nbActiveCnx++] = this;
                } else {
                    long min = Long.MAX_VALUE;
                    int idx = -1;
                    for (i = 0; i < PoolNetwork.this.nbMaxCnx; ++i) {
                        if (PoolNetwork.this.activeSessions[i].last >= min) continue;
                        idx = i;
                        min = PoolNetwork.this.activeSessions[i].last;
                    }
                    PoolNetwork.this.activeSessions[idx].stop();
                    PoolNetwork.this.activeSessions[idx] = this;
                }
                this.last = PoolNetwork.this.current++;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.thread = new Thread((Runnable)this, this.getName());
                this.thread.setDaemon(false);
                this.running = true;
                this.canStop = true;
                this.thread.start();
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection started"));
                }
                Object[] waiting = this.sendList.toArray();
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send " + waiting.length + " waiting messages"));
                Message msg = null;
                long currentTimeMillis = System.currentTimeMillis();
                for (i = 0; i < waiting.length; ++i) {
                    msg = (Message)waiting[i];
                    if (msg.not != null && msg.not.expiration > 0L && msg.not.expiration < currentTimeMillis) {
                        try {
                            ExpiredNot expiredNot = null;
                            if (msg.not.deadNotificationAgentId != null) {
                                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": forward expired notification " + msg.from + ", " + msg.not + " to " + msg.not.deadNotificationAgentId));
                                }
                                expiredNot = new ExpiredNot(msg.not);
                            } else if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": removes expired notification " + msg.from + ", " + msg.not));
                            }
                            this.doAck(msg.getStamp(), expiredNot);
                        }
                        catch (Exception exc) {
                            PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ": cannot remove expired notification " + msg.from + ", " + msg.not), (Throwable)exc);
                        }
                        continue;
                    }
                    this.transmit(msg, currentTimeMillis);
                }
                return;
            }
        }

        void stop() {
            this.running = false;
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stopped."));
            }
            while (this.thread != null && this.thread.isAlive()) {
                if (this.canStop) {
                    if (this.thread.isAlive()) {
                        this.thread.interrupt();
                    }
                    this.shutdown();
                }
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException exc) {
                    continue;
                }
                this.thread = null;
            }
        }

        public void shutdown() {
            this.close();
        }

        synchronized void close() {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", closed."));
            }
            try {
                this.sock.getInputStream().close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                this.sock.getOutputStream().close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sock = null;
            this.nis = null;
            this.nos = null;
        }

        private final void doAck(int ack, ExpiredNot expiredNot) throws Exception {
            Message msg = null;
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ack received #" + ack));
            }
            try {
                msg = this.sendList.removeMessage(ack);
                AgentServer.getTransaction().begin();
                if (expiredNot != null) {
                    Channel.post(Message.alloc(AgentId.localId, msg.not.deadNotificationAgentId, expiredNot));
                    Channel.validate();
                }
                msg.delete();
                msg.free();
                AgentServer.getTransaction().commit(true);
                if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", remove msg#" + msg.getStamp()));
                }
            }
            catch (NoSuchElementException exc) {
                PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", can't ack, unknown msg#" + ack));
            }
        }

        final void send(Message msg) {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                if (msg.not != null) {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send msg#" + msg.getStamp()));
                } else {
                    PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send ack#" + msg.getStamp()));
                }
            }
            long currentTimeMillis = System.currentTimeMillis();
            if (msg.not != null) {
                ++this.nbMessageSent;
                this.sendList.addElement(msg);
                if (msg.not.expiration > 0L && msg.not.expiration < currentTimeMillis) {
                    try {
                        ExpiredNot expiredNot = null;
                        if (msg.not.deadNotificationAgentId != null) {
                            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": forward expired notification " + msg.from + ", " + msg.not + " to " + msg.not.deadNotificationAgentId));
                            }
                            expiredNot = new ExpiredNot(msg.not);
                        } else if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": removes expired notification " + msg.from + ", " + msg.not));
                        }
                        this.doAck(msg.getStamp(), expiredNot);
                    }
                    catch (Exception exc) {
                        PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ": cannot removes expired notification " + msg.from + ", " + msg.not), (Throwable)exc);
                    }
                }
            } else {
                ++this.nbAckSent;
            }
            if (this.sock == null) {
                this.start();
            } else {
                this.transmit(msg, currentTimeMillis);
            }
        }

        private final void ack(int stamp) throws Exception {
            if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", set ack msg#" + stamp));
            }
            Message ack = Message.alloc(AgentId.localId, AgentId.localId(this.server.sid), null);
            ack.source = AgentServer.getServerId();
            ack.dest = AgentServer.getServerDesc((short)this.server.sid).gateway;
            ack.stamp = stamp;
            PoolNetwork.this.qout.push(ack);
            PoolNetwork.this.qout.validate();
        }

        private final synchronized void transmit(Message msg, long currentTimeMillis) {
            this.last = PoolNetwork.this.current++;
            try {
                this.nos.writeMessage(msg, currentTimeMillis);
            }
            catch (IOException exc) {
                PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", exception in sending message"), (Throwable)exc);
                this.close();
            }
            catch (NullPointerException exc) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    Message msg;
                    this.canStop = true;
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting message"));
                    }
                    try {
                        msg = this.nis.readMessage();
                    }
                    catch (ClassNotFoundException exc) {
                        PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                        continue;
                    }
                    catch (InvalidClassException exc) {
                        PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                        continue;
                    }
                    catch (StreamCorruptedException exc) {
                        PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                        break;
                    }
                    catch (OptionalDataException exc) {
                        PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting message"), (Throwable)exc);
                        break;
                    }
                    catch (NullPointerException exc) {
                        break;
                    }
                    this.canStop = false;
                    if (PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", receives: " + msg));
                    }
                    int stamp = msg.getStamp();
                    if (msg.not != null) {
                        ++this.nbMessageReceived;
                        PoolNetwork.this.deliver(msg);
                        this.ack(stamp);
                    } else {
                        this.doAck(stamp, null);
                    }
                    Thread.yield();
                }
            }
            catch (EOFException exc) {
                if (this.running) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection closed"), (Throwable)exc);
                }
            }
            catch (SocketException exc) {
                if (this.running) {
                    PoolNetwork.this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection closed"), (Throwable)exc);
                }
            }
            catch (Exception exc) {
                PoolNetwork.this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", exited"), (Throwable)exc);
            }
            finally {
                PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ends"));
                this.running = false;
                this.close();
            }
        }

        final class MessageOutputStream
        extends ByteArrayOutputStream {
            private OutputStream os;
            private ObjectOutputStream oos;

            MessageOutputStream(OutputStream os) throws IOException {
                super(256);
                this.os = null;
                this.oos = null;
                this.os = os;
                this.oos = new ObjectOutputStream(this);
                this.count = 0;
                this.buf[29] = -84;
                this.buf[30] = -19;
                this.buf[31] = 0;
                this.buf[32] = 5;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void writeMessage(Message msg, long currentTimeMillis) throws IOException {
                ((NetSession)NetSession.this).PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(NetSession.this.getName() + ", sends " + msg));
                int idx = msg.writeToBuf(this.buf, 4);
                this.count = 28;
                try {
                    if (msg.not != null) {
                        this.buf[idx++] = (byte)((msg.not.persistent ? 1 : 0) | (msg.not.detachable ? 16 : 0));
                        this.count = 33;
                        if (msg.not.expiration > 0L) {
                            msg.not.expiration -= currentTimeMillis;
                        }
                        this.oos.writeObject(msg.not);
                        this.oos.reset();
                        this.oos.flush();
                    }
                    this.buf[0] = (byte)(this.count >>> 24);
                    this.buf[1] = (byte)(this.count >>> 16);
                    this.buf[2] = (byte)(this.count >>> 8);
                    this.buf[3] = (byte)(this.count >>> 0);
                    this.os.write(this.buf, 0, this.count);
                    this.os.flush();
                }
                finally {
                    if (msg.not != null && msg.not.expiration > 0L) {
                        msg.not.expiration += currentTimeMillis;
                    }
                    this.count = 0;
                }
            }
        }

        final class MessageInputStream
        extends ByteArrayInputStream {
            private InputStream is;

            MessageInputStream(InputStream is) {
                super(new byte[256]);
                this.is = null;
                this.is = is;
            }

            private void readFully(int length) throws IOException {
                this.count = 0;
                if (length > this.buf.length) {
                    this.buf = new byte[length];
                }
                int nb = -1;
                do {
                    nb = this.is.read(this.buf, this.count, length - this.count);
                    if (((NetSession)NetSession.this).PoolNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        ((NetSession)NetSession.this).PoolNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(NetSession.this.getName() + ", reads:" + nb));
                    }
                    if (nb < 0) {
                        throw new EOFException();
                    }
                    this.count += nb;
                } while (this.count != length);
                this.pos = 0;
            }

            Message readMessage() throws Exception {
                this.count = 0;
                this.readFully(28);
                int length = ((this.buf[0] & 0xFF) << 24) + ((this.buf[1] & 0xFF) << 16) + ((this.buf[2] & 0xFF) << 8) + ((this.buf[3] & 0xFF) << 0);
                Message msg = Message.alloc();
                int idx = msg.readFromBuf(this.buf, 4);
                if (length > idx) {
                    this.readFully(length - idx);
                    boolean persistent = (this.buf[0] & 1) != 0;
                    boolean detachable = (this.buf[0] & 0x10) != 0;
                    this.pos = 1;
                    ObjectInputStream ois = new ObjectInputStream(this);
                    msg.not = (Notification)ois.readObject();
                    if (msg.not.expiration > 0L) {
                        msg.not.expiration += System.currentTimeMillis();
                    }
                    msg.not.persistent = persistent;
                    msg.not.detachable = detachable;
                    msg.not.detached = false;
                } else {
                    msg.not = null;
                }
                return msg;
            }
        }
    }

    final class WatchDog
    extends Daemon {
        private Object lock;

        WatchDog(String name, Logger logmon) {
            super(name + ".watchdog");
            this.lock = new Object();
            this.logmon = logmon;
        }

        protected void close() {
        }

        protected void shutdown() {
            this.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeup() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (this.running) {
                        block10: {
                            try {
                                this.lock.wait(PoolNetwork.this.WDActivationPeriod);
                                if (!this.logmon.isLoggable(BasicLevel.DEBUG)) break block10;
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", activated"));
                            }
                            catch (InterruptedException exc) {
                                continue;
                            }
                        }
                        if (!this.running) break;
                        for (int sid = 0; sid < PoolNetwork.this.sessions.length; ++sid) {
                            if (PoolNetwork.this.sessions[sid] == null || PoolNetwork.this.sessions[sid].sendList.size() <= 0 || PoolNetwork.this.sessions[sid].running) continue;
                            PoolNetwork.this.sessions[sid].start();
                        }
                    }
                }
            }
            finally {
                this.finish();
            }
        }
    }

    final class Dispatcher
    extends Daemon {
        Dispatcher(String name, Logger logmon) {
            super(name + ".dispatcher");
            this.logmon = logmon;
        }

        protected void close() {
        }

        protected void shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Message msg = null;
            try {
                while (this.running) {
                    this.canStop = true;
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting message"));
                    }
                    try {
                        msg = PoolNetwork.this.qout.get();
                    }
                    catch (InterruptedException exc) {
                        continue;
                    }
                    this.canStop = false;
                    if (!this.running) {
                        break;
                    }
                    PoolNetwork.this.getSession(msg.getDest()).send(msg);
                    PoolNetwork.this.qout.pop();
                    Thread.yield();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    final class WakeOnConnection
    extends Daemon {
        ServerSocket listen;

        WakeOnConnection(String name, Logger logmon) throws IOException {
            super(name + ".wakeOnConnection");
            this.listen = null;
            this.listen = PoolNetwork.this.createServerSocket();
            this.logmon = logmon;
        }

        protected void close() {
            try {
                this.listen.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listen = null;
        }

        protected void shutdown() {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket sock = null;
            try {
                if (this.listen == null) {
                    this.listen = PoolNetwork.this.createServerSocket();
                }
                while (this.running) {
                    try {
                        this.canStop = true;
                        try {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting connection"));
                            }
                            sock = this.listen.accept();
                        }
                        catch (IOException exc) {
                            if (!this.running) continue;
                            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during waiting connection"), (Throwable)exc);
                            continue;
                        }
                        this.canStop = false;
                        PoolNetwork.this.setSocketOption(sock);
                        Boot boot = PoolNetwork.this.readBoot(sock.getInputStream());
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection setup from #" + boot.sid));
                        }
                        PoolNetwork.this.getSession(boot.sid).start(sock, boot.boot);
                    }
                    catch (Exception exc) {
                        this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", bad connection setup"), (Throwable)exc);
                    }
                }
            }
            catch (IOException exc) {
                this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", bad socket initialisation"), (Throwable)exc);
            }
            finally {
                this.finish();
            }
        }
    }

    final class MessageVector
    extends Vector {
        private static final long serialVersionUID = 1L;

        MessageVector() {
        }

        public synchronized Message removeMessage(int stamp) {
            Message msg = null;
            ++this.modCount;
            for (int index = 0; index < this.elementCount; ++index) {
                try {
                    msg = (Message)this.elementData[index];
                }
                catch (ClassCastException exc) {
                    continue;
                }
                if (msg.getStamp() != stamp) continue;
                int j = this.elementCount - index - 1;
                if (j > 0) {
                    System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
                }
                --this.elementCount;
                this.elementData[this.elementCount] = null;
                return msg;
            }
            throw new NoSuchElementException();
        }
    }
}

