/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.conf.Default;
import org.jacorb.notification.engine.AbstractRetryStrategy;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutor;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.engine.RetryStrategyFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.IProxyPushSupplier;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ORB;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.PortableServer.POA;
import org.picocontainer.defaults.DefaultPicoContainer;

public abstract class AbstractProxyPushSupplier
extends AbstractProxySupplier
implements IProxyPushSupplier {
    private static final String NOTIFY_PUSH_FAILED = "notification.proxy.push_failed";
    private final AtomicReference retryStrategyFactory_;
    private final AtomicBoolean enabled_ = new AtomicBoolean(true);
    private final PushTaskExecutor pushTaskExecutor_;
    private final AtomicInteger pushCounter_ = new AtomicInteger(0);
    private final AtomicInteger pushErrors_ = new AtomicInteger(0);
    private final PushTaskExecutor.PushTask pushTask_ = new PushTaskExecutor.PushTask(){

        public void doPush() {
            AbstractProxyPushSupplier.this.pushPendingData();
        }

        public void cancel() {
        }
    };
    static /* synthetic */ Class class$org$jacorb$notification$engine$TaskProcessor;
    static /* synthetic */ Class class$org$jacorb$notification$engine$RetryStrategyFactory;

    public AbstractProxyPushSupplier(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(iAdmin, oRB, pOA, configuration, taskProcessor, offerManager, subscriptionManager, consumerAdmin);
        this.pushTaskExecutor_ = pushTaskExecutorFactory.newExecutor(this);
        this.retryStrategyFactory_ = new AtomicReference((Object)this.newRetryStrategyFactory(configuration, taskProcessor));
        this.eventTypes_.add(NOTIFY_PUSH_FAILED);
    }

    protected void handleFailedPushOperation(PushOperation pushOperation, Exception exception) {
        if (this.isDestroyed()) {
            pushOperation.dispose();
            return;
        }
        this.sendNotification(NOTIFY_PUSH_FAILED, "Push Operation failed");
        this.pushErrors_.getAndIncrement();
        this.incErrorCounter();
        if (AbstractRetryStrategy.isFatalException(exception)) {
            if (this.logger_.isErrorEnabled()) {
                this.logger_.error("push raised " + exception + ": will destroy ProxySupplier, " + "disconnect Consumer", (Throwable)exception);
            }
            pushOperation.dispose();
            this.destroy();
        } else if (!this.isRetryAllowed()) {
            pushOperation.dispose();
            this.destroy();
        } else if (!this.isDestroyed()) {
            RetryStrategy retryStrategy = this.newRetryStrategy(this, pushOperation);
            try {
                retryStrategy.retry();
            }
            catch (RetryException retryException) {
                this.logger_.error("retry failed", (Throwable)retryException);
                retryStrategy.dispose();
                this.destroy();
            }
        } else {
            throw new IllegalStateException("should not happen");
        }
    }

    private RetryStrategy newRetryStrategy(IProxyPushSupplier iProxyPushSupplier, PushOperation pushOperation) {
        return ((RetryStrategyFactory)this.retryStrategyFactory_.get()).newRetryStrategy(iProxyPushSupplier, pushOperation);
    }

    private RetryStrategyFactory newRetryStrategyFactory(Configuration configuration, TaskProcessor taskProcessor) throws ConfigurationException {
        String string = configuration.getAttribute("jacorb.notification.proxysupplier.retrystrategy_factory", Default.DEFAULT_RETRY_STRATEGY_FACTORY);
        try {
            return this.newRetryStrategyFactory(configuration, taskProcessor, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException("jacorb.notification.proxysupplier.retrystrategy_factory", (Throwable)classNotFoundException);
        }
    }

    public void setRetryStrategy(String string) throws ClassNotFoundException {
        RetryStrategyFactory retryStrategyFactory = this.newRetryStrategyFactory(this.config_, this.getTaskProcessor(), string);
        this.retryStrategyFactory_.set((Object)retryStrategyFactory);
        this.logger_.info("set RetryStrategyFactory: " + string);
    }

    public String getRetryStrategy() {
        return this.retryStrategyFactory_.get().getClass().getName();
    }

    private RetryStrategyFactory newRetryStrategyFactory(Configuration configuration, TaskProcessor taskProcessor, String string) throws ClassNotFoundException {
        Class clazz = ObjectUtil.classForName(string);
        DefaultPicoContainer defaultPicoContainer = new DefaultPicoContainer();
        defaultPicoContainer.registerComponentInstance((Object)(class$org$jacorb$notification$engine$TaskProcessor == null ? (class$org$jacorb$notification$engine$TaskProcessor = AbstractProxyPushSupplier.class$("org.jacorb.notification.engine.TaskProcessor")) : class$org$jacorb$notification$engine$TaskProcessor), (Object)taskProcessor);
        defaultPicoContainer.registerComponentImplementation((Object)(class$org$jacorb$notification$engine$RetryStrategyFactory == null ? (class$org$jacorb$notification$engine$RetryStrategyFactory = AbstractProxyPushSupplier.class$("org.jacorb.notification.engine.RetryStrategyFactory")) : class$org$jacorb$notification$engine$RetryStrategyFactory), clazz);
        defaultPicoContainer.registerComponentInstance((Object)configuration);
        return (RetryStrategyFactory)defaultPicoContainer.getComponentInstance((Object)(class$org$jacorb$notification$engine$RetryStrategyFactory == null ? (class$org$jacorb$notification$engine$RetryStrategyFactory = AbstractProxyPushSupplier.class$("org.jacorb.notification.engine.RetryStrategyFactory")) : class$org$jacorb$notification$engine$RetryStrategyFactory));
    }

    public final void schedulePush() {
        if (!this.isDestroyed() && !this.isSuspended() && this.isEnabled()) {
            this.schedulePush(this.pushTask_);
        }
    }

    public final void schedulePush(PushTaskExecutor.PushTask pushTask) {
        this.pushTaskExecutor_.executePush(pushTask);
    }

    public final void messageQueued() {
        if (this.isEnabled()) {
            this.schedulePush();
        }
    }

    public void resetErrorCounter() {
        super.resetErrorCounter();
        this.pushCounter_.getAndIncrement();
        this.enableDelivery();
    }

    public void disableDelivery() {
        boolean bl = this.enabled_.getAndSet(false);
        if (bl) {
            this.logger_.debug("Disabled Delivery to ProxySupplier");
        }
    }

    protected boolean isEnabled() {
        return this.enabled_.get();
    }

    private void enableDelivery() {
        boolean bl = this.enabled_.getAndSet(true);
        if (!bl) {
            this.logger_.debug("Reenable Delivery to ProxySupplier");
        }
    }

    public int getPushOperationCount() {
        return this.pushCounter_.get();
    }

    public int getPushErrorCount() {
        return this.pushErrors_.get();
    }

    public int getAveragePushDuration() {
        return (int)this.getCost() / this.getPushOperationCount();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

