/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.client;

import fr.dyade.aaa.jndi2.client.NamingConnection;
import fr.dyade.aaa.jndi2.client.Trace;
import fr.dyade.aaa.jndi2.msg.IOControl;
import fr.dyade.aaa.jndi2.msg.JndiReply;
import fr.dyade.aaa.jndi2.msg.JndiRequest;
import fr.dyade.aaa.util.SocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;

public class SimpleNamingConnection
implements NamingConnection {
    SocketFactory socketFactory = null;
    static final String SOCKET_FACTORY_PROPERTY = "fr.dyade.aaa.jndi2.client.SocketFactory";
    int connectTimeout = 0;
    static final String TIMEOUT_PROPERTY = "fr.dyade.aaa.jndi2.client.ConnectTimeout";
    protected String hostName;
    protected int port;
    protected Hashtable env;
    protected IOControl ioCtrl;

    public SimpleNamingConnection() {
    }

    public SimpleNamingConnection(String hostName, int port, Hashtable env) {
        this.init(hostName, port, env);
    }

    public void init(String hostName, int port, Hashtable env) {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("SimpleNamingConnection.init(" + hostName + ',' + port + ',' + env + ')'));
        }
        this.hostName = hostName;
        this.port = port;
        this.env = env;
        this.connectTimeout = Integer.getInteger(TIMEOUT_PROPERTY, this.connectTimeout);
        String sfcn = System.getProperty(SOCKET_FACTORY_PROPERTY, "fr.dyade.aaa.util.SocketFactory14");
        this.socketFactory = SocketFactory.getFactory((String)sfcn);
    }

    public final String getHostName() {
        return this.hostName;
    }

    public final int getPort() {
        return this.port;
    }

    public synchronized JndiReply invoke(JndiRequest request) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("SimpleNamingConnection.invoke(" + request + ')'));
        }
        this.open();
        try {
            this.ioCtrl.writeObject((Object)request);
            JndiReply jndiReply = (JndiReply)this.ioCtrl.readObject();
            return jndiReply;
        }
        catch (IOException ioe) {
            if (Trace.logger.isLoggable(BasicLevel.ERROR)) {
                Trace.logger.log(BasicLevel.ERROR, (Object)"SimpleNamingConnection.receive()", (Throwable)ioe);
            }
            NamingException ne = new NamingException(ioe.getMessage());
            ne.setRootCause(ioe);
            throw ne;
        }
        catch (ClassNotFoundException cnfe) {
            if (Trace.logger.isLoggable(BasicLevel.ERROR)) {
                Trace.logger.log(BasicLevel.ERROR, (Object)"SimpleNamingConnection.receive()", (Throwable)cnfe);
            }
            NamingException ne = new NamingException(cnfe.getMessage());
            ne.setRootCause(cnfe);
            throw ne;
        }
        finally {
            this.ioCtrl.close();
        }
    }

    private void open() throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)"SimpleNamingConnection.open()");
        }
        try {
            InetAddress addr = InetAddress.getByName(this.hostName);
            Socket socket = this.socketFactory.createSocket(addr, this.port, this.connectTimeout);
            this.ioCtrl = new IOControl(socket);
        }
        catch (IOException exc) {
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)"SimpleNamingConnection.open()", (Throwable)exc);
            }
            NamingException exc2 = new NamingException(exc.getMessage());
            exc2.setRootCause(exc);
            throw exc2;
        }
    }

    public Hashtable getEnvironment() {
        return this.env;
    }

    public NamingConnection cloneConnection() {
        return new SimpleNamingConnection(this.hostName, this.port, this.env);
    }

    public String toString() {
        return '(' + super.toString() + ",hostname=" + this.hostName + ",port=" + this.port + ",env=" + this.env + ')';
    }
}

