/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.joram.mom.dest.mail;

import com.scalagent.joram.mom.dest.mail.JavaMailQueueImpl;
import com.scalagent.joram.mom.dest.mail.WakeUpPopNot;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.util.Timer;
import fr.dyade.aaa.util.TimerTask;
import java.util.Properties;
import org.objectweb.joram.mom.dest.DestinationImpl;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.proxies.ConnectionManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JavaMailQueue
extends Queue {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)JavaMailQueue.class.getName());
    public static final String MAIL_QUEUE_TYPE = "queue.mail";
    private transient PopTask poptask;

    public static String getDestinationType() {
        return MAIL_QUEUE_TYPE;
    }

    public DestinationImpl createsImpl(AgentId adminId, Properties prop) {
        return new JavaMailQueueImpl(this.getId(), adminId, prop);
    }

    protected void agentInitialize(boolean firstTime) throws Exception {
        super.agentInitialize(firstTime);
        this.poptask = new PopTask(this.getId());
        this.poptask.schedule();
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (not instanceof WakeUpPopNot) {
            if (this.poptask == null) {
                this.poptask = new PopTask(this.getId());
            }
            this.poptask.schedule();
            ((JavaMailQueueImpl)this.destImpl).doPop();
        } else {
            super.react(from, not);
        }
    }

    private class PopTask
    extends TimerTask {
        private AgentId to;

        public PopTask(AgentId to) {
            this.to = to;
        }

        public void run() {
            try {
                Channel.sendTo(this.to, new WakeUpPopNot());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void schedule() {
            block3: {
                long period = ((JavaMailQueueImpl)JavaMailQueue.this.destImpl).getPopPeriod();
                if (period > 0L) {
                    try {
                        Timer timer = ConnectionManager.getTimer();
                        timer.schedule((TimerTask)this, period);
                    }
                    catch (Exception exc) {
                        if (!logger.isLoggable(BasicLevel.ERROR)) break block3;
                        logger.log(BasicLevel.ERROR, (Object)("--- " + (Object)((Object)this) + " Queue(...)"), (Throwable)exc);
                    }
                }
            }
        }
    }
}

