/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.jotm.Control;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.HeuristicMixed;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.JavaXidImpl;
import org.objectweb.jotm.RecoveryCoordinator;
import org.objectweb.jotm.SubCoordinator;
import org.objectweb.jotm.Terminator;
import org.objectweb.jotm.TimerEvent;
import org.objectweb.jotm.TimerEventListener;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.XAResourceHelper;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;

public class TransactionImpl
implements Transaction,
TimerEventListener {
    private SubCoordinator subcoord = null;
    private TransactionContext myCtx = null;
    private Xid myXid = null;
    private boolean genXidhashcode = false;
    private boolean genXidtostring = false;
    private int myXidhashcode = 0;
    private String myXidtostring = null;
    private Date txDate = null;
    private boolean interpose = false;
    private TimerEvent timer = null;
    private RecoveryCoordinator recoveryCoord = null;
    private List<XAResource> enlistedXARes = Collections.synchronizedList(new ArrayList());
    private List<XAResource> delistedXARes = null;
    private boolean propagateCtx = true;
    private List<javax.transaction.xa.Xid> enlistedJavaxXid = Collections.synchronizedList(new ArrayList());
    private Map<Object, Object> userResourceMap = null;
    private int localstatus = 0;

    public TransactionImpl(Xid xid, int timeout) throws SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("xid= " + xid);
            TraceTm.jta.debug("timeout= " + timeout);
        }
        this.myXid = xid;
        this.myCtx = new InternalTransactionContext(timeout, null, xid);
    }

    public TransactionImpl(TransactionContext pctx) {
        if (pctx == null) {
            TraceTm.jotm.error("TransactionImpl: null PropagationContext");
            return;
        }
        this.myCtx = pctx;
        this.myXid = pctx.getXid();
        this.interpose = true;
        try {
            this.makeSubCoord();
        }
        catch (RollbackException e) {
            TraceTm.jotm.debug("already rolled back");
            this.localstatus = 4;
        }
        catch (SystemException e) {
            TraceTm.jotm.error("cannot make subcoordinator");
            this.localstatus = 4;
        }
    }

    public synchronized void putUserResource(Object key, Object value) {
        if (this.userResourceMap == null) {
            this.userResourceMap = Collections.synchronizedMap(new HashMap());
        }
        this.userResourceMap.put(key, value);
    }

    public synchronized Object getUserResource(Object key) {
        if (this.userResourceMap == null) {
            return null;
        }
        return this.userResourceMap.get(key);
    }

    public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        try {
            this.registerSynchronization(sync);
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        Terminator term;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.commit (tx= " + this + ")");
        }
        if ((term = this.myCtx.getTerminator()) != null) {
            try {
                this.propagateCtx = false;
                term.commit(true);
                this.propagateCtx = true;
            }
            catch (TransactionRolledbackException e) {
                Current.getCurrent().forgetTx(this.getXid());
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug("Commit distributed transaction -> rolled back!");
                }
                this.localstatus = 4;
                throw new RollbackException();
            }
            catch (RemoteException e) {
                if (TraceTm.jta.isWarnEnabled()) {
                    TraceTm.jta.warn("got a RemoteException", e);
                }
                if (e.detail instanceof TransactionRolledbackException) {
                    Current.getCurrent().forgetTx(this.getXid());
                    if (TraceTm.jta.isDebugEnabled()) {
                        TraceTm.jta.debug("Commit distributed transaction -> rolled back!");
                    }
                    this.localstatus = 4;
                    throw new RollbackException();
                }
                if (e.detail instanceof HeuristicMixed) {
                    if (TraceTm.jta.isDebugEnabled()) {
                        TraceTm.jta.debug("Commit distributed transaction -> Heuristic mixed!");
                    }
                    throw new HeuristicMixedException();
                }
                throw new SystemException("Unexpected RemoteException on commit:" + e.detail.getMessage());
            }
            catch (Exception e) {
                TraceTm.jotm.error("Unexpected Exception on commit:", e);
                throw new SystemException("Unexpected Exception on commit");
            }
            if (this.subcoord == null) {
                this.unsetTimer();
            }
            Current.getCurrent().forgetTx(this.getXid());
            this.localstatus = 3;
            return;
        }
        if (this.subcoord != null) {
            try {
                this.subcoord.commit_one_phase();
            }
            catch (TransactionRolledbackException e) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug("Commit local transaction -> rolled back!");
                }
                Current.getCurrent().forgetTx(this.getXid());
                this.localstatus = 4;
                throw new RollbackException();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error("Unexpected Exception on commit_one_phase:", e);
                Current.getCurrent().forgetTx(this.getXid());
                this.localstatus = 5;
                throw new SystemException("Unexpected Exception on commit_one_phase");
            }
        } else {
            this.unsetTimer();
            Current.getCurrent().forgetTx(this.getXid());
            this.localstatus = 3;
        }
    }

    public boolean delistResource(XAResource xares, int flag) throws IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.delistResource");
            TraceTm.jta.debug("xares= " + xares + ", flag= " + flag);
        }
        if (this.enlistedXARes == null) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error("No XA resources enlisted by JOTM");
            }
            return false;
        }
        if (!this.enlistedXARes.contains(xares)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error("XAResouce " + xares + " not enlisted by JOTM");
            }
            return false;
        }
        javax.transaction.xa.Xid javaxxid = this.subcoord.getJavaxXid(this.subcoord.getXaresIndex(xares));
        if (!this.enlistedJavaxXid.contains(javaxxid)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error("XAResouce " + xares + " not enlisted by JOTM");
            }
            return false;
        }
        int javaxxidindex = this.enlistedJavaxXid.indexOf(javaxxid);
        javax.transaction.xa.Xid myjavaxxid = this.enlistedJavaxXid.get(javaxxidindex);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("delisted with resource= " + xares);
            TraceTm.jta.debug("end myjavaxxid= " + myjavaxxid);
        }
        try {
            xares.end(myjavaxxid, flag);
        }
        catch (XAException e) {
            String error = "Cannot send XA end:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
            TraceTm.jotm.error(error);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jotm.debug("xares.end= " + xares);
            }
            throw new SystemException(error);
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("enlistedXAres.remove xares= " + xares);
        }
        this.enlistedXARes.remove(xares);
        this.enlistedJavaxXid.remove(javaxxid);
        return true;
    }

    public boolean enlistResource(XAResource xares) throws RollbackException, IllegalStateException, SystemException {
        int flag;
        boolean found;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.enlistResource");
            TraceTm.jta.debug("xares= " + xares);
        }
        if (xares == null) {
            TraceTm.jotm.error("enlistResource: null argument");
            throw new SystemException("enlistResource: null argument");
        }
        if (this.myCtx == null) {
            throw new SystemException("enlistResource: no Transactional Context");
        }
        if (this.subcoord == null) {
            this.makeSubCoord();
            if (this.subcoord == null) {
                TraceTm.jotm.error("enlistResource: could not create subcoordinator");
                throw new SystemException("enlistResource: could not create subcoordinator");
            }
        }
        try {
            found = this.subcoord.addResource(xares);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("enlistResource: could not addResource " + xares);
        }
        int n = flag = found ? 0x200000 : 0;
        if (this.delistedXARes != null && this.delistedXARes.contains(xares)) {
            flag = 0x8000000;
        }
        XidImpl resXid = new XidImpl(this.getXid(), this.subcoord.getXaresIndex(xares));
        JavaXidImpl javaxxid = new JavaXidImpl(resXid);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("enlisted with resource= " + xares);
            TraceTm.jta.debug("start javaxxid= " + javaxxid);
        }
        if (!found) {
            this.subcoord.addJavaxXid(javaxxid);
        }
        try {
            xares.start(javaxxid, flag);
        }
        catch (XAException e) {
            String error = "Cannot send XA(" + xares + ") start:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
            TraceTm.jotm.error(error);
            throw new SystemException(error);
        }
        if (!this.enlistedXARes.contains(xares)) {
            this.enlistedXARes.add(xares);
            this.enlistedJavaxXid.add(javaxxid);
        }
        int status = this.getStatus();
        switch (status) {
            case 0: 
            case 7: {
                break;
            }
            case 2: {
                throw new IllegalStateException("Transaction already prepared.");
            }
            case 8: {
                break;
            }
            case 3: {
                throw new IllegalStateException("Transaction already committed.");
            }
            case 1: {
                throw new RollbackException("Transaction already marked for rollback");
            }
            case 9: {
                throw new RollbackException("Transaction already started rolling back.");
            }
            case 4: {
                throw new RollbackException("Transaction already rolled back.");
            }
            case 6: {
                throw new IllegalStateException("No current transaction.");
            }
            case 5: {
                throw new IllegalStateException("Unknown transaction status");
            }
            default: {
                throw new IllegalStateException("Illegal transaction status: " + status);
            }
        }
        return true;
    }

    public void doDetach(int flag) throws SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.doDetach flag= " + XAResourceHelper.getFlagName(flag));
            TraceTm.jta.debug("number of enlisted= " + this.enlistedXARes.size());
        }
        this.delistedXARes = new ArrayList<XAResource>(this.enlistedXARes);
        for (XAResource xar : this.delistedXARes) {
            this.delistResource(xar, flag);
        }
    }

    public void doAttach(int flag) throws SystemException, RollbackException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.doAttach flag= " + XAResourceHelper.getFlagName(flag));
            TraceTm.jta.debug("number of enlisted= " + this.enlistedXARes.size());
        }
        boolean rollbackonenlist = false;
        Throwable mye = null;
        if (flag == 0x8000000) {
            for (int i = 0; this.delistedXARes != null && i < this.delistedXARes.size(); ++i) {
                try {
                    this.enlistResource(this.delistedXARes.get(i));
                    continue;
                }
                catch (RollbackException e) {
                    if (rollbackonenlist) continue;
                    rollbackonenlist = true;
                    mye = e;
                }
            }
        }
        this.delistedXARes = null;
        if (rollbackonenlist) {
            throw new RollbackException(mye.getMessage());
        }
    }

    public List getEnlistedXAResource() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("getEnlistedXAResource size= " + this.enlistedXARes.size());
        }
        return new ArrayList<XAResource>(this.enlistedXARes);
    }

    public int getStatus() throws SystemException {
        Coordinator coord;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.getStatus()");
        }
        if ((coord = this.myCtx.getCoordinator()) != null) {
            int ret;
            try {
                ret = coord.get_status();
            }
            catch (Exception e) {
                TraceTm.jotm.error("cannot reach JTM:", e);
                return 6;
            }
            return ret;
        }
        if (this.subcoord != null) {
            return this.subcoord.getStatus();
        }
        return this.localstatus;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.registerSynchronization(Synchronization sync)");
        }
        if (this.subcoord == null) {
            this.makeSubCoord();
        }
        this.subcoord.addSynchronization(sync);
    }

    public void rollback() throws IllegalStateException, SystemException {
        Terminator term;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.rollback(tx= " + this + ")");
        }
        if ((term = this.myCtx.getTerminator()) != null) {
            try {
                this.propagateCtx = false;
                term.rollback();
                this.propagateCtx = true;
            }
            catch (ServerException e) {
                throw new IllegalStateException("Exception on rollback:" + e);
            }
            catch (Exception e) {
                Current.getCurrent().forgetTx(this.getXid());
                this.localstatus = 5;
                this.clearUserResourceMap();
                throw new SystemException("Unexpected Exception on rollback");
            }
            if (this.subcoord == null) {
                this.unsetTimer();
            }
            Current.getCurrent().forgetTx(this.getXid());
            this.localstatus = 4;
            this.clearUserResourceMap();
            return;
        }
        if (this.subcoord != null) {
            try {
                this.subcoord.rollback();
            }
            catch (RemoteException e) {
                Current.getCurrent().forgetTx(this.getXid());
                this.localstatus = 5;
                this.clearUserResourceMap();
                throw new IllegalStateException("Exception on rollback:" + e);
            }
        } else {
            this.unsetTimer();
        }
        Current.getCurrent().forgetTx(this.getXid());
        this.localstatus = 4;
        this.clearUserResourceMap();
    }

    public int prepare() throws IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.prepare(tx= " + this + ")");
        }
        int ret = 0;
        if (this.subcoord != null) {
            try {
                ret = this.subcoord.prepare();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error("Unexpected Exception on prepare:", e);
                throw new SystemException("Unexpected Exception on prepare");
            }
        }
        return ret;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Coordinator coord;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.setRollbackOnly(tx= " + this + ")");
        }
        if ((coord = this.myCtx.getCoordinator()) != null) {
            try {
                coord.rollback_only();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error("Cannot perform coordinator rollback only", e);
            }
        }
        if (this.subcoord == null) {
            try {
                this.makeSubCoord();
            }
            catch (RollbackException e) {
                TraceTm.jotm.debug("already rolled back");
                return;
            }
        }
        this.subcoord.setRollbackOnly();
    }

    public void timeoutExpired(Object arg) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.timeoutExpired");
        }
        Current.getCurrent().incrementExpiredCounter();
        if (this.subcoord == null) {
            Terminator term = this.myCtx.getTerminator();
            if (term != null) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug("forget tx (tx=" + this + ")");
                }
                Current.getCurrent().forgetTx(this.getXid());
                this.localstatus = 4;
                return;
            }
            try {
                this.makeSubCoord();
            }
            catch (RollbackException e) {
                TraceTm.jotm.debug("already rolled back");
                this.localstatus = 4;
                return;
            }
            catch (SystemException e) {
                TraceTm.jotm.error("cannot make subcoordinator");
                this.localstatus = 4;
                return;
            }
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("set rollback only (tx=" + this + ")");
        }
        try {
            this.subcoord.setRollbackOnly();
        }
        catch (Exception e) {
            TraceTm.jotm.error("cannot rollbackonly:" + e);
        }
    }

    public boolean equals(Object obj2) {
        if (obj2 instanceof TransactionImpl) {
            TransactionImpl tx2 = (TransactionImpl)obj2;
            if (tx2 == this) {
                return true;
            }
            return this.getXid().equals(tx2.getXid());
        }
        return false;
    }

    public int hashCode() {
        if (!this.genXidhashcode) {
            this.genXidhashcode = true;
            this.myXidhashcode = this.getXid().hashCode();
        }
        return this.myXidhashcode;
    }

    public String toString() {
        if (!this.genXidtostring) {
            this.genXidtostring = true;
            this.myXidtostring = ((Object)this.getXid()).toString();
        }
        return this.myXidtostring;
    }

    public synchronized TransactionContext getPropagationContext(boolean hold) {
        if (this.propagateCtx) {
            return this.myCtx;
        }
        return null;
    }

    public void setTimer(TimerEvent timer) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("set timer for tx (timer=" + timer + ", tx=" + this + ")");
        }
        this.timer = timer;
    }

    public void unsetTimer() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("unset timer for tx (timer=" + this.timer + ", tx=" + this + ")");
        }
        if (this.timer != null) {
            this.timer.unset();
            this.timer = null;
        }
    }

    public void setTxDate(Date date) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("set date for tx (data=" + date + ", tx=" + this + ")");
        }
        this.txDate = (Date)date.clone();
    }

    public Date getTxDate() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("get date for tx (date=" + this.txDate + ", tx=" + this + ")");
        }
        return (Date)this.txDate.clone();
    }

    public synchronized void updatePropagationContext(TransactionContext pctx) {
        Coordinator remoteCoord;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("TransactionImpl.updatePropagationContext");
        }
        if ((remoteCoord = pctx.getCoordinator()) == null && this.myCtx.getCoordinator() != null) {
            TraceTm.jotm.error("setPropagationContext: Bad Coordinator");
            TraceTm.jotm.error("remoteCoord = " + remoteCoord);
            TraceTm.jotm.error("myCtx.getCoordinator()= " + this.myCtx.getCoordinator());
            return;
        }
        if (remoteCoord != null && this.myCtx.getCoordinator() == null) {
            this.myCtx.setCoordinator(pctx.getCoordinator());
            if (this.subcoord != null) {
                try {
                    this.recoveryCoord = remoteCoord.register_resource(this.subcoord);
                }
                catch (RemoteException e) {
                    TraceTm.jotm.error("Cannot make interposition:", e);
                    return;
                }
            }
        }
        if (pctx.getTerminator() != null) {
            this.myCtx.setTerminator(pctx.getTerminator());
        }
    }

    public Xid getXid() {
        return this.myXid;
    }

    private void makeSubCoord() throws RollbackException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug("make subcoordinator");
        }
        try {
            this.subcoord = new SubCoordinator(this, this.getXid());
        }
        catch (RemoteException e) {
            TraceTm.jotm.error("new SubCoordinator raised exception: ", e);
            return;
        }
        Coordinator remoteCoord = this.myCtx.getCoordinator();
        if (this.interpose && remoteCoord == null) {
            try {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug("Creating a remote Control on JTM for a distributed transaction");
                }
                Control coord = Current.getJTM().recreate(this.myCtx);
                remoteCoord = (Coordinator)PortableRemoteObject.narrow((Object)coord, Coordinator.class);
            }
            catch (RemoteException e) {
                TraceTm.jotm.error("Cannot create distributed transaction:", e);
                return;
            }
            this.myCtx.setCoordinator(remoteCoord);
            if (this.myCtx.getTerminator() == null) {
                this.myCtx.setTerminator((Terminator)((Object)remoteCoord));
            }
        }
        if (remoteCoord != null && this.recoveryCoord == null) {
            try {
                this.recoveryCoord = remoteCoord.register_resource(this.subcoord);
            }
            catch (RemoteException e) {
                if (e.getCause() instanceof TransactionRolledbackException) {
                    TraceTm.jotm.warn("Cannot Make Interposition: rolled back occured");
                    throw new RollbackException("Cannot Make Interposition");
                }
                TraceTm.jotm.error("Cannot make Interposition:", e);
                throw new SystemException("Cannot Make Interposition");
            }
        }
    }

    private synchronized void clearUserResourceMap() {
        if (this.userResourceMap != null && !this.userResourceMap.isEmpty()) {
            this.userResourceMap.clear();
            this.userResourceMap = null;
        }
    }
}

