/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.server;

import fr.dyade.aaa.jndi2.msg.IOControl;
import fr.dyade.aaa.jndi2.msg.JndiReply;
import fr.dyade.aaa.jndi2.msg.JndiRequest;
import fr.dyade.aaa.jndi2.server.RequestContext;
import fr.dyade.aaa.jndi2.server.Trace;
import java.net.Socket;
import org.objectweb.util.monolog.api.BasicLevel;

public class TcpRequestContext
extends RequestContext {
    private static final long serialVersionUID = 1L;
    private transient IOControl ioCtrl;
    private JndiRequest request;

    public TcpRequestContext(Socket socket) throws Exception {
        this.ioCtrl = new IOControl(socket);
        this.request = (JndiRequest)this.ioCtrl.readObject();
    }

    public JndiRequest getRequest() {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)"TcpRequestContext.getRequest()");
        }
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(JndiReply reply) {
        try {
            this.ioCtrl.writeObject((Object)reply);
        }
        catch (Exception exc) {
            Trace.logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
        }
        finally {
            this.ioCtrl.close();
        }
    }

    public String toString() {
        return '(' + super.toString() + ",request=" + this.request + ')';
    }
}

