/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.BagSerializer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.util.Timer;
import fr.dyade.aaa.util.TimerTask;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import org.objectweb.joram.mom.dest.DeadMQueueImpl;
import org.objectweb.joram.mom.dest.Destination;
import org.objectweb.joram.mom.dest.DestinationImpl;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.AbortReceiveRequest;
import org.objectweb.joram.mom.notifications.AbstractRequest;
import org.objectweb.joram.mom.notifications.AcknowledgeRequest;
import org.objectweb.joram.mom.notifications.BrowseRequest;
import org.objectweb.joram.mom.notifications.DenyRequest;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.Monit_GetNbMaxMsg;
import org.objectweb.joram.mom.notifications.Monit_GetPendingMessages;
import org.objectweb.joram.mom.notifications.Monit_GetPendingRequests;
import org.objectweb.joram.mom.notifications.ReceiveRequest;
import org.objectweb.joram.mom.notifications.SetNbMaxMsgRequest;
import org.objectweb.joram.mom.notifications.SetThreshRequest;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.proxies.ConnectionManager;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.util.monolog.api.BasicLevel;

public class Queue
extends Destination
implements BagSerializer {
    private static final long serialVersionUID = 1L;
    public static final String QUEUE_TYPE = "queue";
    private transient Task task;

    public static String getDestinationType() {
        return QUEUE_TYPE;
    }

    public DestinationImpl createsImpl(AgentId adminId, Properties prop) {
        return new QueueImpl(this.getId(), adminId, prop);
    }

    protected void agentInitialize(boolean firstTime) throws Exception {
        super.agentInitialize(firstTime);
        this.task = new Task(this.getId());
        this.task.schedule();
    }

    public void react(AgentId from, Notification not) throws Exception {
        block29: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Queue.react(" + from + ',' + not + ')'));
            }
            try {
                if (not instanceof SetThreshRequest) {
                    ((QueueImpl)this.destImpl).setThreshRequest(from, (SetThreshRequest)not);
                } else if (not instanceof SetNbMaxMsgRequest) {
                    ((QueueImpl)this.destImpl).setNbMaxMsgRequest(from, (SetNbMaxMsgRequest)not);
                } else if (not instanceof Monit_GetPendingMessages) {
                    ((QueueImpl)this.destImpl).monitGetPendingMessages(from, (Monit_GetPendingMessages)not);
                } else if (not instanceof Monit_GetPendingRequests) {
                    ((QueueImpl)this.destImpl).monitGetPendingRequests(from, (Monit_GetPendingRequests)not);
                } else if (not instanceof Monit_GetNbMaxMsg) {
                    ((QueueImpl)this.destImpl).monitGetNbMaxMsg(from, (Monit_GetNbMaxMsg)not);
                } else if (not instanceof ReceiveRequest) {
                    ((QueueImpl)this.destImpl).receiveRequest(from, (ReceiveRequest)not);
                } else if (not instanceof BrowseRequest) {
                    ((QueueImpl)this.destImpl).browseRequest(from, (BrowseRequest)not);
                } else if (not instanceof AcknowledgeRequest) {
                    ((QueueImpl)this.destImpl).acknowledgeRequest(from, (AcknowledgeRequest)not);
                } else if (not instanceof DenyRequest) {
                    ((QueueImpl)this.destImpl).denyRequest(from, (DenyRequest)not);
                } else if (not instanceof AbortReceiveRequest) {
                    ((QueueImpl)this.destImpl).abortReceiveRequest(from, (AbortReceiveRequest)not);
                } else if (not instanceof ExpiredNot) {
                    ((DeadMQueueImpl)this.destImpl).handleExpiredNot(from, (ExpiredNot)not);
                } else if (not instanceof WakeUpNot) {
                    if (this.task == null) {
                        this.task = new Task(this.getId());
                    }
                    this.task.schedule();
                    ((QueueImpl)this.destImpl).wakeUpNot((WakeUpNot)not);
                } else {
                    super.react(from, not);
                }
            }
            catch (MomException exc) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)exc);
                }
                if (!(not instanceof AbstractRequest)) break block29;
                AbstractRequest req = (AbstractRequest)not;
                Channel.sendTo(from, new ExceptionReply(req, exc));
            }
        }
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ((QueueImpl)this.destImpl).readBag(in);
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        ((QueueImpl)this.destImpl).writeBag(out);
    }

    private class Task
    extends TimerTask {
        private AgentId to;

        private Task(AgentId to) {
            this.to = to;
        }

        public void run() {
            try {
                Channel.sendTo(this.to, new WakeUpNot());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void schedule() {
            block3: {
                long period = ((QueueImpl)Queue.this.destImpl).getPeriod();
                if (period != -1L) {
                    try {
                        Timer timer = ConnectionManager.getTimer();
                        timer.schedule((TimerTask)this, period);
                    }
                    catch (Exception exc) {
                        if (AgentServer.isHAServer() && (!AgentServer.isHAServer() || !AgentServer.isMasterHAServer()) || !JoramTracing.dbgDestination.isLoggable(BasicLevel.WARN)) break block3;
                        JoramTracing.dbgDestination.log(BasicLevel.WARN, (Object)("--- " + (Object)((Object)this) + " Queue(...)"), (Throwable)exc);
                    }
                }
            }
        }
    }
}

