/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.tcp;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.util.Daemon;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.objectweb.joram.mom.notifications.GetProxyIdNot;
import org.objectweb.joram.mom.proxies.AckedQueue;
import org.objectweb.joram.mom.proxies.GetConnectionNot;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.ReliableConnectionContext;
import org.objectweb.joram.mom.proxies.tcp.IOControl;
import org.objectweb.joram.mom.proxies.tcp.TcpConnection;
import org.objectweb.joram.mom.proxies.tcp.TcpProxyService;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.stream.StreamUtil;
import org.objectweb.util.monolog.api.BasicLevel;

public class TcpConnectionListener
extends Daemon {
    private ServerSocket serverSocket;
    private TcpProxyService proxyService;
    private int timeout;

    public TcpConnectionListener(ServerSocket serverSocket, TcpProxyService proxyService, int timeout) {
        super("TcpConnectionListener");
        this.serverSocket = serverSocket;
        this.proxyService = proxyService;
        this.timeout = timeout;
    }

    public void run() {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"TcpConnectionListener.run()");
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        while (this.running) {
            this.canStop = true;
            if (this.serverSocket == null) continue;
            try {
                this.acceptConnection();
            }
            catch (Exception exc) {
                if (!this.running) break;
            }
        }
    }

    private void acceptConnection() throws Exception {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"TcpConnectionListener.acceptConnection()");
        }
        Socket sock = this.serverSocket.accept();
        String inaddr = sock.getInetAddress().getHostAddress();
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)" -> accept connection");
        }
        try {
            IOControl ioctrl;
            AckedQueue replyQueue;
            AgentId proxyId;
            sock.setTcpNoDelay(true);
            sock.setSoTimeout(this.timeout);
            InputStream is = sock.getInputStream();
            NetOutputStream nos = new NetOutputStream(sock);
            int len = StreamUtil.readIntFrom((InputStream)is);
            String userName = StreamUtil.readStringFrom((InputStream)is);
            if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)(" -> read userName = " + userName));
            }
            String userPassword = StreamUtil.readStringFrom((InputStream)is);
            if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)(" -> read userPassword = " + userPassword));
            }
            int key = StreamUtil.readIntFrom((InputStream)is);
            if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)(" -> read key = " + key));
            }
            int heartBeat = 0;
            if (key == -1) {
                heartBeat = StreamUtil.readIntFrom((InputStream)is);
                if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)(" -> read heartBeat = " + heartBeat));
                }
            }
            GetProxyIdNot gpin = new GetProxyIdNot(userName, userPassword, inaddr);
            try {
                gpin.invoke(new AgentId(AgentServer.getServerId(), AgentServer.getServerId(), AgentId.JoramAdminStamp));
                proxyId = gpin.getProxyId();
            }
            catch (Exception exc) {
                if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
                StreamUtil.writeTo((int)1, (OutputStream)nos);
                StreamUtil.writeTo((String)exc.getMessage(), (OutputStream)nos);
                nos.send();
                return;
            }
            if (key == -1) {
                OpenConnectionNot ocn = new OpenConnectionNot(true, heartBeat);
                ocn.invoke(proxyId);
                StreamUtil.writeTo((int)0, (OutputStream)nos);
                ReliableConnectionContext ctx = (ReliableConnectionContext)ocn.getConnectionContext();
                key = ctx.getKey();
                StreamUtil.writeTo((int)ctx.getKey(), (OutputStream)nos);
                nos.send();
                replyQueue = ctx.getQueue();
                ioctrl = new IOControl(sock);
            } else {
                GetConnectionNot gcn = new GetConnectionNot(key);
                try {
                    gcn.invoke(proxyId);
                }
                catch (Exception exc) {
                    if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                        JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                    }
                    StreamUtil.writeTo((int)1, (OutputStream)nos);
                    StreamUtil.writeTo((String)exc.getMessage(), (OutputStream)nos);
                    nos.send();
                    return;
                }
                ReliableConnectionContext ctx = (ReliableConnectionContext)gcn.getConnectionContext();
                replyQueue = ctx.getQueue();
                heartBeat = ctx.getHeartBeat();
                StreamUtil.writeTo((int)0, (OutputStream)nos);
                nos.send();
                ioctrl = new IOControl(sock, ctx.getInputCounter());
                TcpConnection tcpConnection = this.proxyService.getConnection(proxyId, key);
                if (tcpConnection != null) {
                    tcpConnection.close();
                }
            }
            sock.setSoTimeout(0);
            TcpConnection tcpConnection = new TcpConnection(ioctrl, proxyId, replyQueue, key, this.proxyService, heartBeat == 0);
            tcpConnection.start();
        }
        catch (Exception exc) {
            if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            sock.close();
            throw exc;
        }
    }

    protected void shutdown() {
        this.close();
    }

    protected void close() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
    }

    static class NetOutputStream
    extends ByteArrayOutputStream {
        private OutputStream os = null;

        NetOutputStream(Socket sock) throws IOException {
            super(1024);
            this.reset();
            this.os = sock.getOutputStream();
        }

        public void reset() {
            this.count = 4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send() throws IOException {
            try {
                this.buf[0] = (byte)(this.count - 4 >>> 24);
                this.buf[1] = (byte)(this.count - 4 >>> 16);
                this.buf[2] = (byte)(this.count - 4 >>> 8);
                this.buf[3] = (byte)(this.count - 4 >>> 0);
                this.writeTo(this.os);
                this.os.flush();
            }
            finally {
                this.reset();
            }
        }
    }
}

