/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.multi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Properties;
import org.ow2.carol.irmi.ClientInterceptor;
import org.ow2.carol.irmi.Interceptor;
import org.ow2.carol.irmi.PRO;
import org.ow2.carol.irmi.Server;
import org.ow2.carol.rmi.interceptor.spi.JClientRequestInterceptor;
import org.ow2.carol.rmi.interceptor.spi.JServerRequestInterceptor;
import org.ow2.carol.rmi.interceptor.spi.JServiceContext;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorHelper;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorStore;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorsKind;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JRMPClientRequestInfoImpl;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JRMPServerRequestInfoImpl;
import org.ow2.carol.rmi.util.PortNumber;
import org.ow2.carol.util.configuration.ConfigurationRepository;

public class IrmiPRODelegate
extends PRO {
    private static Server getServer() {
        int port = 0;
        Properties prop = ConfigurationRepository.getProperties();
        if (prop != null) {
            String propertyName = "carol.irmi.server.port";
            port = PortNumber.strToint(prop.getProperty(propertyName, "0"), propertyName);
        }
        return new Server(port);
    }

    public IrmiPRODelegate() {
        super(IrmiPRODelegate.getServer());
    }

    public void exportObject(Remote obj) throws RemoteException {
        JInterceptorStore jiStore = JInterceptorStore.getJInterceptorStore();
        JInterceptorsKind interceptorsByType = JInterceptorHelper.getInterceptorsByType(jiStore.getJInterceptors());
        JServerRequestInterceptor[] sis = interceptorsByType.getJServerRequestInterceptors();
        JClientRequestInterceptor[] cis = interceptorsByType.getJClientRequestInterceptors();
        super.exportObject(obj, (ClientInterceptor)new ClientInterceptorImpl(cis), (Interceptor)new ServerInterceptorImpl(sis));
    }

    private static class ClientInterceptorImpl
    implements ClientInterceptor {
        private static final long serialVersionUID = -5212967521441892250L;
        private final JClientRequestInterceptor[] cis;

        public ClientInterceptorImpl(JClientRequestInterceptor[] cis) {
            this.cis = cis;
        }

        public void send(byte code, ObjectOutput out) throws IOException {
            JRMPClientRequestInfoImpl info = new JRMPClientRequestInfoImpl();
            for (JClientRequestInterceptor ci : this.cis) {
                ci.sendRequest(info);
            }
            Collection<JServiceContext> c = info.getAllRequestServiceContext();
            out.writeShort(c.size());
            for (JServiceContext jServiceContext : c) {
                out.writeObject(jServiceContext);
            }
        }

        public void receive(byte code, ObjectInput in) throws IOException, ClassNotFoundException {
            JRMPClientRequestInfoImpl info = new JRMPClientRequestInfoImpl();
            int len = in.readShort();
            for (int i = 0; i < len; ++i) {
                info.addRequestServiceContext((JServiceContext)in.readObject());
            }
            block5: for (JClientRequestInterceptor ci : this.cis) {
                switch (code) {
                    case 1: {
                        ci.receiveReply(info);
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        ci.receiveException(info);
                    }
                }
            }
        }
    }

    private static class ServerInterceptorImpl
    implements Interceptor {
        private JServerRequestInterceptor[] sis;

        public ServerInterceptorImpl(JServerRequestInterceptor[] sis) {
            this.sis = sis;
        }

        public void receive(byte code, ObjectInput in) throws IOException, ClassNotFoundException {
            JRMPServerRequestInfoImpl info = new JRMPServerRequestInfoImpl();
            int len = in.readShort();
            for (int i = 0; i < len; ++i) {
                info.addReplyServiceContext((JServiceContext)in.readObject());
            }
            for (JServerRequestInterceptor si : this.sis) {
                si.receiveRequest(info);
            }
        }

        public void send(byte code, ObjectOutput out) throws IOException {
            JRMPServerRequestInfoImpl info = new JRMPServerRequestInfoImpl();
            block4: for (JServerRequestInterceptor si : this.sis) {
                switch (code) {
                    case 1: {
                        si.sendReply(info);
                        continue block4;
                    }
                    case 2: 
                    case 3: {
                        si.sendException(info);
                    }
                }
            }
            Collection<JServiceContext> c = info.getAllReplyServiceContext();
            out.writeShort(c.size());
            for (JServiceContext jServiceContext : c) {
                out.writeObject(jServiceContext);
            }
        }
    }
}

