/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import java.util.Timer;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.tcp.ReliableTcpClient;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsMessage;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.util.monolog.api.BasicLevel;

public class TcpConnection
implements RequestChannel {
    private ReliableTcpClient tcpClient = null;

    public TcpConnection(FactoryParameters params, String name, String password) throws JMSException {
        this(params, name, password, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient");
    }

    public TcpConnection(FactoryParameters params, String name, String password, String reliableClass) throws JMSException {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("TcpConnection.<init>(" + params + ',' + name + ',' + password + ',' + reliableClass + ')'));
        }
        if (reliableClass == null || reliableClass.equals("") || reliableClass.length() < 1) {
            reliableClass = "org.objectweb.joram.client.jms.tcp.ReliableTcpClient";
        }
        try {
            this.tcpClient = (ReliableTcpClient)Class.forName(reliableClass).newInstance();
        }
        catch (ClassNotFoundException exc) {
            JMSException jmsExc = new JMSException("TcpConnection: ClassNotFoundException : " + reliableClass);
            jmsExc.setLinkedException((Exception)exc);
            throw jmsExc;
        }
        catch (InstantiationException exc) {
            JMSException jmsExc = new JMSException("TcpConnection: InstantiationException : " + reliableClass);
            jmsExc.setLinkedException((Exception)exc);
            throw jmsExc;
        }
        catch (IllegalAccessException exc) {
            JMSException jmsExc = new JMSException("TcpConnection: IllegalAccessException : " + reliableClass);
            jmsExc.setLinkedException((Exception)exc);
            throw jmsExc;
        }
        this.tcpClient.init(params, name, password, params.cnxPendingTimer > 0);
        this.tcpClient.addServerAddress(params.getHost(), params.getPort());
    }

    public void setTimer(Timer timer) {
        this.tcpClient.setTimer(timer);
    }

    public void connect() throws Exception {
        this.tcpClient.connect();
    }

    public synchronized void send(AbstractJmsRequest request) throws Exception {
        this.tcpClient.send((AbstractJmsMessage)request);
    }

    public AbstractJmsReply receive() throws Exception {
        return (AbstractJmsReply)this.tcpClient.receive();
    }

    public void close() {
        this.tcpClient.close();
    }

    public String toString() {
        return '(' + super.toString() + ",tcpClient=" + this.tcpClient + ')';
    }
}

