/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import javax.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.XidImpl;

public class XATerminatorImpl
implements XATerminator {
    private TransactionImpl iftx = null;

    public XATerminatorImpl() throws XAException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug("create XATerminator");
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug("commit xid=" + xid + "onePhase=" + onePhase);
        }
        XidImpl myxid = new XidImpl(xid);
        this.iftx = Current.getCurrent().getTxByXid(myxid);
        if (this.iftx == null) {
            TraceTm.jotm.error("XATerminatorImpl.commit(): unknown xid " + xid);
            throw new XAException(-4);
        }
        try {
            this.iftx.commit();
        }
        catch (Exception e) {
            TraceTm.jotm.error("XATerminatorImpl.commit(): commit raised exception ", e);
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug("rollback xid=" + xid);
        }
        XidImpl myxid = new XidImpl(xid);
        this.iftx = Current.getCurrent().getTxByXid(myxid);
        if (this.iftx == null) {
            TraceTm.jotm.error("XATerminatorImpl.rollback(): unknown xid " + xid);
            throw new XAException(-4);
        }
        try {
            this.iftx.rollback();
        }
        catch (Exception e) {
            TraceTm.jotm.error("XATerminatorImpl.rollback(): rollback raised exception ", e);
        }
    }

    public int prepare(Xid xid) throws XAException {
        int ret = 0;
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug("prepare xid=" + xid);
        }
        XidImpl myxid = new XidImpl(xid);
        this.iftx = Current.getCurrent().getTxByXid(myxid);
        if (this.iftx == null) {
            TraceTm.jotm.error("XATerminatorImpl.prepare(): unknown xid " + xid);
            throw new XAException(-4);
        }
        try {
            ret = this.iftx.prepare();
        }
        catch (Exception e) {
            TraceTm.jotm.error("XATerminatorImpl.prepare(): prepare raised exception ", e);
        }
        return ret;
    }

    public void forget(Xid xid) throws XAException {
        TraceTm.jotm.debug("XATerminatorImpl.forget()");
        XidImpl myxid = new XidImpl(xid);
        try {
            Current.getCurrent().forgetTx(myxid);
        }
        catch (Exception e) {
            TraceTm.jotm.error("XATerminatorImpl.forget(): forget raised exception ", e);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        TraceTm.jotm.debug("XATerminatorImpl.recover()");
        return Current.getCurrent().getPreparedHeuristicXid();
    }
}

