/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.RmiConfiguration;
import org.objectweb.jotm.RmiConfigurationException;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionFactoryImpl;
import org.objectweb.jotm.TransactionRecovery;
import org.objectweb.jotm.TransactionSynchronizationRegistryImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class Jotm {
    Current current = null;
    TransactionRecovery transactionrecovery = null;
    TransactionSynchronizationRegistryImpl transactionsynchronizationregistry = null;
    private static final String TMFACTORY_NAME = "TMFactory";
    private TransactionFactory tf = null;
    private final boolean local;
    private final boolean bound;
    private boolean boundFailed = false;
    public static final Log log = LogFactory.getLog(Jotm.class);
    private final RmiConfiguration rmiConfiguration;

    public Jotm(boolean local, boolean bound) throws NamingException {
        this(local, bound, null);
    }

    public Jotm(boolean local, boolean bound, RmiConfiguration rmiConfiguration) throws NamingException {
        InitialContext ictx;
        this.local = local;
        this.bound = bound;
        this.rmiConfiguration = rmiConfiguration;
        log.info((Object)"RMI initialization", new Object[0]);
        try {
            rmiConfiguration.init();
        }
        catch (RmiConfigurationException e) {
            log.error((Object)"RMI initialization failed", new Object[]{e});
        }
        if (local) {
            log.info((Object)"JOTM started with a local transaction factory", new Object[0]);
            try {
                this.tf = new TransactionFactoryImpl(rmiConfiguration);
            }
            catch (RemoteException e) {
                log.error((Object)"Instanciation of TransactionFactory failed", new Object[]{e});
            }
            if (bound) {
                try {
                    ictx = new InitialContext();
                    ictx.rebind(TMFACTORY_NAME, (Object)this.tf);
                    log.info((Object)"TransactionFactory bound with name TMFactory", new Object[0]);
                }
                catch (NamingException e) {
                    log.error((Object)"TransactionFactory rebind failed", new Object[]{e});
                    this.boundFailed = true;
                    throw e;
                }
            }
        } else {
            log.info((Object)"JOTM started with a remote transaction factory", new Object[0]);
            try {
                ictx = new InitialContext();
                this.tf = (TransactionFactory)ictx.lookup(TMFACTORY_NAME);
            }
            catch (NamingException e) {
                log.error((Object)"TransactionFactory lookup failed", new Object[]{e});
                throw e;
            }
        }
        try {
            this.current = new Current(this.tf);
            this.transactionsynchronizationregistry = TransactionSynchronizationRegistryImpl.getInstance();
        }
        catch (Exception e) {
            log.error((Object)"cannot init Current", new Object[]{e});
        }
    }

    public TransactionManager getTransactionManager() {
        return Current.getTransactionManager();
    }

    public UserTransaction getUserTransaction() {
        return Current.getUserTransaction();
    }

    public TransactionSynchronizationRegistryImpl getTransactionSynchronizationRegistry() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("TransactionSynchronizationRegistry=" + this.transactionsynchronizationregistry), new Object[0]);
        }
        return this.transactionsynchronizationregistry;
    }

    public void stop() {
        log.info((Object)"stop JOTM", new Object[0]);
        try {
            this.current.forget();
        }
        catch (Exception e) {
            log.warn((Object)"cannot stop Current", new Object[]{e});
        }
        try {
            if (this.transactionrecovery != null) {
                this.transactionrecovery.forget();
            }
        }
        catch (Exception e) {
            log.warn((Object)"cannot stop Recovery", new Object[]{e});
        }
        if (this.local) {
            if (this.bound && !this.boundFailed) {
                try {
                    InitialContext ictx = new InitialContext();
                    ictx.unbind(TMFACTORY_NAME);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"TransactionFactory unbound", new Object[0]);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Cannot unbound the TransactionFactory", new Object[]{e});
                }
            }
            if (this.tf != null) {
                try {
                    if (this.rmiConfiguration.isCorbaCompliant()) {
                        PortableRemoteObject.unexportObject((Remote)this.tf);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"TransactionFactory unexported", new Object[0]);
                        }
                    }
                }
                catch (NoSuchObjectException e) {
                    log.warn((Object)"Cannot unexport the TransactionFactory", new Object[]{e});
                }
            }
        }
        this.tf = null;
    }
}

