/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.transaction.TransactionManager;
import org.objectweb.jotm.Control;
import org.objectweb.jotm.ControlImpl;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.RmiConfiguration;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;

public class TransactionFactoryImpl
implements TransactionFactory {
    int timeoutMax = 3600;
    private final Vector coordinatorList = new Vector();
    private final RmiConfiguration rmiConfiguration;

    public TransactionFactoryImpl(RmiConfiguration rmiConfiguration) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"default constructor", new Object[0]);
        }
        this.rmiConfiguration = rmiConfiguration;
        if (rmiConfiguration.isCorbaCompliant()) {
            PortableRemoteObject.exportObject((Remote)this);
        }
    }

    public synchronized Control create(int timeout) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("timeout=" + timeout), new Object[0]);
        }
        ControlImpl ctrl = null;
        if (timeout == 0 || timeout > this.timeoutMax) {
            timeout = this.timeoutMax;
        }
        XidImpl xid = new XidImpl("TMServer", 0);
        try {
            ctrl = new ControlImpl(timeout, xid, null, this.rmiConfiguration);
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"Cannot create ControlImpl", new Object[]{e});
        }
        return ctrl;
    }

    public synchronized Control create(int timeout, Xid xid) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("xid=" + xid), new Object[0]);
        }
        ControlImpl ctrl = null;
        if (timeout == 0 || timeout > this.timeoutMax) {
            timeout = this.timeoutMax;
        }
        try {
            ctrl = new ControlImpl(timeout, xid, null, this.rmiConfiguration);
            InitialContext ictx = new InitialContext();
            TransactionManager tm = (TransactionManager)ictx.lookup("java:/TransactionManager");
            TransactionImpl tx = ((Current)tm).getTxByXid(xid);
            if (tx != null) {
                InternalTransactionContext ctx = new InternalTransactionContext(timeout, ctrl, xid);
                tx.updatePropagationContext(ctx);
            }
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"Cannot create ControlImpl", new Object[]{e});
        }
        return ctrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Control recreate(TransactionContext ctx) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("TransactionContext=" + ctx), new Object[0]);
        }
        ControlImpl ctrl = null;
        Vector vector = this.coordinatorList;
        synchronized (vector) {
            for (int i = 0; i < this.coordinatorList.size(); ++i) {
                Coordinator coord = (Coordinator)this.coordinatorList.elementAt(i);
                if (!coord.equals(ctx.getCoordinator())) continue;
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"recreate: Control already in the list", new Object[0]);
                }
                ctrl = (ControlImpl)coord;
                break;
            }
        }
        if (ctrl != null) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)"recreate twice", new Object[0]);
            }
            return ctrl;
        }
        Xid xid = ctx.getXid();
        try {
            ctrl = new ControlImpl(ctx.getTimeout(), xid, ctx.getCoordinator(), this.rmiConfiguration);
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"Cannot create ControlImpl", new Object[]{e});
        }
        return ctrl;
    }

    public int getPortNumber() throws RemoteException {
        return 0;
    }

    public String getHostName() throws RemoteException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            throw new RemoteException("" + e);
        }
    }
}

