/*
 * @(#) ResourceManagerEvent.java
 *
 * JOTM: Java Open Transaction Manager
 * 
 * This module was originally developed by 
 *  - INRIA inside the ObjectWeb Consortium(http://www.objectweb.org)
 *    
 * The original code and portions created by INRIA are 
 * Copyright (C) 2002 - INRIA (www.inria.fr)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * -Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer. 
 *
 * -Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 *-----------------------------------------------------------------------------
 * $Id: ResourceManagerEvent.java,v 1.1 2002/02/13 23:36:46 cney Exp $
 *-----------------------------------------------------------------------------
 */
package org.objectweb.transaction.jta;

import javax.transaction.Transaction;
import javax.transaction.SystemException;

/**
 * A <code>ResourceManagerEvent</code> allows late enrolment of connections that
 * are opened in the thread before the transaction starts. <br />
 * 
 * Resource Managers that supports this feature may send events implementing
 * this interface to a registered <code>ResourceManagerEventListener<code>.
 * 
 * @author Christophe Ney cney@batisseurs.com for Lutris Technologies
 */
public interface ResourceManagerEvent {

    /**
     * This method is used by the transaction manager to perform callbacks
     * on the resource manager when a transaction begins.
     * 
     * @param transaction the transaction that has begun
     * @throws SystemException if an exception occurs
     */
    void enlistConnection(Transaction transaction) throws SystemException;
}
