/*
 * @(#) TMService.java
 *
 * JOTM: Java Open Transaction Manager
 * 
 * This module was originally developed by 
 *  - INRIA inside the ObjectWeb Consortium(http://www.objectweb.org)
 *    
 * The original code and portions created by INRIA are 
 * Copyright (C) 2002 - INRIA (www.inria.fr)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * -Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer. 
 *
 * -Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * --------------------------------------------------------------------------
 * $Id: JTAClientTransactionInterceptor.java,v 1.5 2003/12/05 20:24:18 degolf Exp $
 * --------------------------------------------------------------------------
 */
 
 package org.objectweb.transaction.jta;

import org.objectweb.jotm.TransactionRecovery;
import org.objectweb.jotm.TransactionSynchronizationRegistryImpl;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;

/**
 * A <code>TMService</code> represents a JTA Service and is used to acces JTA
 * main interfaces (<code>UserTransaction</code> and
 * <code>TransactionManager</code>).
 * 
 * @author jmesnil
 */
public interface TMService {

    /**
     * returns a <code>TransactionManager</code> object.
     * 
     * @return TransactionManager
     */
    TransactionManager getTransactionManager();
    
    /**
     * returns a <code>TransactionRecoveryImpl</code> object.
     * 
     * @return TransactionRecovery
     */
    TransactionRecovery getTransactionRecovery();

    /**
     * Returns an <code>UserTransaction</code> object.
     * 
     * @return UserTransaction 
     */
    UserTransaction getUserTransaction();

    /**
     * Returns an <code>TransactionSynchronizationRegistry</code> object.
     * 
     * @return TransactionSynchronizationRegistry 
     */
    TransactionSynchronizationRegistryImpl getTransactionSynchronizationRegistry();

    /**
     * Stops the transaction service.
     */
    void stop();

}