/**
 * Kerneos
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.kerneos.common.config;

import org.ow2.kerneos.common.config.generated.Module;
import org.ow2.kerneos.common.config.generated.ModuleFragment;

import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(XmlAccessType.FIELD)
public class ServiceBase {
    private Module module = null;

    private ModuleFragment moduleFragment = null;

    public Module getModule() {
        return module;
    }

    public boolean isSetModule() {
        return module != null;
    }

    public ModuleFragment getModuleFragment() {
        return moduleFragment;
    }

    public boolean isSetModuleFragment() {
        return moduleFragment != null;
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent instanceof Module) {
            this.module = (Module) parent;
        } else if (parent instanceof ModuleFragment) {
            this.moduleFragment = (ModuleFragment) parent;
        }
    }
}
